/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.CountResultVO;
import com.digiwin.dap.middleware.cac.domain.OrderInfoVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.Operate;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeQueryService;
import com.digiwin.dap.middleware.cac.service.business.UseCountService;
import com.digiwin.dap.middleware.cac.service.business.UserCountService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.cac.support.validate.AuthorizeValidationService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cac/v4/counting"})
public class CountingTenantController {
    @Autowired
    private UserCountService userCountService;
    @Autowired
    private UseCountService useCountService;
    @Autowired
    private AuthorizeQueryService authorizeQueryService;
    @Autowired
    private AuthorizeValidationService authorizeValidationService;
    @Autowired
    private IamService iamService;

    @GetMapping(value={"/query/currenttenant/goods/{goodsCode}/module/{moduleId}"})
    public ResponseEntity<?> getCounting(@PathVariable(value="goodsCode") String goodsCode, @PathVariable(value="moduleId") String moduleId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        UsageCountResultVO usageCountResultVO = this.useCountService.getAuthorizationCountingResult(authoredUser.getTenantId(), goodsCode, moduleId);
        return new ResponseEntity((Object)usageCountResultVO, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/decrease/bycurrenttenant"})
    public ResponseEntity<?> decreaseCountingByCurrentTenant(@RequestBody OrderInfoVO orderInfoVO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        this.authorizeValidationService.checkOrderInfoVO3(orderInfoVO);
        UsageCountResultVO usageCountResultVO = this.useCountService.decreaseAuthorizationCounting(authoredUser.getTenantId(), orderInfoVO.getGoodsCode(), orderInfoVO.getDecreaseCount());
        return new ResponseEntity((Object)usageCountResultVO, HttpStatus.OK);
    }

    @GetMapping(value={"/currenttenant/goods/{goodsCode}"})
    public ResponseEntity<?> getUsersAuthorization(@PathVariable(value="goodsCode") String goodsCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        List userList = this.userCountService.getUserInCounting(authoredUser.getTenantId(), goodsCode);
        return new ResponseEntity((Object)userList, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/add/bycurrenttenant"})
    public ResponseEntity<?> addUserInCountingByCurrentTenant(@RequestBody OrderInfoVO orderInfoVO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        this.authorizeValidationService.checkOrderInfoVO2(orderInfoVO);
        CountResultVO countResult = this.userCountService.addUser(authoredUser.getTenantId(), orderInfoVO.getCountingId(), orderInfoVO.getUserId());
        return new ResponseEntity((Object)countResult, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/remove/bycurrenttenant"})
    public ResponseEntity<?> removeUserInCountingByCurrentTenant(@RequestBody OrderInfoVO orderInfoVO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        this.authorizeValidationService.checkOrderInfoVO2(orderInfoVO);
        CountResultVO countResult = this.userCountService.removeUser(authoredUser.getTenantId(), orderInfoVO.getCountingId(), orderInfoVO.getUserId());
        return new ResponseEntity((Object)countResult, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/update/bycurrenttenant"})
    public ResponseEntity<?> updateUserInCountingByCurrentTenant(@RequestBody OrderInfoVO orderInfoVO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        this.authorizeValidationService.checkOrderInfoVO1(orderInfoVO);
        CountResultVO countResult = this.userCountService.batchUpdateUser(authoredUser.getTenantId(), orderInfoVO.getCountingId(), orderInfoVO.getUsers());
        return new ResponseEntity((Object)countResult, HttpStatus.OK);
    }

    @GetMapping(value={"/queryByUserId/{tenantId:.+}/{userId:.+}"})
    public ResponseEntity<?> getUsersAuthorizationByUserId(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId) {
        return ResponseEntity.ok((Object)this.authorizeQueryService.getAuthorizations(tenantId, userId));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/remove/{tenantId:.+}/{userId:.+}"})
    public ResponseEntity<?> removeUserInCountingByTenantId(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId) {
        CountResultVO countResultVO = this.userCountService.removeUserByTenantId(tenantId, userId);
        return ResponseEntity.ok((Object)countResultVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/batch/user/update"})
    public StdData batchUpdateUser(@RequestBody OrderInfoVO orderInfoVO) {
        this.authorizeValidationService.checkOrderInfoVO4(orderInfoVO);
        if (!this.iamService.checkSuperAdmin().booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.CAC_USER_PERMISSION_ERROR);
        }
        if (Operate.Delete.toString().equals(orderInfoVO.getType())) {
            return StdData.ok((Object)this.userCountService.batchRemoveUserFromPurchase(UserUtils.getTenantId(), orderInfoVO.getAppId(), orderInfoVO.getUsers()));
        }
        return StdData.ok((Object)this.userCountService.batchAddUser(UserUtils.getTenantId(), orderInfoVO.getAppId(), orderInfoVO.getUsers()));
    }
}

