/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.service.business.EnvService;
import com.digiwin.dap.middleware.cac.service.business.StatisticInvokeLogService;
import com.digiwin.dap.middleware.cac.support.schedule.ScheduleTaskService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class EnvController {
    @Autowired
    private EnvService envService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ScheduleTaskService scheduleTaskService;
    @Autowired
    private StatisticInvokeLogService statisticInvokeLogService;

    @GetMapping(value={"/api/omc/v2/test22"})
    public ResponseEntity<?> tse() throws Exception {
        TimeUnit.HOURS.sleep(1L);
        return ResponseEntity.ok((Object)this.envProperties);
    }

    @GetMapping(value={"/api/v1/ca/env", "/api/cac/v2/env", "/api/cac/v3/env"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getRuntimeEnv() {
        this.envProperties.refresh();
        return ResponseEntity.ok((Object)this.envProperties);
    }

    @RequestMapping(value={"/api/v1/ca/env/health", "/api/cac/v3/env/health"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<?> getHealth() {
        return ResponseEntity.ok(Collections.singletonMap("status", "success"));
    }

    @GetMapping(value={"/api/v1/ca/env/id"})
    public ResponseEntity<?> getId() {
        return new ResponseEntity((Object)this.envService.getIdentity(), HttpStatus.OK);
    }

    @GetMapping(value={"/api/v1/ca/env/mac"})
    public ResponseEntity<?> getMac() {
        return new ResponseEntity((Object)this.envService.getMacAddress(), HttpStatus.OK);
    }

    @GetMapping(value={"/api/v1/ca/env/connectivity"})
    public ResponseEntity<?> getConnectivity() {
        return new ResponseEntity((Object)this.envService.checkInternetConnectivity(), HttpStatus.OK);
    }

    @GetMapping(value={"/api/v1/ca/env/version"})
    public ResponseEntity<?> getVersion() {
        return new ResponseEntity((Object)this.envService.getAssemblyVersion(), HttpStatus.OK);
    }

    @GetMapping(value={"/api/cac/v3/env/health/hash/reload"})
    public ResponseEntity<?> reloadHash() {
        this.envService.reloadHash();
        return ResponseEntity.ok((Object)Boolean.TRUE);
    }

    @Transactional(rollbackOn={Exception.class})
    @GetMapping(value={"/api/cac/v3/env/reload/sid"})
    public ResponseEntity<?> reloadSid(@RequestParam(required=false) Integer num) {
        List customers = this.jdbcTemplate.queryForList("select sid,id from customer where sid is null");
        for (Object map : customers) {
            SnowFlake instance = SnowFlake.getInstance();
            this.jdbcTemplate.execute(String.format("update customer set sid=%s where id='%s'", instance.newId(), map.get("id")));
        }
        List purchases = this.jdbcTemplate.queryForList("select sid,id from purchase where sid is null");
        for (Object map : purchases) {
            SnowFlake instance = SnowFlake.getInstance();
            this.jdbcTemplate.execute(String.format("update purchase set sid=%s where id='%s'", instance.newId(), map.get("id")));
        }
        List purchasecounts = this.jdbcTemplate.queryForList("select sid,purchase_id from purchasecount where sid is null");
        for (Object map : purchasecounts) {
            SnowFlake instance = SnowFlake.getInstance();
            this.jdbcTemplate.execute(String.format("update purchasecount set sid=%s where purchase_id='%s'", instance.newId(), map.get("purchase_id")));
        }
        List purchasemodules = this.jdbcTemplate.queryForList("select sid,purchase_id,module_id from purchasemodule where sid is null");
        for (Map map : purchasemodules) {
            SnowFlake instance = SnowFlake.getInstance();
            this.jdbcTemplate.execute(String.format("update purchasemodule set sid=%s where purchase_id='%s' and module_id='%s'", instance.newId(), map.get("purchase_id"), map.get("module_id")));
        }
        List userincountings = this.jdbcTemplate.queryForList("select sid,purchase_id,user_id from userincounting where sid is null");
        for (Map map : userincountings) {
            SnowFlake instance = SnowFlake.getInstance();
            this.jdbcTemplate.execute(String.format("update userincounting set sid=%s where purchase_id='%s' and user_id='%s'", instance.newId(), map.get("purchase_id"), map.get("user_id")));
        }
        return ResponseEntity.ok((Object)Boolean.TRUE);
    }

    @GetMapping(value={"/api/cac/v3/env/schedule/task/1"})
    public StdData<?> testScheduleTask1() {
        this.scheduleTaskService.configureTasks1();
        return StdData.ok().build();
    }

    @GetMapping(value={"/api/cac/v3/env/schedule/task/2"})
    public StdData<?> testScheduleTask2() {
        this.scheduleTaskService.cleanOverUse();
        return StdData.ok().build();
    }

    @GetMapping(value={"/api/cac/v3/env/schedule/task/4"})
    public StdData<?> testScheduleTask4() {
        this.scheduleTaskService.savePurchaseSnapshot();
        return StdData.ok().build();
    }

    @GetMapping(value={"/api/cac/v3/env/schedule/task/5"})
    public StdData<?> testScheduleTask5(@RequestParam(value="date", required=false) String date) {
        if (StringUtils.hasText((String)date)) {
            LocalDate startDate = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate endDate = startDate.plusDays(1L);
            this.statisticInvokeLogService.statisticDayAndMonthInvokeRecord(startDate, endDate);
        } else {
            this.scheduleTaskService.statisticDayAndMonthInvokeRecord();
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/api/cac/v3/env/schedule/task/6"})
    public StdData<?> testScheduleTask6() {
        this.scheduleTaskService.usageAlert();
        return StdData.ok().build();
    }

    @GetMapping(value={"/api/cac/v3/env/schedule/task/7"})
    public void test(@RequestParam(required=false) Integer type) throws IOException {
        if (0 == type) {
            this.scheduleTaskService.sendResourceGoodsExpire();
        } else {
            this.scheduleTaskService.updateResourceGoodsExpire();
        }
    }
}

