/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.MessageType;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.cac.domain.GoodsResourceVO;
import com.digiwin.dap.middleware.cac.domain.PurchaseDetailExtVO;
import com.digiwin.dap.middleware.cac.domain.request.GoodsResourceSaveRequest;
import com.digiwin.dap.middleware.cac.entity.GoodsResource;
import com.digiwin.dap.middleware.cac.mapper.PurchaseMapper;
import com.digiwin.dap.middleware.cac.service.basic.DecreaseLogCrudService;
import com.digiwin.dap.middleware.cac.service.basic.GoodsResourceCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cac/v4/resource"})
public class GoodsResourceController {
    @Autowired
    private GoodsResourceCrudService goodsResourceCrudService;
    @Autowired
    private PurchaseMapper purchaseMapper;
    @Autowired
    private DecreaseLogCrudService decreaseLogCrudService;
    @Autowired
    private ProducerService producerService;

    @Transactional
    @PostMapping(value={"/save"})
    public StdData<?> save(@RequestBody GoodsResourceSaveRequest body) {
        this.goodsResourceCrudService.save(body.getGoodsCode(), body.getResourceCodes());
        GoodsResourceVO goodsResourceVO = new GoodsResourceVO();
        goodsResourceVO.setResourceCodes(body.getResourceCodes());
        goodsResourceVO.setGoodsCode(body.getGoodsCode());
        MessageBody messageBody = new MessageBody();
        messageBody.setOpType(MessageType.INTERNAL.name());
        messageBody.setData((Object)goodsResourceVO);
        messageBody.setHeaderTag("resourceGoods");
        this.producerService.internal(messageBody);
        return StdData.ok().build();
    }

    @GetMapping(value={"/purchase/detail"})
    public StdData<?> findPurchaseDetail(@RequestParam(value="purchaseId") String purchaseId) {
        List purchaseDetailExtVOList = this.purchaseMapper.findPurchaseDetailByCondition(purchaseId, "", "", "");
        if (CollectionUtils.isEmpty((Collection)purchaseDetailExtVOList)) {
            return StdData.ok().build();
        }
        PurchaseDetailExtVO purchaseDetailExtVO = (PurchaseDetailExtVO)purchaseDetailExtVOList.get(0);
        List goodsResourceList = this.goodsResourceCrudService.findByResourceCode(purchaseDetailExtVO.getProductCode());
        if (!CollectionUtils.isEmpty((Collection)goodsResourceList)) {
            purchaseDetailExtVO.setAppId(goodsResourceList.stream().map(GoodsResource::getCode).distinct().collect(Collectors.toList()));
        }
        return StdData.ok((Object)purchaseDetailExtVO);
    }

    @PostMapping(value={"/test/task"})
    public StdData<?> testTask(@RequestBody Map<String, String> request) {
        this.decreaseLogCrudService.syncDmcResourceGoodsUseRecord(request.get("startDate"), request.get("endDate"));
        return StdData.ok().build();
    }
}

