/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cac.constant.DecreaseLogEnum;
import com.digiwin.dap.middleware.cac.constant.DecreaseLogOperationTypeEnum;
import com.digiwin.dap.middleware.cac.domain.DecreaseLogExcel;
import com.digiwin.dap.middleware.cac.domain.DevOmInvokeLogDetailExcel;
import com.digiwin.dap.middleware.cac.domain.DevOmInvokeLogExcel;
import com.digiwin.dap.middleware.cac.domain.InvokeLogDetailExcel;
import com.digiwin.dap.middleware.cac.domain.InvokeLogExcel;
import com.digiwin.dap.middleware.cac.domain.InvokeLogVO;
import com.digiwin.dap.middleware.cac.domain.PageResourceDecreaseLogRequest;
import com.digiwin.dap.middleware.cac.domain.SearchDecreaseLogCondition;
import com.digiwin.dap.middleware.cac.domain.SearchInvokeLogCondition;
import com.digiwin.dap.middleware.cac.domain.SearchParamVO;
import com.digiwin.dap.middleware.cac.domain.SearchStatisticInvokeLogCondition;
import com.digiwin.dap.middleware.cac.domain.StatResourceDecreaseLogRequest;
import com.digiwin.dap.middleware.cac.domain.StatisticInvokeLogByAppExcel;
import com.digiwin.dap.middleware.cac.domain.StatisticInvokeLogByProductExcel;
import com.digiwin.dap.middleware.cac.domain.excel.CustomStyleStrategy;
import com.digiwin.dap.middleware.cac.domain.excel.MergeRowStrategy;
import com.digiwin.dap.middleware.cac.domain.excel.RemoveColStrategy;
import com.digiwin.dap.middleware.cac.domain.excel.ResourceDecreaseLogExcel;
import com.digiwin.dap.middleware.cac.domain.excel.ResourceDecreaseLogGroupByExcel;
import com.digiwin.dap.middleware.cac.domain.record.RecordConditionVO;
import com.digiwin.dap.middleware.cac.domain.record.RecordExcel;
import com.digiwin.dap.middleware.cac.domain.record.RecordSourceVO;
import com.digiwin.dap.middleware.cac.domain.record.RecordSyncVO;
import com.digiwin.dap.middleware.cac.domain.record.report.PreOrderRelateCodeVO;
import com.digiwin.dap.middleware.cac.domain.record.report.RecordReportRequestVO;
import com.digiwin.dap.middleware.cac.domain.request.ExportDecreaseLogRequest;
import com.digiwin.dap.middleware.cac.domain.request.ExportInvokeLogDetailRequest;
import com.digiwin.dap.middleware.cac.domain.request.ExportInvokeLogRequest;
import com.digiwin.dap.middleware.cac.domain.request.ExportStatisticInvokeLogByAppRequest;
import com.digiwin.dap.middleware.cac.domain.request.ExportStatisticInvokeLogByProductRequest;
import com.digiwin.dap.middleware.cac.domain.request.RecordDecreaseLogRequest;
import com.digiwin.dap.middleware.cac.domain.request.RecordInvokeLogRequest;
import com.digiwin.dap.middleware.cac.domain.request.SearchDecreaseLogRequest;
import com.digiwin.dap.middleware.cac.domain.request.SearchInvokeLogDevOmRequest;
import com.digiwin.dap.middleware.cac.domain.request.SearchInvokeLogRequest;
import com.digiwin.dap.middleware.cac.domain.request.SearchStatisticInvokeLogByApp4DevOmRequest;
import com.digiwin.dap.middleware.cac.domain.request.SearchStatisticInvokeLogByAppRequest;
import com.digiwin.dap.middleware.cac.domain.request.SearchStatisticInvokeLogByProductRequest;
import com.digiwin.dap.middleware.cac.domain.request.SearchStatisticInvokeLogByTenantRequest;
import com.digiwin.dap.middleware.cac.entity.DecreaseLog;
import com.digiwin.dap.middleware.cac.entity.InvokeLog;
import com.digiwin.dap.middleware.cac.mapper.PurchaseCountMapper;
import com.digiwin.dap.middleware.cac.service.basic.DecreaseLogCrudService;
import com.digiwin.dap.middleware.cac.service.basic.InvokeLogCrudService;
import com.digiwin.dap.middleware.cac.service.basic.RecordCrudService;
import com.digiwin.dap.middleware.cac.service.basic.RecordSourceCrudService;
import com.digiwin.dap.middleware.cac.service.business.DecreaseLogService;
import com.digiwin.dap.middleware.cac.service.business.InvokeLogService;
import com.digiwin.dap.middleware.cac.service.business.RecordService;
import com.digiwin.dap.middleware.cac.service.business.StatisticInvokeLogService;
import com.digiwin.dap.middleware.cac.service.excel.ExcelService;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.cac.util.ExcelExportUtil;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cac/v4/record"})
public class RecordController {
    @Autowired
    private RecordService recordService;
    @Autowired
    private RecordCrudService recordCrudService;
    @Autowired
    private RecordSourceCrudService recordSourceCrudService;
    @Autowired
    private InvokeLogCrudService invokeLogCrudService;
    @Autowired
    private InvokeLogService invokeLogService;
    @Autowired
    private DecreaseLogCrudService decreaseLogCrudService;
    @Autowired
    private StatisticInvokeLogService statisticInvokeLogService;
    @Autowired
    private DecreaseLogService decreaseLogService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private ExcelService excelService;
    @Autowired
    private PurchaseCountMapper purchaseCountMapper;

    @PostMapping(value={"/search"})
    public StdData<?> findByPage(@RequestBody RecordConditionVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setOrderBy(Optional.ofNullable(body.getOrderBy()).orElse("r.sid desc"));
        List records = this.recordCrudService.findByPage(body);
        return StdData.ok((Object)PageSerializable.of((List)records));
    }

    @PostMapping(value={"/app/search"})
    public StdData<?> findByAppPage(@RequestBody RecordConditionVO body) {
        body.setOrderBy(Optional.ofNullable(body.getOrderBy()).orElse("r.sid desc"));
        body.setGoodsCode(UserUtils.getSysId());
        List records = this.recordCrudService.findByPage(body);
        return StdData.ok((Object)PageSerializable.of((List)records));
    }

    @PostMapping(value={"/source"})
    public StdData<?> recordSource(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List sources = this.recordSourceCrudService.findAll();
        ArrayList results = new ArrayList();
        sources.forEach(source -> {
            RecordSourceVO recordSourceVO = new RecordSourceVO();
            recordSourceVO.doBackward(source);
            results.add(recordSourceVO);
        });
        return StdData.ok(results);
    }

    @PostMapping(value={"/export"})
    public void export(@RequestBody RecordConditionVO body, HttpServletResponse response) throws Exception {
        List recordExcels = this.recordService.exportRecord(body);
        InputStream inputStream = Locale.TRADITIONAL_CHINESE.equals(LocaleContextHolder.getLocale()) ? this.getClass().getResourceAsStream("/static/templates/authorization_record_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/authorization_record_CN.xlsx");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u6388\u6743\u5f02\u52a8\u660e\u7ec6_" + LocalDate.now(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        if (body.getContainModule().booleanValue()) {
            Stream<Integer> integerStream = IntStream.rangeClosed(1, recordExcels.size()).boxed();
            Map<Integer, Long> dataRows = integerStream.collect(Collectors.toMap(i -> i, i -> ((RecordExcel)recordExcels.get(i - 1)).getSid(), (a, b) -> b));
            ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), RecordExcel.class).excelType(ExcelTypeEnum.XLSX).autoCloseStream(Boolean.TRUE).registerWriteHandler((WriteHandler)new MergeRowStrategy(dataRows, 9))).registerWriteHandler((WriteHandler)CustomStyleStrategy.getMergeStyleStrategy())).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(recordExcels);
        } else {
            ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), RecordExcel.class).registerWriteHandler((WriteHandler)CustomStyleStrategy.getStyleStrategy())).registerWriteHandler((WriteHandler)new RemoveColStrategy(9))).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(recordExcels);
        }
    }

    @PostMapping(value={"/report"})
    public StdData<?> recordSource(@RequestBody RecordReportRequestVO request) {
        return StdData.ok((Object)new PageInfo(this.recordService.queryReport(request)));
    }

    @PostMapping(value={"/relate/code"})
    public StdData<?> relateCode(@RequestBody PreOrderRelateCodeVO request) {
        return StdData.ok((Object)this.recordService.queryRelateCodeReport(request));
    }

    @PostMapping(value={"/sync"})
    public StdData<?> mod(@RequestBody RecordSyncVO body) {
        this.recordService.sync(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/invoke/log"})
    public StdData<?> recordInvokeLog(@RequestBody RecordInvokeLogRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys, HttpServletRequest httpServletRequest) {
        String appTenantId = null;
        String secretKey = httpServletRequest.getHeader(DapHttpHeaders.SECRET_KEY.getHeader());
        if (secretKey != null) {
            String[] content = AES.decryptCBC((String)secretKey, (String)KeyConstant.OTHER).split("@#\\$%\\^_");
            if (content.length != 4) {
                throw new BusinessException("\u975e\u6cd5\u6388\u6743\u7801\uff1a" + secretKey);
            }
            appTenantId = content[0];
        }
        request.valid();
        InvokeLog invokeLog = new InvokeLog();
        invokeLog.setLogId(request.getLogId());
        invokeLog.setAppId(request.getAppId());
        invokeLog.setRequestStatus(request.getRequestStatus());
        invokeLog.setRequestInfo(request.getRequestInfo());
        invokeLog.setTenantId(authoredUser.getTenantId());
        invokeLog.setTenantName(authoredUser.getTenantName());
        invokeLog.setUserId(authoredUser.getUserId());
        invokeLog.setUserName(authoredUser.getUserName());
        invokeLog.setProductCode(request.getProductCode());
        invokeLog.setAppTenantId(appTenantId);
        this.invokeLogCrudService.create((BaseEntity)invokeLog);
        return StdData.ok().build();
    }

    @PostMapping(value={"/decrease/log"})
    public StdData<?> recordDecreaseLog(@RequestBody RecordDecreaseLogRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys, HttpServletRequest httpServletRequest) {
        String appTenantId = null;
        String secretKey = httpServletRequest.getHeader(DapHttpHeaders.SECRET_KEY.getHeader());
        if (secretKey != null) {
            String[] content = AES.decryptCBC((String)secretKey, (String)KeyConstant.OTHER).split("@#\\$%\\^_");
            if (content.length != 4) {
                throw new BusinessException("\u975e\u6cd5\u6388\u6743\u7801\uff1a" + secretKey);
            }
            appTenantId = content[0];
        }
        request.valid();
        DecreaseLog decreaseLog = new DecreaseLog();
        decreaseLog.setLogId(request.getLogId());
        decreaseLog.setProductCode(request.getProductCode());
        decreaseLog.setAppId(request.getAppId());
        decreaseLog.setTenantId(authoredUser.getTenantId());
        decreaseLog.setTenantName(authoredUser.getTenantName());
        decreaseLog.setAppTenantId(appTenantId);
        decreaseLog.setDecreaseCount(request.getDecreaseCount());
        this.decreaseLogCrudService.create((BaseEntity)decreaseLog);
        return StdData.ok().build();
    }

    @GetMapping(value={"/month/invoke/log/search/product"})
    public StdData<?> searchStatisticInvokeLogByProduct(Page page, SearchStatisticInvokeLogByProductRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) {
        request.valid();
        SearchStatisticInvokeLogCondition condition = request.toSearchStatisticInvokeLogCondition();
        PageSerializable list = this.statisticInvokeLogService.searchProductMonthInvokeLogsByCondition(page, condition);
        return StdData.ok((Object)list);
    }

    @PostMapping(value={"/month/invoke/log/export/product"})
    public void exportStatisticInvokeLogByProduct(@RequestBody ExportStatisticInvokeLogByProductRequest request, HttpServletResponse response, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) throws Exception {
        request.valid();
        SearchStatisticInvokeLogCondition condition = request.toSearchStatisticInvokeLogCondition();
        List list = this.statisticInvokeLogService.searchProductMonthInvokeLogsByCondition(condition);
        List<Object> invokeLogExcelList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            invokeLogExcelList = list.stream().map(StatisticInvokeLogByProductExcel::new).collect(Collectors.toList());
        }
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode(String.format("\u8c03\u7528\u7edf\u8ba1%s", Optional.ofNullable(request.getMonth()).orElse("")), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), StatisticInvokeLogByProductExcel.class).sheet("Sheet1").doWrite(invokeLogExcelList);
    }

    @GetMapping(value={"/month/invoke/log/search/app"})
    public StdData<?> searchStatisticInvokeLogByApp(Page page, SearchStatisticInvokeLogByAppRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) {
        request.valid();
        SearchStatisticInvokeLogCondition condition = request.toSearchStatisticInvokeLogCondition();
        PageSerializable list = this.statisticInvokeLogService.searchAppMonthInvokeLogsByCondition(page, condition);
        return StdData.ok((Object)list);
    }

    @PostMapping(value={"/month/invoke/log/export/app"})
    public void exportStatisticInvokeLogByApp(@RequestBody ExportStatisticInvokeLogByAppRequest request, HttpServletResponse response, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) throws Exception {
        request.valid();
        SearchStatisticInvokeLogCondition condition = request.toSearchStatisticInvokeLogCondition();
        List list = this.statisticInvokeLogService.searchAppMonthInvokeLogsByCondition(condition);
        List<Object> invokeLogExcelList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            invokeLogExcelList = list.stream().map(StatisticInvokeLogByAppExcel::new).collect(Collectors.toList());
        }
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode(String.format("%s\u8c03\u7528\u7edf\u8ba1%s", request.getProductName(), request.getMonth()), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), StatisticInvokeLogByAppExcel.class).sheet("Sheet1").doWrite(invokeLogExcelList);
    }

    @GetMapping(value={"/month/invoke/log/search/tenant"})
    public StdData<?> searchStatisticInvokeLogByTenant(Page page, SearchStatisticInvokeLogByTenantRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) {
        request.valid();
        SearchStatisticInvokeLogCondition condition = request.toSearchStatisticInvokeLogCondition();
        condition.setAppTenantId(authoredUser.getTenantId());
        PageSerializable list = this.statisticInvokeLogService.searchTenantMonthInvokeLogsByCondition(page, condition);
        return StdData.ok((Object)list);
    }

    @PostMapping(value={"/invoke/log/detail/export"})
    public void exportDetail(@RequestBody ExportInvokeLogDetailRequest request, HttpServletResponse response, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) throws Exception {
        request.valid();
        SearchInvokeLogCondition condition = new SearchInvokeLogCondition();
        condition.setAppTenantId(authoredUser.getTenantId());
        condition.setProductCode(request.getProductCode());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate date = LocalDate.parse(request.getMonth() + "-01", formatter);
        LocalDateTime startDate = date.atStartOfDay();
        LocalDateTime endDate = startDate.plusMonths(1L).minusSeconds(1L);
        condition.setStartDate(startDate);
        condition.setEndDate(endDate);
        List invokeLogVOList = this.invokeLogService.searchByCondition(condition);
        List<Object> invokeLogDetailExcelList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)invokeLogVOList)) {
            invokeLogDetailExcelList = invokeLogVOList.stream().map(InvokeLogDetailExcel::new).collect(Collectors.toList());
        }
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode(String.format("%s--%s\u8c03\u7528\u660e\u7ec6", request.getProductName(), request.getMonth()), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), InvokeLogDetailExcel.class).sheet(Integer.valueOf(0)).doWrite(invokeLogDetailExcelList);
    }

    @GetMapping(value={"/invoke/log/search"})
    public StdData<?> searchInvokeLog(Page page, SearchInvokeLogRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) {
        request.valid();
        SearchInvokeLogCondition condition = request.toSearchInvokeLogCondition();
        PageSerializable list = this.invokeLogService.searchByCondition(page, condition);
        return StdData.ok((Object)list);
    }

    @PostMapping(value={"/invoke/log/export"})
    public void exportStatisticInvokeLogByApp(@RequestBody ExportInvokeLogRequest request, HttpServletResponse response, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) throws Exception {
        request.valid();
        SearchInvokeLogCondition condition = request.toSearchInvokeLogCondition();
        List list = this.invokeLogService.searchByCondition(condition);
        List<Object> invokeLogExcelList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            invokeLogExcelList = list.stream().map(InvokeLogExcel::new).collect(Collectors.toList());
        }
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode(String.format("\u8c03\u7528\u660e\u7ec6%s~%s", request.getStartDate(), request.getEndDate()), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), InvokeLogExcel.class).sheet("Sheet1").doWrite(invokeLogExcelList);
    }

    @GetMapping(value={"/decrease/log/search"})
    public StdData<?> searchDecreaseLog(Page page, SearchDecreaseLogRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) {
        request.valid();
        SearchDecreaseLogCondition searchDecreaseLogCondition = request.toSearchDecreaseLogCondition();
        PageSerializable list = this.decreaseLogService.searchByCondition(page, searchDecreaseLogCondition);
        return StdData.ok((Object)list);
    }

    @PostMapping(value={"/decrease/log/export"})
    public void exportStatisticInvokeLogByApp(@RequestBody ExportDecreaseLogRequest request, HttpServletResponse response, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) throws Exception {
        request.valid();
        SearchDecreaseLogCondition searchDecreaseLogCondition = request.toSearchDecreaseLogCondition();
        List list = this.decreaseLogService.searchByCondition(searchDecreaseLogCondition);
        List<Object> invokeLogExcelList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            invokeLogExcelList = list.stream().map(DecreaseLogExcel::new).collect(Collectors.toList());
        }
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode(String.format("\u6263\u51cf\u660e\u7ec6%s~%s", request.getStartDate(), request.getEndDate()), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), DecreaseLogExcel.class).sheet("Sheet1").doWrite(invokeLogExcelList);
    }

    @GetMapping(value={"/request/info/find"})
    public StdData<?> getRequestInfoByLogId(@RequestParam(value="logId") String logId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) {
        InvokeLogVO invokeLogVO = this.invokeLogService.queryByLogId(logId);
        return StdData.ok((Object)invokeLogVO);
    }

    @CacheLock
    @PostMapping(value={"/invoke/log/sync/now"})
    public StdData<?> syncNow(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) {
        LocalDate today = LocalDate.now();
        LocalDate tomorrow = today.plusDays(1L);
        this.statisticInvokeLogService.statisticDayAndMonthInvokeRecord(today, tomorrow);
        return StdData.ok().build();
    }

    @GetMapping(value={"/resource/decrease/log/search"})
    public StdData<?> searchResourceDecreaseLog(Page page, PageResourceDecreaseLogRequest request) {
        SearchDecreaseLogCondition searchDecreaseLogCondition = new SearchDecreaseLogCondition();
        searchDecreaseLogCondition.setAppInfo(request.getAppId());
        searchDecreaseLogCondition.setProductCode(request.getProductCode());
        searchDecreaseLogCondition.setAppTenantId(request.getTenantId());
        searchDecreaseLogCondition.setUnitConversionContent(request.getUnitConversion());
        if (StringUtils.hasLength((String)request.getStartDate()) && StringUtils.hasLength((String)request.getEndDate())) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate startDate = LocalDate.parse(request.getStartDate(), formatter);
            LocalDateTime startDateTime = startDate.atTime(0, 0, 0);
            LocalDate endDate = LocalDate.parse(request.getEndDate(), formatter);
            LocalDateTime endDateTime = endDate.atTime(23, 59, 59);
            searchDecreaseLogCondition.setStartDate(startDateTime);
            searchDecreaseLogCondition.setEndDate(endDateTime);
        } else {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime oneMonthAgo = now.minusMonths(1L);
            searchDecreaseLogCondition.setStartDate(now);
            searchDecreaseLogCondition.setEndDate(oneMonthAgo);
        }
        searchDecreaseLogCondition.setType(DecreaseLogEnum.RESOURCE.getCode());
        PageSerializable list = this.decreaseLogService.searchByCondition(page, searchDecreaseLogCondition);
        list.getList().forEach(decreaseLogVO -> {
            decreaseLogVO.setTenantId(decreaseLogVO.getAppTenantId());
            decreaseLogVO.setTenantName(decreaseLogVO.getAppTenantName());
        });
        return StdData.ok((Object)list);
    }

    @PostMapping(value={"/resource/decrease/log/export"})
    public void resourceDecreaseLogExport(@RequestBody SearchDecreaseLogCondition condition, HttpServletResponse response) {
        condition.setType(DecreaseLogEnum.RESOURCE.getCode());
        this.excelService.exportResourceDecreaseLog(condition, response);
    }

    @GetMapping(value={"/resource/decrease/log/stat"})
    public StdData<?> statResourceDecreaseLog(Page page, StatResourceDecreaseLogRequest request) {
        SearchDecreaseLogCondition searchDecreaseLogCondition = new SearchDecreaseLogCondition();
        searchDecreaseLogCondition.setProductInfo(request.getProductInfo());
        searchDecreaseLogCondition.setAppInfo(request.getAppId());
        searchDecreaseLogCondition.setAppTenantId(request.getTenantInfo());
        searchDecreaseLogCondition.setType(DecreaseLogEnum.RESOURCE.getCode());
        searchDecreaseLogCondition.setOperationType(DecreaseLogOperationTypeEnum.DEDUCT.getCode());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate startDate = LocalDate.parse(request.getStartDate(), formatter);
        LocalDateTime startDateTime = startDate.atTime(0, 0, 0);
        LocalDate endDate = LocalDate.parse(request.getEndDate(), formatter);
        LocalDateTime endDateTime = endDate.atTime(23, 59, 59);
        searchDecreaseLogCondition.setStartDate(startDateTime);
        searchDecreaseLogCondition.setEndDate(endDateTime);
        PageSerializable decreaseLogVOPageSerializable = this.decreaseLogService.searchByConditionAndGroundByUser(page, searchDecreaseLogCondition);
        decreaseLogVOPageSerializable.getList().forEach(decreaseLogVO -> {
            decreaseLogVO.setTenantId(decreaseLogVO.getAppTenantId());
            decreaseLogVO.setTenantName(decreaseLogVO.getAppTenantName());
        });
        return StdData.ok((Object)decreaseLogVOPageSerializable);
    }

    @PostMapping(value={"/resource/decrease/log/stat/export"})
    public void statResourceDecreaseLogExport(@RequestBody StatResourceDecreaseLogRequest request, HttpServletResponse response) throws Exception {
        SearchDecreaseLogCondition searchDecreaseLogCondition = new SearchDecreaseLogCondition();
        searchDecreaseLogCondition.setProductInfo(request.getProductInfo());
        searchDecreaseLogCondition.setAppInfo(request.getAppId());
        searchDecreaseLogCondition.setAppTenantId(request.getTenantInfo());
        searchDecreaseLogCondition.setType(DecreaseLogEnum.RESOURCE.getCode());
        searchDecreaseLogCondition.setOperationType(Integer.valueOf(1));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate startDate = LocalDate.parse(request.getStartDate(), formatter);
        LocalDateTime startDateTime = startDate.atTime(0, 0, 0);
        LocalDate endDate = LocalDate.parse(request.getEndDate(), formatter);
        LocalDateTime endDateTime = endDate.atTime(23, 59, 59);
        searchDecreaseLogCondition.setStartDate(startDateTime);
        searchDecreaseLogCondition.setEndDate(endDateTime);
        Page page = new Page();
        page.setPageNum(request.getPageNum());
        page.setPageSize(request.getPageSize());
        PageSerializable pageSerializable = this.decreaseLogService.searchByConditionAndGroundByUser(page, searchDecreaseLogCondition);
        if (Objects.isNull(pageSerializable) || CollectionUtils.isEmpty((Collection)pageSerializable.getList())) {
            return;
        }
        List decreaseLogVOList = pageSerializable.getList();
        decreaseLogVOList.forEach(decreaseLogVO -> {
            decreaseLogVO.setTenantId(decreaseLogVO.getAppTenantId());
            decreaseLogVO.setTenantName(decreaseLogVO.getAppTenantName());
        });
        List resourceDecreaseLogGroupByExcels = decreaseLogVOList.stream().map(ResourceDecreaseLogGroupByExcel::new).collect(Collectors.toList());
        InputStream inputStream = Locale.TRADITIONAL_CHINESE.equals(LocaleContextHolder.getLocale()) ? this.getClass().getResourceAsStream("/static/templates/resource_decrease_log_stat_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/resource_decrease_log_stat_CN.xlsx");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u8ba1\u91cf\u5546\u54c1\u4f7f\u7528\u60c5\u51b5_" + LocalDate.now(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), ResourceDecreaseLogGroupByExcel.class).excelType(ExcelTypeEnum.XLSX).autoCloseStream(Boolean.TRUE).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(resourceDecreaseLogGroupByExcels);
    }

    @GetMapping(value={"/resource/decrease/log/stat/details"})
    public StdData<?> statResourceDecreaseLogDetails(Page page, StatResourceDecreaseLogRequest request) {
        SearchDecreaseLogCondition searchDecreaseLogCondition = new SearchDecreaseLogCondition();
        searchDecreaseLogCondition.setProductInfo(request.getProductInfo());
        searchDecreaseLogCondition.setAppInfo(request.getAppId());
        searchDecreaseLogCondition.setAppTenantId(request.getTenantInfo());
        searchDecreaseLogCondition.setType(DecreaseLogEnum.RESOURCE.getCode());
        searchDecreaseLogCondition.setOperationType(Integer.valueOf(1));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate startDate = LocalDate.parse(request.getStartDate(), formatter);
        LocalDateTime startDateTime = startDate.atTime(0, 0, 0);
        LocalDate endDate = LocalDate.parse(request.getEndDate(), formatter);
        LocalDateTime endDateTime = endDate.atTime(23, 59, 59);
        searchDecreaseLogCondition.setStartDate(startDateTime);
        searchDecreaseLogCondition.setEndDate(endDateTime);
        PageSerializable decreaseLogVOPageSerializable = this.decreaseLogService.searchByCondition(page, searchDecreaseLogCondition);
        decreaseLogVOPageSerializable.getList().forEach(decreaseLogVO -> {
            decreaseLogVO.setTenantId(decreaseLogVO.getAppTenantId());
            decreaseLogVO.setTenantName(decreaseLogVO.getAppTenantName());
        });
        return StdData.ok((Object)decreaseLogVOPageSerializable);
    }

    @PostMapping(value={"/resource/decrease/log/stat/details/export"})
    public void statResourceDecreaseLogDetailsExport(@RequestBody StatResourceDecreaseLogRequest request, HttpServletResponse response) throws Exception {
        SearchDecreaseLogCondition searchDecreaseLogCondition = new SearchDecreaseLogCondition();
        searchDecreaseLogCondition.setProductInfo(request.getProductInfo());
        searchDecreaseLogCondition.setAppInfo(request.getAppId());
        searchDecreaseLogCondition.setAppTenantId(request.getTenantInfo());
        searchDecreaseLogCondition.setType(DecreaseLogEnum.RESOURCE.getCode());
        searchDecreaseLogCondition.setOperationType(Integer.valueOf(1));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate startDate = LocalDate.parse(request.getStartDate(), formatter);
        LocalDateTime startDateTime = startDate.atTime(0, 0, 0);
        LocalDate endDate = LocalDate.parse(request.getEndDate(), formatter);
        LocalDateTime endDateTime = endDate.atTime(23, 59, 59);
        searchDecreaseLogCondition.setStartDate(startDateTime);
        searchDecreaseLogCondition.setEndDate(endDateTime);
        List decreaseLogVOList = this.decreaseLogService.searchByCondition(searchDecreaseLogCondition);
        decreaseLogVOList.forEach(decreaseLogVO -> {
            decreaseLogVO.setTenantId(decreaseLogVO.getAppTenantId());
            decreaseLogVO.setTenantName(decreaseLogVO.getAppTenantName());
        });
        List<Object> resourceDecreaseLogExcels = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)decreaseLogVOList)) {
            resourceDecreaseLogExcels = decreaseLogVOList.stream().map(ResourceDecreaseLogExcel::new).collect(Collectors.toList());
        }
        InputStream inputStream = Locale.TRADITIONAL_CHINESE.equals(LocaleContextHolder.getLocale()) ? this.getClass().getResourceAsStream("/static/templates/resource_decrease_log_stat_detail_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/resource_decrease_log_stat_detail_CN.xlsx");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u8ba1\u91cf\u5546\u54c1\u4f7f\u7528\u660e\u7ec6\u60c5\u51b5_" + LocalDate.now(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), ResourceDecreaseLogExcel.class).excelType(ExcelTypeEnum.XLSX).autoCloseStream(Boolean.TRUE).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(resourceDecreaseLogExcels);
    }

    @GetMapping(value={"/invoke/log/stat/search"})
    public StdData<?> searchInvokeLogDevOm(Page page, SearchInvokeLogDevOmRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) {
        List isvGoodsCodes = this.gmcService.getIsvGoods(authoredUser.getTenantId());
        PageSerializable list = new PageSerializable();
        if (!CollectionUtils.isEmpty((Collection)isvGoodsCodes)) {
            request.setGoodsCodes(isvGoodsCodes);
            list = this.statisticInvokeLogService.searchDevOmByCondition(page, request);
        }
        return StdData.ok((Object)list);
    }

    @GetMapping(value={"/invoke/log/stat/goods"})
    public StdData<?> searchInvokeLogDevOmDetail(Page page, SearchStatisticInvokeLogByApp4DevOmRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys) {
        request.valid();
        SearchStatisticInvokeLogCondition condition = request.toSearchStatisticInvokeLogCondition();
        PageSerializable list = this.statisticInvokeLogService.searchAppMonthInvokeLogsByCondition4DevOm(page, condition);
        return StdData.ok((Object)list);
    }

    @GetMapping(value={"/invoke/log/stat/search/export"})
    public void searchInvokeLogDevOmExport(Page page, SearchInvokeLogDevOmRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys, HttpServletResponse response) throws IOException {
        List isvGoodsCodes = this.gmcService.getIsvGoods(authoredUser.getTenantId());
        PageSerializable pageResult = new PageSerializable();
        if (!CollectionUtils.isEmpty((Collection)isvGoodsCodes)) {
            request.setGoodsCodes(isvGoodsCodes);
            pageResult = this.statisticInvokeLogService.searchDevOmByCondition(page, request);
        }
        List list = pageResult.getList();
        List<Object> excelList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            excelList = list.stream().map(DevOmInvokeLogExcel::new).collect(Collectors.toList());
        }
        ExcelExportUtil.exportExcel((HttpServletResponse)response, (String)"API\u8ba2\u9605\u7edf\u8ba1", DevOmInvokeLogExcel.class, excelList);
    }

    @GetMapping(value={"/invoke/log/stat/goods/export"})
    public void searchInvokeLogDevOmDetailExport(Page page, SearchStatisticInvokeLogByApp4DevOmRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys authoredSys, HttpServletResponse response) throws IOException {
        request.valid();
        SearchStatisticInvokeLogCondition condition = request.toSearchStatisticInvokeLogCondition();
        PageSerializable pageResult = this.statisticInvokeLogService.searchAppMonthInvokeLogsByCondition4DevOm(page, condition);
        List list = pageResult.getList();
        List<Object> excelList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            excelList = list.stream().map(DevOmInvokeLogDetailExcel::new).collect(Collectors.toList());
        }
        ExcelExportUtil.exportExcel((HttpServletResponse)response, (String)"API\u8ba2\u9605\u7edf\u8ba1\u8be6\u60c5", DevOmInvokeLogDetailExcel.class, excelList);
    }

    @GetMapping(value={"/purchase/log/search"})
    public StdData getPurchaseCountLog(SearchParamVO searchParamVO) {
        return StdData.ok((Object)this.purchaseCountMapper.getLogsByCon(searchParamVO));
    }
}

