/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.digiwin.dap.middleware.cac.domain.unitconversion.dto.MergeUnitConversionDTO;
import com.digiwin.dap.middleware.cac.domain.unitconversion.request.MergeUnitConversionRequest;
import com.digiwin.dap.middleware.cac.service.basic.UnitConversionService;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cac/v4/unit/conversion"})
public class UnitConversionController {
    @Autowired
    private UnitConversionService unitConversionService;

    @PostMapping(value={"/merge"})
    public StdData<?> mergeUnitConversion(@RequestBody MergeUnitConversionRequest request) {
        Long sid = this.unitConversionService.compareAndSaveUnitConversion(this.buildMergeUnitConversionDTO(request));
        return StdData.ok((Object)sid);
    }

    @GetMapping(value={"/del"})
    public StdData<?> delUnitConversion(@RequestParam(value="id") String id, @RequestParam(value="goodsCode") String goodsCode) {
        this.unitConversionService.deleteUnitConversion(id, goodsCode);
        return StdData.ok().build();
    }

    @GetMapping(value={"/check/del"})
    public StdData<?> findDecreaseLogByGoodsCodeAndUnitConversionId(@RequestParam(value="id") String id, @RequestParam(value="goodsCode") String goodsCode) {
        List decreaseLogList = this.unitConversionService.findDecreaseLogByGoodsCodeAndUnitConversionId(goodsCode, id);
        return StdData.ok((Object)CollectionUtils.isEmpty((Collection)decreaseLogList));
    }

    public MergeUnitConversionDTO buildMergeUnitConversionDTO(MergeUnitConversionRequest request) {
        if (request == null) {
            return null;
        }
        MergeUnitConversionDTO mergeUnitConversionDTO = new MergeUnitConversionDTO();
        mergeUnitConversionDTO.setSid(request.getSid());
        mergeUnitConversionDTO.setId(request.getId());
        mergeUnitConversionDTO.setName(request.getName());
        mergeUnitConversionDTO.setConversionPoint(request.getConversionPoint());
        mergeUnitConversionDTO.setDescription(request.getDescription());
        mergeUnitConversionDTO.setGoodsCode(request.getGoodsCode());
        mergeUnitConversionDTO.setCreateBy(request.getCreateBy());
        mergeUnitConversionDTO.setCreateById(request.getCreateById());
        mergeUnitConversionDTO.setCreateDate(request.getCreateDate());
        mergeUnitConversionDTO.setModifyBy(request.getModifyBy());
        mergeUnitConversionDTO.setModifyById(request.getModifyById());
        mergeUnitConversionDTO.setModifyDate(request.getModifyDate());
        return mergeUnitConversionDTO;
    }
}

