/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.AuthorizationCheckedVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleWithPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.CountResultVO;
import com.digiwin.dap.middleware.cac.domain.CustomAttributeWithPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.TenantPurchaseVO;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeArchiveService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeOtherService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeQueryService;
import com.digiwin.dap.middleware.cac.service.business.UserCountService;
import com.digiwin.dap.middleware.cac.support.validate.AuthorizeValidationService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cac/v3/authorizations"})
public class V3AuthorizationsController {
    @Autowired
    private AuthorizeOtherService authorizeOtherService;
    @Autowired
    private AuthorizeQueryService authorizeQueryService;
    @Autowired
    private AuthorizeArchiveService authorizeArchiveService;
    @Autowired
    private AuthorizeValidationService authorizeValidationService;
    @Autowired
    private UserCountService userCountService;

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={""})
    public ResponseEntity<?> purchaseAuthorization(@RequestBody TenantPurchaseVO input) {
        if (0 == input.getAction()) {
            this.authorizeValidationService.checkTenantPurchaseVO(input);
            this.authorizeArchiveService.purchaseAuthorization(input);
        } else if (1 == input.getAction()) {
            this.authorizeValidationService.checkUserAuthPurchaseVO(input);
            String goodsCode = ((PurchaseVO)input.getAuthorizations().get(0)).getCode();
            CountResultVO countResult = this.userCountService.batchAddUsers(input.getTenantId(), goodsCode, input.getUserIds());
            if (!countResult.getSuccess().booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10013, new Object[]{countResult.getTotalCount(), countResult.getCurrentCount()});
            }
            return ResponseEntity.ok((Object)countResult);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @GetMapping(value={""})
    public ResponseEntity<?> getAuthorizations() {
        return ResponseEntity.ok((Object)this.authorizeQueryService.getAuthorizationInfos());
    }

    @GetMapping(value={"/{tenantId:.+}"})
    public ResponseEntity<?> getAuthorizationByTenantId(@PathVariable(value="tenantId") String tenantId) {
        return ResponseEntity.ok((Object)this.authorizeQueryService.getAuthorizations(tenantId));
    }

    @GetMapping(value={"/{tenantId:.+}/{goodsCode}"})
    public ResponseEntity<?> getAuthorizationByTenantIdAndGoodsCode(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode) {
        return ResponseEntity.ok((Object)this.authorizeQueryService.getAuthorization(tenantId, goodsCode));
    }

    @GetMapping(value={"/{tenantId:.+}/{goodsCode}/modules"})
    public ResponseEntity<?> getModulesByTenantIdAndGoodsCode(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode) {
        AuthorizationModuleWithPurchaseVO authorizationModuleWithPurchaseVO = this.authorizeArchiveService.getAuthorizationModule(tenantId, goodsCode);
        return new ResponseEntity((Object)authorizationModuleWithPurchaseVO, HttpStatus.OK);
    }

    @GetMapping(value={"/{tenantId:.+}/{goodsCode}/customAttributes"})
    public ResponseEntity<?> getAttributesByTenantIdAndGoodsCode(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode) {
        CustomAttributeWithPurchaseVO customAttributeWithPurchaseVO = this.authorizeArchiveService.getAuthorizationCustomAttribute(tenantId, goodsCode);
        return new ResponseEntity((Object)customAttributeWithPurchaseVO, HttpStatus.OK);
    }

    @GetMapping(value={"/{tenantId:.+}/{userId:.+}/enabled"})
    public ResponseEntity<?> getGoodsCodeByTenantIdAndUserId(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId) {
        return ResponseEntity.ok((Object)this.authorizeOtherService.findGoodsCode(tenantId, userId));
    }

    @GetMapping(value={"/{tenantId:.+}/{userId:.+}/{goodsCode}"})
    public ResponseEntity<?> checkGoodsAuthorization(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId, @PathVariable(value="goodsCode") String goodsCode) {
        AuthorizationCheckedVO authorizationCheckedVO = this.authorizeArchiveService.checkUserCanUseProduct(tenantId, goodsCode, userId, Boolean.valueOf(true));
        return new ResponseEntity((Object)authorizationCheckedVO, HttpStatus.OK);
    }

    @GetMapping(value={"/{tenantId:.+}/{userId:.+}/{goodsCode}/{moduleId}"})
    public ResponseEntity<?> checkModuleAuthorization(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId, @PathVariable(value="goodsCode") String goodsCode, @PathVariable(value="moduleId") String moduleId) {
        AuthorizationCheckedVO authorizationCheckedVO = this.authorizeArchiveService.checkUserCanUseModule(tenantId, goodsCode, moduleId, userId);
        return new ResponseEntity((Object)authorizationCheckedVO, HttpStatus.OK);
    }

    @GetMapping(value={"/id/{purchaseId}"})
    public ResponseEntity<?> getAuthorizationByPurchaseId(@PathVariable(value="purchaseId") String purchaseId) {
        return ResponseEntity.ok((Object)this.authorizeQueryService.getAuthorization(purchaseId));
    }
}

