/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.digiwin.dap.middleware.cac.constant.DecreaseLogEnum;
import com.digiwin.dap.middleware.cac.constant.DecreaseLogOperationTypeEnum;
import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.CountResultVO;
import com.digiwin.dap.middleware.cac.domain.OrderInfoVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.domain.unitconversion.vo.UnitConversionVO;
import com.digiwin.dap.middleware.cac.entity.DecreaseLog;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.repository.GoodsResourceRepository;
import com.digiwin.dap.middleware.cac.service.basic.DecreaseLogCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.UnitConversionService;
import com.digiwin.dap.middleware.cac.service.business.UseCountService;
import com.digiwin.dap.middleware.cac.service.business.UserCountService;
import com.digiwin.dap.middleware.cac.support.validate.AuthorizeValidationService;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.StringUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cac/v3/counting"})
public class V3CountingController {
    private static final Logger log = LoggerFactory.getLogger(V3CountingController.class);
    @Autowired
    private AuthorizeValidationService authorizeValidationService;
    @Autowired
    private UserCountService userCountService;
    @Autowired
    private UseCountService useCountService;
    @Autowired
    private DecreaseLogCrudService decreaseLogCrudService;
    @Autowired
    private GoodsResourceRepository goodsResourceRepository;
    @Autowired
    private UnitConversionService unitConversionService;
    @Autowired
    private PurchaseCrudService purchaseCrudService;

    @Transactional(rollbackFor={Exception.class})
    @GetMapping(value={"/query/{tenantId:.+}/{goodsCode}/{moduleId}"})
    public ResponseEntity<?> getCounting(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode, @PathVariable(value="moduleId") String moduleId) {
        UsageCountResultVO usageCountResultVO = this.useCountService.getAuthorizationCountingResult(tenantId, goodsCode, moduleId);
        return new ResponseEntity((Object)usageCountResultVO, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/decrease"})
    public ResponseEntity<?> decreaseCounting(@RequestBody OrderInfoVO orderInfoVO, HttpServletRequest request) {
        UsageCountResultVO usageCountResultVO;
        Integer conversionPoint = null;
        Integer decreaseCoount = orderInfoVO.getDecreaseCount();
        if (Objects.equals(orderInfoVO.getType(), DecreaseLogEnum.RESOURCE.getCode().toString())) {
            orderInfoVO.setAppId(UserUtils.getSysId());
            orderInfoVO.setTenantId(UserUtils.getTenantId());
            List resources = this.goodsResourceRepository.findByResourceCodeAndCode(orderInfoVO.getGoodsCode(), UserUtils.getSysId());
            if (CollectionUtils.isEmpty((Collection)resources)) {
                throw new BusinessException(UserUtils.getSysId() + "\u5e94\u7528\u672a\u5173\u8054\u8ba1\u91cf\u5546\u54c1" + orderInfoVO.getGoodsCode());
            }
            if (StringUtils.hasLength((String)orderInfoVO.getUnitConversionId())) {
                UnitConversionVO unitConversionVO = this.unitConversionService.findUnitConversionByIdAndGoodsCode(orderInfoVO.getUnitConversionId(), orderInfoVO.getGoodsCode());
                if (Objects.nonNull(unitConversionVO)) {
                    conversionPoint = unitConversionVO.getConversionPoint();
                    orderInfoVO.setDecreaseCount(Integer.valueOf(orderInfoVO.getDecreaseCount() * conversionPoint));
                } else {
                    throw new BusinessException((ErrorHandler)I18nError.DECREASE_UNIT_CONVERSION_NULL, new Object[]{orderInfoVO.getGoodsCode(), orderInfoVO.getUnitConversionId()});
                }
            }
        }
        String secretKey = request.getHeader(DapHttpHeaders.SECRET_KEY.getHeader());
        this.authorizeValidationService.checkSecretKey(orderInfoVO, secretKey);
        this.authorizeValidationService.checkOrderInfoVO3(orderInfoVO);
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(orderInfoVO.getTenantId(), orderInfoVO.getGoodsCode());
        if (purchase == null) {
            throw new BusinessException(String.format("\u79df\u6237%s\u672a\u6388\u6743\u5546\u54c1%s", orderInfoVO.getTenantId(), orderInfoVO.getGoodsCode()));
        }
        UsageCountResultVO usageCountResultVO2 = usageCountResultVO = Objects.equals(orderInfoVO.getOperateType(), DecreaseLogOperationTypeEnum.ADD.getCode()) ? this.useCountService.addAuthorizationCounting(orderInfoVO.getTenantId(), orderInfoVO.getGoodsCode(), orderInfoVO.getDecreaseCount()) : this.useCountService.decreaseAuthorizationCounting(orderInfoVO.getTenantId(), orderInfoVO.getGoodsCode(), orderInfoVO.getDecreaseCount());
        if (usageCountResultVO.isSuccess() && StringUtils.hasText((String)orderInfoVO.getAppId())) {
            boolean hasLogId = StringUtils.hasText((String)orderInfoVO.getLogId());
            boolean isResourceType = Objects.equals(orderInfoVO.getType(), DecreaseLogEnum.RESOURCE.getCode().toString());
            if (hasLogId || isResourceType) {
                DecreaseLog decreaseLog = new DecreaseLog();
                decreaseLog.setLogId(orderInfoVO.getLogId());
                decreaseLog.setProductCode(orderInfoVO.getGoodsCode());
                decreaseLog.setAppId(orderInfoVO.getAppId());
                decreaseLog.setTenantId(UserUtils.getTenantId());
                decreaseLog.setTenantName(UserUtils.getTenantName());
                decreaseLog.setAppTenantId(orderInfoVO.getTenantId());
                decreaseLog.setTotalUsage(Long.valueOf(usageCountResultVO.getTotalUsage()));
                decreaseLog.setRemainingUsage(Long.valueOf(usageCountResultVO.getRemainingUsage()));
                decreaseLog.setUseUsage(Long.valueOf(orderInfoVO.getDecreaseCount().intValue()));
                decreaseLog.setOperationType(orderInfoVO.getOperateType());
                decreaseLog.setUserId(UserUtils.getUserId());
                decreaseLog.setUserName(UserUtils.getUserName());
                decreaseLog.setRemark(orderInfoVO.getRemark());
                decreaseLog.setType(StringUtils.hasLength((String)orderInfoVO.getType()) ? Integer.valueOf(Integer.parseInt(orderInfoVO.getType())) : null);
                decreaseLog.setConversionPoint(conversionPoint);
                decreaseLog.setUnitConversionId(orderInfoVO.getUnitConversionId());
                decreaseLog.setDecreaseCount(decreaseCoount);
                if (Objects.nonNull(usageCountResultVO.getArgument())) {
                    decreaseLog.setProductName(usageCountResultVO.getArgument().getOrDefault("productName", ""));
                    decreaseLog.setPurchaseId(usageCountResultVO.getArgument().getOrDefault("purchaseId", ""));
                }
                this.decreaseLogCrudService.create((BaseEntity)decreaseLog);
            }
        }
        return ResponseEntity.ok((Object)usageCountResultVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @GetMapping(value={"/{tenantId:.+}/{goodsCode}"})
    public ResponseEntity<?> getUsersAuthorization(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode) {
        List userList = this.userCountService.getUserInCounting(tenantId, goodsCode);
        return new ResponseEntity((Object)userList, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/add"})
    public ResponseEntity<?> addUserInCounting(@RequestBody OrderInfoVO orderInfoVO) {
        this.authorizeValidationService.checkOrderInfoVO2(orderInfoVO);
        CountResultVO countResult = this.userCountService.addUser(orderInfoVO.getTenantId(), orderInfoVO.getCountingId(), orderInfoVO.getUserId());
        return new ResponseEntity((Object)countResult, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/remove"})
    public ResponseEntity<?> removeUserInCounting(@RequestBody OrderInfoVO orderInfoVO) {
        this.authorizeValidationService.checkOrderInfoVO2(orderInfoVO);
        CountResultVO countResult = this.userCountService.removeUser(orderInfoVO.getTenantId(), orderInfoVO.getCountingId(), orderInfoVO.getUserId());
        return new ResponseEntity((Object)countResult, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/update"})
    public ResponseEntity<?> updateUserInCounting(@RequestBody OrderInfoVO orderInfoVO) {
        this.authorizeValidationService.checkOrderInfoVO1(orderInfoVO);
        CountResultVO countResult = this.userCountService.batchUpdateUser(orderInfoVO.getTenantId(), orderInfoVO.getCountingId(), orderInfoVO.getUsers());
        return new ResponseEntity((Object)countResult, HttpStatus.OK);
    }
}

