/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain;

import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import org.springframework.util.StringUtils;

public class AuthorizationCheckRequest {
    @NotEmpty
    private String tenantId;
    @NotEmpty
    private String userId;
    @NotEmpty
    private String goodsCode;
    private List<String> apps = new ArrayList();
    private List<String> platformApps;
    private List<String> tenants = new ArrayList();
    private Boolean checkUserAuth = true;

    public static AuthorizationCheckRequest getSelf(String content) {
        AuthorizationCheckRequest body = new AuthorizationCheckRequest();
        try {
            if (StringUtils.hasText((String)content)) {
                body = (AuthorizationCheckRequest)JsonUtils.createObjectMapper().readValue(content, AuthorizationCheckRequest.class);
            }
        }
        catch (Exception e) {
            try {
                content = URLDecoder.decode(content, "utf-8");
                if (StringUtils.hasText((String)content)) {
                    body = (AuthorizationCheckRequest)JsonUtils.createObjectMapper().readValue(content, AuthorizationCheckRequest.class);
                    return body;
                }
            }
            catch (Exception ex) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10014, new Object[]{content});
            }
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10014, new Object[]{""});
        }
        return body;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public List<String> getApps() {
        return this.apps;
    }

    public void setApps(List<String> apps) {
        this.apps = apps;
    }

    public List<String> getPlatformApps() {
        return this.platformApps;
    }

    public void setPlatformApps(List<String> platformApps) {
        this.platformApps = platformApps;
    }

    public List<String> getTenants() {
        return this.tenants;
    }

    public void setTenants(List<String> tenants) {
        this.tenants = tenants;
    }

    public Boolean getCheckUserAuth() {
        return this.checkUserAuth;
    }

    public void setCheckUserAuth(Boolean checkUserAuth) {
        this.checkUserAuth = checkUserAuth;
    }
}

