/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain;

import com.digiwin.dap.middleware.cac.domain.AuthorizationActionVO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.entity.PurchaseModule;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AuthorizationModuleVO
implements Serializable,
Cloneable {
    private String id;
    private String name;
    private int totalUsage;
    private int remainingUsage;
    private LocalDateTime effectiveTime;
    private LocalDateTime expiredTime;
    private LocalDateTime oldExpiredTime;
    private List<AuthorizationActionVO> actions;

    public AuthorizationModuleVO() {
    }

    public AuthorizationModuleVO(EnabledModuleDTO module) {
        if (module != null) {
            this.id = module.getId();
            this.name = module.getName();
            this.totalUsage = module.getTotalUsage();
            this.remainingUsage = module.getRemainingUsage();
            this.effectiveTime = module.getEffectiveTime();
            this.expiredTime = module.getExpiredTime();
        }
    }

    public AuthorizationModuleVO(PurchaseModule module) {
        if (module != null) {
            this.id = module.getModuleId();
            this.name = module.getModuleName();
            this.totalUsage = module.getTotalUsageBound();
            this.remainingUsage = module.getRemainUsageBound();
            this.effectiveTime = module.getEffectiveDateTime();
            this.expiredTime = module.getExpiredDateTime();
            this.actions = this.deserializeActions(module.getActions());
        }
    }

    public AuthorizationModuleVO clone() throws CloneNotSupportedException {
        return (AuthorizationModuleVO)super.clone();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTotalUsage() {
        return this.totalUsage;
    }

    public void setTotalUsage(int totalUsage) {
        this.totalUsage = totalUsage;
    }

    public int getRemainingUsage() {
        return this.remainingUsage;
    }

    public void setRemainingUsage(int remainingUsage) {
        this.remainingUsage = remainingUsage;
    }

    public LocalDateTime getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(LocalDateTime effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public LocalDateTime getExpiredTime() {
        return this.expiredTime;
    }

    public void setExpiredTime(LocalDateTime expiredTime) {
        this.expiredTime = expiredTime;
    }

    public LocalDateTime getOldExpiredTime() {
        return this.oldExpiredTime;
    }

    public void setOldExpiredTime(LocalDateTime oldExpiredTime) {
        this.oldExpiredTime = oldExpiredTime;
    }

    public List<AuthorizationActionVO> getActions() {
        return this.actions;
    }

    public void setActions(List<AuthorizationActionVO> actions) {
        this.actions = actions;
    }

    public List<AuthorizationActionVO> mergeActionString(EnabledModuleDTO originalModule) {
        List originalActions = this.deserializeActions(originalModule.getActions());
        if (!CollectionUtils.isEmpty((Collection)this.actions)) {
            this.recursiveMergeAction(originalActions, this.actions, originalModule);
        }
        return originalActions;
    }

    private void recursiveMergeAction(List<AuthorizationActionVO> originalActions, List<AuthorizationActionVO> newActions, EnabledModuleDTO originalModule) {
        if (CollectionUtils.isEmpty(newActions)) {
            return;
        }
        if (originalActions == null) {
            originalActions = new ArrayList<AuthorizationActionVO>();
        }
        for (AuthorizationActionVO newAction : newActions) {
            AuthorizationActionVO originalAction = originalActions.stream().filter(a -> a.getId().equals(newAction.getId())).findFirst().orElse(null);
            if (originalAction == null) {
                originalActions.add(newAction);
                this.recursiveMergeAction(null, newAction.getActions(), originalModule);
            } else {
                newAction.setEffectiveTime(Optional.ofNullable(originalAction.getEffectiveTime()).orElse(originalModule.getEffectiveTime()));
                this.recursiveMergeAction(originalAction.getActions(), newAction.getActions(), originalModule);
                if (originalAction.getExpiredTime() == null) {
                    originalAction.setExpiredTime(originalModule.getExpiredTime());
                }
                if (originalAction.getEffectiveTime() == null) {
                    originalAction.setEffectiveTime(originalModule.getEffectiveTime());
                }
            }
            if (newAction.getExpiredTime() == null) {
                newAction.setExpiredTime(originalModule.getExpiredTime());
            }
            if (newAction.getEffectiveTime() != null) continue;
            newAction.setEffectiveTime(originalModule.getEffectiveTime());
        }
    }

    public String updateActionString(EnabledModuleDTO originalModule) {
        List originalActions = this.deserializeActions(originalModule.getActions());
        if (!CollectionUtils.isEmpty((Collection)this.actions)) {
            this.recursiveUpdateAction(originalActions, this.actions, originalModule);
            return JsonUtils.objToJson((Object)this.actions);
        }
        return null;
    }

    private void recursiveUpdateAction(List<AuthorizationActionVO> originalActions, List<AuthorizationActionVO> newActions, EnabledModuleDTO originalModule) {
        if (CollectionUtils.isEmpty(newActions)) {
            return;
        }
        if (originalActions == null) {
            originalActions = new ArrayList<AuthorizationActionVO>();
        }
        for (AuthorizationActionVO newAction : newActions) {
            AuthorizationActionVO originalAction = originalActions.stream().filter(a -> a.getId().equals(newAction.getId())).findFirst().orElse(new AuthorizationActionVO());
            newAction.setEffectiveTime(Optional.ofNullable(originalAction.getEffectiveTime()).orElse(originalModule.getEffectiveTime()));
            if (newAction.getExpiredTime() == null) {
                newAction.setExpiredTime(originalModule.getExpiredTime());
            }
            this.recursiveUpdateAction(originalAction.getActions(), newAction.getActions(), originalModule);
        }
    }

    public String generateActionString() {
        if (!CollectionUtils.isEmpty((Collection)this.actions)) {
            return JsonUtils.objToJson((Object)this.actions);
        }
        return null;
    }

    private List<AuthorizationActionVO> deserializeActions(String actions) {
        if (StringUtils.hasLength((String)actions)) {
            try {
                return (List)JsonUtils.createObjectMapper().readValue(actions, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return new ArrayList<AuthorizationActionVO>();
    }

    public void createActionBusiness(LocalDateTime upperEffectiveTime, LocalDateTime upperExpiredTime) {
        if (CollectionUtils.isEmpty((Collection)this.actions)) {
            return;
        }
        for (AuthorizationActionVO action : this.actions) {
            if (action.getEffectiveTime() == null) {
                action.setEffectiveTime(upperEffectiveTime);
            }
            if (action.getExpiredTime() == null) {
                action.setExpiredTime(upperExpiredTime);
            }
            action.createActionJson(upperEffectiveTime);
        }
    }
}

