/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain;

import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.CountSettingVO;
import com.digiwin.dap.middleware.cac.domain.remote.ResourceGoods;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.PurchaseModule;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AuthorizationVO
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationVO.class);
    private String purchaseId;
    private String customerId;
    private String tenantId;
    private String tenantName;
    private String id;
    private String code;
    private String itemId;
    private String categoryId;
    private String displayName;
    private String version;
    private String lastStrategyId;
    private LocalDateTime effectiveTime;
    private Boolean authOpen;
    private LocalDateTime expiredTime;
    private Boolean expired;
    private Boolean bufferPeriod;
    private LocalDateTime createTime;
    private LocalDateTime modifyDate;
    private String memo;
    private Boolean multiLogin;
    private int paymentType;
    private int totalUserCount;
    private int userCount;
    private int totalUsage;
    private int remainingUsage;
    private int alertThreshold;
    private String remainUsageCapacity;
    private String customUnit;
    private List<CountSettingVO> countSettings = new ArrayList();
    private List<AuthorizationModuleVO> enabledModules = new ArrayList();
    private List<?> customAttributes = Collections.emptyList();
    private String goodsAliasId;
    private Integer initialize = 0;
    private String expireNotice;
    private int monthlyUsage;
    private Boolean monthlyPlan;
    private String bundleCode;
    private String bundleName;
    private String totalUserInfo;
    private Boolean onShelve;
    private Boolean market;
    private String resourceCategory;
    private List<ResourceGoods> resourceGoods;
    private List<ResourceGoods> mainGoods;
    private Long todayInvokeCount;
    private Long totalInvokeCount;
    private Long failInvokeCount;
    private String batchCode;
    private long dueDay;
    private Long goodsSid;

    public AuthorizationVO() {
    }

    public AuthorizationVO(CloudPurchaseDTO purchase) {
        this.purchaseId = purchase.getPurchaseId();
        this.customerId = purchase.getCustomerId();
        this.id = purchase.getProductId();
        this.code = purchase.getProductCode();
        this.itemId = purchase.getItemId();
        this.categoryId = purchase.getProductType();
        this.displayName = purchase.getProductName();
        this.version = purchase.getProductVersion();
        this.lastStrategyId = purchase.getStrategyId();
        this.effectiveTime = purchase.getEffectiveDateTime();
        this.expiredTime = purchase.getExpiredDateTime();
        this.createTime = purchase.getCreateDateTime();
        this.memo = purchase.getMemo();
        this.multiLogin = purchase.getMultiLogin();
        this.paymentType = purchase.getPaymentType();
        this.totalUserCount = purchase.getTotalCount();
        this.userCount = purchase.getUserCount();
        if (purchase.getPaymentType() == 1 || purchase.getPaymentType() == 4) {
            this.totalUsage = purchase.getTotalCount();
            this.remainingUsage = purchase.getUserCount();
        } else {
            this.totalUsage = purchase.getTotalUsage();
            this.remainingUsage = purchase.getRemainingUsage();
        }
        this.customUnit = purchase.getCustomUnit();
        this.countSettings.add(new CountSettingVO(purchase));
        purchase.getModules().forEach(module -> this.enabledModules.add(new AuthorizationModuleVO(module)));
    }

    public AuthorizationVO(Purchase purchase, PurchaseCount count, List<PurchaseModule> modules) {
        this.handlePurchase(purchase);
        this.handleCount(purchase.getProductCode(), count);
        modules.forEach(module -> this.enabledModules.add(new AuthorizationModuleVO(module)));
    }

    public AuthorizationVO(Purchase a) {
        this.code = a.getProductCode();
        this.displayName = a.getProductName();
        this.expiredTime = a.getExpiredDateTime();
    }

    public static AuthorizationVO innerQuery(Purchase a) {
        AuthorizationVO authorizationVO = new AuthorizationVO();
        authorizationVO.setCustomerId(a.getCustomerId());
        authorizationVO.setCode(a.getProductCode());
        return authorizationVO;
    }

    private void handlePurchase(Purchase purchase) {
        this.purchaseId = purchase.getId();
        this.customerId = purchase.getCustomerId();
        this.tenantId = purchase.getCustomerId();
        this.tenantName = purchase.getTenantName();
        this.id = purchase.getProductId();
        this.code = purchase.getProductCode();
        this.itemId = purchase.getItemId();
        this.categoryId = purchase.getProductType();
        this.displayName = purchase.getProductName();
        this.version = purchase.getProductVersion();
        this.lastStrategyId = purchase.getStrategyId();
        this.effectiveTime = purchase.getEffectiveDateTime();
        this.authOpen = purchase.getEffectiveDateTime().isBefore(LocalDateTime.now());
        this.expiredTime = purchase.getExpiredDateTime();
        this.expired = purchase.getExpiredDateTime().isBefore(LocalDateTime.now());
        this.bufferPeriod = purchase.getBufferPeriod();
        this.createTime = purchase.getCreateDateTime();
        this.modifyDate = purchase.getModifyDate();
        this.memo = purchase.getMemo();
        this.multiLogin = purchase.isMultiLogin();
        this.goodsAliasId = purchase.getGoodsAliasId();
        this.initialize = purchase.getInitialize();
        this.expireNotice = purchase.getExpireNotice();
        this.monthlyPlan = purchase.getMonthlyPlan();
        this.bundleCode = purchase.getBundleCode();
        this.bundleName = purchase.getBundleName();
        this.resourceCategory = purchase.getResourceCategory();
        this.batchCode = purchase.getBatchCode();
    }

    private void handleCount(String goodsCode, PurchaseCount count) {
        if (count != null) {
            this.paymentType = count.getPaymentType();
            this.totalUserCount = count.getTotalCountBound();
            this.userCount = count.getUserCountBound();
            this.alertThreshold = Optional.ofNullable(count.getAlertThreshold()).orElse(0);
            if (count.getPaymentType() == 1 || count.getPaymentType() == 4) {
                this.totalUsage = count.getTotalCountBound();
                this.remainingUsage = count.getUserCountBound();
            } else {
                this.totalUsage = count.getTotalUsageBound();
                this.remainingUsage = count.getRemainUsageBound();
            }
            this.monthlyUsage = count.getMonthlyUsageBound();
            this.customUnit = count.getCustomUnit();
            this.countSettings.add(new CountSettingVO(goodsCode, count));
            if (Objects.nonNull(count.getRemainUsageCapacity()) && !Objects.equals(count.getRemainUsageCapacity(), 0)) {
                double gb = (double)count.getRemainUsageCapacity().longValue() / 1.073741824E9;
                BigDecimal bd = new BigDecimal(gb).setScale(2, RoundingMode.HALF_UP);
                this.remainUsageCapacity = String.valueOf(bd.doubleValue());
            } else {
                this.remainUsageCapacity = String.valueOf(count.getRemainUsageCapacity());
            }
            if (!StringUtils.isEmpty((Object)count.getCustomattributes())) {
                try {
                    this.setCustomAttributes((List)JsonUtils.createObjectMapper().readValue(count.getCustomattributes(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
                }
                catch (IOException e) {
                    LOGGER.error("\u81ea\u5b9a\u4e49\u5c5e\u6027\u89e3\u6790\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_10020);
                }
            }
        }
    }

    public void updateTotalUsage() {
        this.totalUsage = this.getPaymentType() == 1 || this.getPaymentType() == 4 ? this.getTotalUserCount() : this.getTotalUsage();
    }

    public String getPurchaseId() {
        return this.purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLastStrategyId() {
        return this.lastStrategyId;
    }

    public void setLastStrategyId(String lastStrategyId) {
        this.lastStrategyId = lastStrategyId;
    }

    public LocalDateTime getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(LocalDateTime effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Boolean getAuthOpen() {
        return this.authOpen;
    }

    public void setAuthOpen(Boolean authOpen) {
        this.authOpen = authOpen;
    }

    public LocalDateTime getExpiredTime() {
        return this.expiredTime;
    }

    public void setExpiredTime(LocalDateTime expiredTime) {
        this.expiredTime = expiredTime;
    }

    public Boolean getExpired() {
        return this.expired;
    }

    public void setExpired(Boolean expired) {
        this.expired = expired;
    }

    public Boolean getBufferPeriod() {
        return this.bufferPeriod;
    }

    public void setBufferPeriod(Boolean bufferPeriod) {
        this.bufferPeriod = bufferPeriod;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Boolean getMultiLogin() {
        return this.multiLogin;
    }

    public void setMultiLogin(Boolean multiLogin) {
        this.multiLogin = multiLogin;
    }

    public int getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(int paymentType) {
        this.paymentType = paymentType;
    }

    public int getTotalUserCount() {
        return this.totalUserCount;
    }

    public void setTotalUserCount(int totalUserCount) {
        this.totalUserCount = totalUserCount;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public void setUserCount(int userCount) {
        this.userCount = userCount;
    }

    public int getTotalUsage() {
        return this.totalUsage;
    }

    public void setTotalUsage(int totalUsage) {
        this.totalUsage = totalUsage;
    }

    public int getRemainingUsage() {
        return this.remainingUsage;
    }

    public void setRemainingUsage(int remainingUsage) {
        this.remainingUsage = remainingUsage;
    }

    public String getCustomUnit() {
        return this.customUnit;
    }

    public void setCustomUnit(String customUnit) {
        this.customUnit = customUnit;
    }

    public List<CountSettingVO> getCountSettings() {
        return this.countSettings;
    }

    public void setCountSettings(List<CountSettingVO> countSettings) {
        this.countSettings = countSettings;
    }

    public List<AuthorizationModuleVO> getEnabledModules() {
        return this.enabledModules;
    }

    public void setEnabledModules(List<AuthorizationModuleVO> enabledModules) {
        this.enabledModules = enabledModules;
    }

    public List<?> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<?> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getGoodsAliasId() {
        return this.goodsAliasId;
    }

    public void setGoodsAliasId(String goodsAliasId) {
        this.goodsAliasId = goodsAliasId;
    }

    public LocalDateTime getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(LocalDateTime modifyDate) {
        this.modifyDate = modifyDate;
    }

    public Integer getInitialize() {
        return this.initialize;
    }

    public void setInitialize(Integer initialize) {
        this.initialize = initialize;
    }

    public String getExpireNotice() {
        return this.expireNotice;
    }

    public void setExpireNotice(String expireNotice) {
        this.expireNotice = expireNotice;
    }

    public int getMonthlyUsage() {
        return this.monthlyUsage;
    }

    public void setMonthlyUsage(int monthlyUsage) {
        this.monthlyUsage = monthlyUsage;
    }

    public Boolean getMonthlyPlan() {
        return this.monthlyPlan;
    }

    public void setMonthlyPlan(Boolean monthlyPlan) {
        this.monthlyPlan = monthlyPlan;
    }

    public String getBundleCode() {
        return this.bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getTotalUserInfo() {
        return this.totalUserInfo;
    }

    public void setTotalUserInfo(String totalUserInfo) {
        this.totalUserInfo = totalUserInfo;
    }

    public Boolean getOnShelve() {
        return this.onShelve;
    }

    public void setOnShelve(Boolean onShelve) {
        this.onShelve = onShelve;
    }

    public String getResourceCategory() {
        return this.resourceCategory;
    }

    public void setResourceCategory(String resourceCategory) {
        this.resourceCategory = resourceCategory;
    }

    public List<ResourceGoods> getResourceGoods() {
        return this.resourceGoods;
    }

    public void setResourceGoods(List<ResourceGoods> resourceGoods) {
        this.resourceGoods = resourceGoods;
    }

    public List<ResourceGoods> getMainGoods() {
        return this.mainGoods;
    }

    public void setMainGoods(List<ResourceGoods> mainGoods) {
        this.mainGoods = mainGoods;
    }

    public Long getTodayInvokeCount() {
        return this.todayInvokeCount;
    }

    public void setTodayInvokeCount(Long todayInvokeCount) {
        this.todayInvokeCount = todayInvokeCount;
    }

    public Long getTotalInvokeCount() {
        return this.totalInvokeCount;
    }

    public void setTotalInvokeCount(Long totalInvokeCount) {
        this.totalInvokeCount = totalInvokeCount;
    }

    public Long getFailInvokeCount() {
        return this.failInvokeCount;
    }

    public void setFailInvokeCount(Long failInvokeCount) {
        this.failInvokeCount = failInvokeCount;
    }

    public String getBatchCode() {
        return this.batchCode;
    }

    public void setBatchCode(String batchCode) {
        this.batchCode = batchCode;
    }

    public long getDueDay() {
        if (this.expiredTime != null) {
            return Duration.between(LocalDateTime.now(), this.expiredTime).toDays();
        }
        return 0L;
    }

    public void setDueDay(long dueDay) {
        this.dueDay = dueDay;
    }

    public Boolean getMarket() {
        return this.market;
    }

    public void setMarket(Boolean market) {
        this.market = market;
    }

    public Long getGoodsSid() {
        return this.goodsSid;
    }

    public void setGoodsSid(Long goodsSid) {
        this.goodsSid = goodsSid;
    }

    public String getRemainUsageCapacity() {
        return this.remainUsageCapacity;
    }

    public void setRemainUsageCapacity(String remainUsageCapacity) {
        this.remainUsageCapacity = remainUsageCapacity;
    }

    public int getAlertThreshold() {
        return this.alertThreshold;
    }

    public void setAlertThreshold(int alertThreshold) {
        this.alertThreshold = alertThreshold;
    }
}

