/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain;

import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.CalcExpire;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.AuthCategory;
import java.time.LocalDateTime;
import org.springframework.beans.factory.InitializingBean;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalcExpire
implements InitializingBean {
    private AuthCategory category;
    private Boolean dealer = false;
    private Boolean bossManualAuthorization = false;
    private Boolean overlayTenancyPeriod = true;
    private Integer orderNumber;
    private Integer tenancyPeriod;
    private LocalDateTime effectiveDateTime;
    private LocalDateTime purchaseExpectDate;
    private LocalDateTime moduleExpectDate;
    private LocalDateTime purchaseFinalDate;
    private LocalDateTime moduleFinalDate;
    private LocalDateTime now = LocalDateTime.now().withNano(0);
    private Long month;
    private LocalDateTime purchaseActualDate;
    private LocalDateTime moduleActualDate;
    private Type type;
    private String tenantId;
    private String goodsCode;
    private String categoryId;
    private Boolean enableTenancy;

    public static CalcExpire get(PurchaseVO purchase) {
        return CalcExpire.get((PurchaseVO)purchase, null);
    }

    public static CalcExpire get(PurchaseVO purchase, LocalDateTime actualExpire) {
        CalcExpire calcExpire = new CalcExpire();
        calcExpire.setCategory(purchase.getCategory());
        calcExpire.setDealer(purchase.getDealer());
        calcExpire.setBossManualAuthorization(Boolean.valueOf(purchase.bossManualAuthorization()));
        calcExpire.setOverlayTenancyPeriod(purchase.getOverlayTenancyPeriod());
        calcExpire.setOrderNumber(Integer.valueOf(purchase.getOrderNumber()));
        calcExpire.setTenancyPeriod(Integer.valueOf(purchase.getSellingStrategy().getTenancyPeriod()));
        calcExpire.setEffectiveDateTime(purchase.getEffectiveTime());
        calcExpire.setPurchaseExpectDate(purchase.getExpiredTime());
        calcExpire.setPurchaseActualDate(actualExpire);
        calcExpire.setEnableTenancy(purchase.getSellingStrategy().getEnableTenancy());
        calcExpire.setCategoryId(purchase.getCategoryId());
        calcExpire.afterPropertiesSet();
        return calcExpire;
    }

    public void afterPropertiesSet() {
        this.effectiveDateTime = this.effectiveDateTime == null ? LocalDateTime.now() : this.effectiveDateTime;
        this.category = this.calcCategory();
        this.month = this.calcMonths();
    }

    public void module(EnabledModuleDTO entityModule, AuthorizationModuleVO domainModule) {
        if (entityModule != null) {
            this.moduleActualDate = entityModule.getExpiredTime();
        }
        if (domainModule != null) {
            this.moduleExpectDate = domainModule.getExpiredTime();
        }
    }

    public void module(LocalDateTime moduleExpectDate) {
        this.moduleExpectDate = moduleExpectDate;
    }

    private long calcMonths() {
        this.tenancyPeriod = this.tenancyPeriod == null ? 0 : this.tenancyPeriod;
        this.orderNumber = this.orderNumber == null ? 0 : this.orderNumber;
        int tenancyPeriod = Math.max(this.tenancyPeriod, 1);
        return (long)this.orderNumber.intValue() * (long)tenancyPeriod;
    }

    private AuthCategory calcCategory() {
        if (this.category != null) {
            return this.category;
        }
        if (this.overlayTenancyPeriod.booleanValue()) {
            return AuthCategory.OverlayTenancyPeriod;
        }
        if (this.dealer.booleanValue()) {
            return AuthCategory.Dealer;
        }
        if (this.bossManualAuthorization.booleanValue()) {
            return AuthCategory.BossManualAuthorization;
        }
        return AuthCategory.Ordinary;
    }

    public AuthCategory getCategory() {
        return this.category;
    }

    public void setCategory(AuthCategory category) {
        this.category = category;
    }

    public Boolean getDealer() {
        return this.dealer;
    }

    public void setDealer(Boolean dealer) {
        this.dealer = dealer;
    }

    public Boolean getBossManualAuthorization() {
        return this.bossManualAuthorization;
    }

    public void setBossManualAuthorization(Boolean bossManualAuthorization) {
        this.bossManualAuthorization = bossManualAuthorization;
    }

    public Boolean getOverlayTenancyPeriod() {
        return this.overlayTenancyPeriod;
    }

    public void setOverlayTenancyPeriod(Boolean overlayTenancyPeriod) {
        this.overlayTenancyPeriod = overlayTenancyPeriod;
    }

    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Integer getTenancyPeriod() {
        return this.tenancyPeriod;
    }

    public void setTenancyPeriod(Integer tenancyPeriod) {
        this.tenancyPeriod = tenancyPeriod;
    }

    public LocalDateTime getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(LocalDateTime effectiveDateTime) {
        this.effectiveDateTime = effectiveDateTime;
    }

    public LocalDateTime getPurchaseExpectDate() {
        return this.purchaseExpectDate;
    }

    public void setPurchaseExpectDate(LocalDateTime purchaseExpectDate) {
        this.purchaseExpectDate = purchaseExpectDate;
    }

    public LocalDateTime getModuleExpectDate() {
        return this.moduleExpectDate;
    }

    public void setModuleExpectDate(LocalDateTime moduleExpectDate) {
        this.moduleExpectDate = moduleExpectDate;
    }

    public LocalDateTime getPurchaseFinalDate() {
        return this.purchaseFinalDate;
    }

    public void setPurchaseFinalDate(LocalDateTime purchaseFinalDate) {
        this.purchaseFinalDate = purchaseFinalDate;
    }

    public LocalDateTime getModuleFinalDate() {
        return this.moduleFinalDate;
    }

    public void setModuleFinalDate(LocalDateTime moduleFinalDate) {
        this.moduleFinalDate = moduleFinalDate;
    }

    public LocalDateTime getNow() {
        return this.now;
    }

    public void setNow(LocalDateTime now) {
        this.now = now;
    }

    public Long getMonth() {
        return this.month;
    }

    public void setMonth(Long month) {
        this.month = month;
    }

    public LocalDateTime getPurchaseActualDate() {
        return this.purchaseActualDate;
    }

    public void setPurchaseActualDate(LocalDateTime purchaseActualDate) {
        this.purchaseActualDate = purchaseActualDate;
    }

    public LocalDateTime getModuleActualDate() {
        return this.moduleActualDate;
    }

    public void setModuleActualDate(LocalDateTime moduleActualDate) {
        this.moduleActualDate = moduleActualDate;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public Boolean getEnableTenancy() {
        return this.enableTenancy;
    }

    public void setEnableTenancy(Boolean enableTenancy) {
        this.enableTenancy = enableTenancy;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }
}

