/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain;

import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.PurchaseCountLogVO;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.SellingStrategyVO;
import com.digiwin.dap.middleware.cac.domain.TenantPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.PurchaseState;
import com.digiwin.dap.middleware.cac.domain.enumeration.ShipmentType;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.PurchaseModule;
import com.digiwin.dap.middleware.cac.util.BatchCodeUtil;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class CloudPurchaseDTO {
    private Long sid;
    private String purchaseId;
    private int sequenceId;
    private String type;
    private String shipmentId;
    private String customerId;
    private String customerName;
    private String memo;
    private String productId;
    private String productCode;
    private String itemId;
    private String strategyId;
    private String productType;
    private String productName;
    private String productVersion;
    private int trialDays;
    private String useType;
    private String createUserId;
    private LocalDateTime createDateTime;
    private LocalDateTime effectiveDateTime;
    private LocalDateTime expiredDateTime;
    private Boolean bufferPeriod;
    private Boolean multiLogin;
    private int paymentType;
    private String customUnit;
    private int totalUsage;
    private int remainingUsage;
    private int totalCount;
    private int userCount;
    private String countType;
    private String hash;
    private List<EnabledModuleDTO> modules;
    private Map<String, Map<String, Map<String, String>>> settings;
    private String state;
    private boolean cloud;
    private String goodsAliasId;
    private String sourceId;
    private String sourceCode;
    private Integer initialize = 0;
    private String customattributes;
    private String expireNotice;
    private int monthlyUsageBound;
    private boolean monthlyPlan;
    private boolean transferUnused;
    private String bundleCode;
    private String bundleName;
    private String resourceCategory;
    private String batchCode;
    private Long remainUsageCapacity;
    private PurchaseCountLogVO currentAuthInfo;

    public CloudPurchaseDTO() {
        this.modules = new ArrayList();
        this.settings = new HashMap();
    }

    public CloudPurchaseDTO(Purchase purchase, PurchaseCount count, List<PurchaseModule> modules) {
        this.purchaseId = purchase.getId();
        this.sequenceId = purchase.getSequenceId();
        this.type = purchase.getType();
        this.shipmentId = purchase.getShipmentId();
        this.customerId = purchase.getCustomerId();
        this.customerName = purchase.getTenantName();
        this.memo = purchase.getMemo();
        this.productId = purchase.getProductId();
        this.productCode = purchase.getProductCode();
        this.itemId = purchase.getItemId();
        this.strategyId = purchase.getStrategyId();
        this.productType = purchase.getProductType();
        this.productName = purchase.getProductName();
        this.productVersion = purchase.getProductVersion();
        this.useType = purchase.getUseType();
        this.createUserId = purchase.getCreateUserId();
        this.createDateTime = purchase.getCreateDateTime();
        this.effectiveDateTime = purchase.getEffectiveDateTime();
        this.expiredDateTime = purchase.getExpiredDateTime();
        this.bufferPeriod = purchase.getBufferPeriod();
        this.multiLogin = purchase.isMultiLogin();
        this.state = purchase.getState();
        this.cloud = true;
        this.initialize = purchase.getInitialize();
        this.expireNotice = purchase.getExpireNotice();
        this.bundleCode = purchase.getBundleCode();
        this.bundleName = purchase.getBundleName();
        this.handleCount(count);
        this.handleModule(modules);
    }

    public CloudPurchaseDTO(TenantPurchaseVO info, PurchaseVO purchaseVO, int count) {
        this.sid = SnowFlake.getInstance().newId();
        this.purchaseId = UUID.randomUUID().toString();
        this.sequenceId = count;
        this.type = ShipmentType.Shipment.name();
        this.shipmentId = "";
        this.customerId = info.getTenantId();
        this.customerName = info.getTenantName();
        this.memo = purchaseVO.getMemo();
        this.productId = purchaseVO.getId();
        this.productCode = purchaseVO.getCode();
        this.itemId = purchaseVO.getItemId();
        this.strategyId = purchaseVO.getSellingStrategy().getId();
        this.productType = purchaseVO.getCategoryId();
        this.productName = purchaseVO.getDisplayName();
        this.productVersion = purchaseVO.getVersion();
        this.trialDays = purchaseVO.getSellingStrategy().getTrialDays();
        this.createUserId = this.customerId;
        this.effectiveDateTime = purchaseVO.getEffectiveTime() == null ? LocalDateTime.now() : purchaseVO.getEffectiveTime();
        this.createDateTime = LocalDateTime.now();
        this.multiLogin = purchaseVO.getMultiLogin();
        this.state = PurchaseState.WaitForRegister.name();
        this.cloud = true;
        this.goodsAliasId = purchaseVO.getGoodsAliasId();
        this.sourceId = purchaseVO.getSourceId();
        this.sourceCode = purchaseVO.getSourceCode();
        this.memo = purchaseVO.getMemo();
        this.initialize = purchaseVO.getInitialize();
        this.handleCount(purchaseVO);
        this.handleModule(purchaseVO.getSellingStrategy());
        this.customattributes = purchaseVO.getCustomattributes();
        this.expireNotice = purchaseVO.getExpireNotice();
        this.monthlyPlan = purchaseVO.getMonthlyPlan();
        this.transferUnused = purchaseVO.getTransferUnused();
        this.bundleCode = purchaseVO.getBundleCode();
        this.bundleName = purchaseVO.getBundleName();
        this.resourceCategory = purchaseVO.getResourceCategory();
        this.batchCode = info.getBatchCode();
    }

    public Purchase generatePurchase() {
        Purchase purchase = new Purchase();
        purchase.setId(this.purchaseId);
        purchase.setSequenceId(Integer.valueOf(this.sequenceId));
        purchase.setType(ShipmentType.Shipment.name());
        purchase.setShipmentId("\u51fa\u8ca8\u55ae\u865f");
        purchase.setCustomerId(this.customerId);
        purchase.setMemo(this.memo);
        purchase.setProductId(this.productId);
        purchase.setProductCode(this.productCode);
        purchase.setItemId(this.itemId);
        purchase.setStrategyId(this.strategyId);
        purchase.setProductType(this.productType);
        purchase.setProductName(this.productName);
        purchase.setProductVersion(this.productVersion);
        purchase.setTrialDays(Integer.valueOf(this.trialDays));
        purchase.setUseType("\u6b63\u5f0f\u5340");
        purchase.setState(this.state);
        purchase.setTicketId("\u6191\u8b49id");
        purchase.setCreateUserId(this.createUserId);
        purchase.setCreateDateTime(this.createDateTime);
        purchase.setEffectiveDateTime(this.effectiveDateTime);
        purchase.setExpiredDateTime(this.expiredDateTime);
        purchase.setEnabled(true);
        purchase.setBufferPeriod(Optional.ofNullable(this.bufferPeriod).orElse(Boolean.FALSE));
        purchase.setMultiLogin(this.getMultiLogin().booleanValue());
        purchase.setGoodsAliasId(this.getGoodsAliasId());
        purchase.setInitialize(this.getInitialize());
        purchase.setMonthlyPlan(Boolean.valueOf(this.isMonthlyPlan()));
        purchase.setTransferUnused(Boolean.valueOf(this.isTransferUnused()));
        purchase.setBundleCode(this.bundleCode);
        purchase.setBundleName(this.bundleName);
        purchase.setResourceCategory(this.resourceCategory);
        purchase.setBatchCode(Optional.ofNullable(this.getBatchCode()).orElse(BatchCodeUtil.generateBatchCode((String)BatchCodeUtil.AUTO)));
        return purchase;
    }

    public PurchaseCount generatePurchaseCount() {
        PurchaseCount purchaseCount = new PurchaseCount();
        purchaseCount.setPurchaseId(this.purchaseId);
        purchaseCount.setPaymentType(this.paymentType);
        purchaseCount.setTotalUsageBound(this.totalUsage);
        purchaseCount.setRemainUsageBound(this.remainingUsage);
        purchaseCount.setRemainUsageCapacity(Long.valueOf((long)this.remainingUsage * 0x40000000L));
        purchaseCount.setCustomUnit(this.getCustomUnit());
        purchaseCount.setType(this.countType);
        purchaseCount.setTotalCountBound(this.totalCount);
        purchaseCount.setHash(this.hash);
        purchaseCount.setCustomattributes(this.customattributes);
        purchaseCount.setMonthlyUsageBound(this.monthlyUsageBound);
        purchaseCount.setAlertCount(Integer.valueOf(0));
        purchaseCount.setUsageAlert(Boolean.valueOf(false));
        purchaseCount.setAlertThreshold(Integer.valueOf(0));
        return purchaseCount;
    }

    public List<PurchaseModule> generatePurchaseModule() {
        ArrayList<PurchaseModule> purchaseModules = new ArrayList<PurchaseModule>();
        this.modules.forEach(module -> purchaseModules.add(new PurchaseModule(this.purchaseId, module)));
        return purchaseModules;
    }

    public Long getSid() {
        return this.sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public String getCustomattributes() {
        return this.customattributes;
    }

    public void setCustomattributes(String customattributes) {
        this.customattributes = customattributes;
    }

    public String getPurchaseId() {
        return this.purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getStrategyId() {
        return this.strategyId;
    }

    public void setStrategyId(String strategyId) {
        this.strategyId = strategyId;
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public int getTrialDays() {
        return this.trialDays;
    }

    public void setTrialDays(int trialDays) {
        this.trialDays = trialDays;
    }

    public String getUseType() {
        return this.useType;
    }

    public void setUseType(String useType) {
        this.useType = useType;
    }

    public String getCreateUserId() {
        return this.createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public LocalDateTime getCreateDateTime() {
        return this.createDateTime;
    }

    public void setCreateDateTime(LocalDateTime createDateTime) {
        this.createDateTime = createDateTime;
    }

    public LocalDateTime getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(LocalDateTime effectiveDateTime) {
        this.effectiveDateTime = effectiveDateTime;
    }

    public LocalDateTime getExpiredDateTime() {
        return this.expiredDateTime;
    }

    public void setExpiredDateTime(LocalDateTime expiredDateTime) {
        this.expiredDateTime = expiredDateTime;
    }

    public int getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(int paymentType) {
        this.paymentType = paymentType;
    }

    public String getCustomUnit() {
        return this.customUnit;
    }

    public void setCustomUnit(String customUnit) {
        this.customUnit = customUnit;
    }

    public int getTotalUsage() {
        return this.totalUsage;
    }

    public void setTotalUsage(int totalUsage) {
        this.totalUsage = totalUsage;
    }

    public int getRemainingUsage() {
        return this.remainingUsage;
    }

    public void setRemainingUsage(int remainingUsage) {
        this.remainingUsage = remainingUsage;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public void setUserCount(int userCount) {
        this.userCount = userCount;
    }

    public String getCountType() {
        return this.countType;
    }

    public void setCountType(String countType) {
        this.countType = countType;
    }

    public List<EnabledModuleDTO> getModules() {
        return this.modules;
    }

    public void setModules(List<EnabledModuleDTO> modules) {
        this.modules = modules;
    }

    public Map<String, Map<String, Map<String, String>>> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, Map<String, Map<String, String>>> settings) {
        this.settings = settings;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean getCloud() {
        return this.cloud;
    }

    public void setCloud(boolean cloud) {
        this.cloud = cloud;
    }

    public Boolean getBufferPeriod() {
        return this.bufferPeriod;
    }

    public void setBufferPeriod(Boolean bufferPeriod) {
        this.bufferPeriod = bufferPeriod;
    }

    public Boolean getMultiLogin() {
        return this.multiLogin;
    }

    public void setMultiLogin(Boolean multiLogin) {
        this.multiLogin = multiLogin;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getGoodsAliasId() {
        return this.goodsAliasId;
    }

    public void setGoodsAliasId(String goodsAliasId) {
        this.goodsAliasId = goodsAliasId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getInitialize() {
        return this.initialize;
    }

    public void setInitialize(Integer initialize) {
        this.initialize = initialize;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    private void handleCount(PurchaseCount count) {
        if (count != null) {
            this.paymentType = count.getPaymentType();
            this.customUnit = count.getCustomUnit();
            this.totalUsage = count.getTotalUsageBound();
            this.remainingUsage = count.getRemainUsageBound();
            this.totalCount = count.getTotalCountBound();
            this.userCount = count.getUserCountBound();
            this.countType = count.getType();
            this.monthlyUsageBound = count.getMonthlyUsageBound();
            this.remainUsageCapacity = count.getRemainUsageCapacity();
        }
    }

    private void handleCount(PurchaseVO authorizationVO) {
        this.paymentType = authorizationVO.getPaymentType();
        this.customUnit = authorizationVO.getCustomUnit();
        this.totalCount = authorizationVO.getTotalCount();
        this.userCount = authorizationVO.getUserCount();
    }

    private void handleModule(List<PurchaseModule> purchaseModules) {
        this.modules = new ArrayList();
        if (purchaseModules != null) {
            purchaseModules.forEach(module -> this.modules.add(new EnabledModuleDTO(module)));
        }
    }

    private void handleModule(SellingStrategyVO strategy) {
        this.modules = new ArrayList();
        if (strategy != null) {
            strategy.getEnabledModules().forEach(module -> this.modules.add(new EnabledModuleDTO(module)));
        }
    }

    public String getExpireNotice() {
        return this.expireNotice;
    }

    public void setExpireNotice(String expireNotice) {
        this.expireNotice = expireNotice;
    }

    public int getMonthlyUsageBound() {
        return this.monthlyUsageBound;
    }

    public void setMonthlyUsageBound(int monthlyUsageBound) {
        this.monthlyUsageBound = monthlyUsageBound;
    }

    public boolean isMonthlyPlan() {
        return this.monthlyPlan;
    }

    public void setMonthlyPlan(boolean monthlyPlan) {
        this.monthlyPlan = monthlyPlan;
    }

    public boolean isTransferUnused() {
        return this.transferUnused;
    }

    public void setTransferUnused(boolean transferUnused) {
        this.transferUnused = transferUnused;
    }

    public String getBundleCode() {
        return this.bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getResourceCategory() {
        return this.resourceCategory;
    }

    public void setResourceCategory(String resourceCategory) {
        this.resourceCategory = resourceCategory;
    }

    public String getBatchCode() {
        return this.batchCode;
    }

    public void setBatchCode(String batchCode) {
        this.batchCode = batchCode;
    }

    public Long getRemainUsageCapacity() {
        return this.remainUsageCapacity;
    }

    public void setRemainUsageCapacity(Long remainUsageCapacity) {
        this.remainUsageCapacity = remainUsageCapacity;
    }

    public PurchaseCountLogVO getCurrentAuthInfo() {
        return this.currentAuthInfo;
    }

    public void setCurrentAuthInfo(PurchaseCountLogVO currentAuthInfo) {
        this.currentAuthInfo = currentAuthInfo;
    }
}

