/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain;

import com.digiwin.dap.middleware.cac.domain.AffectedVO;
import com.digiwin.dap.middleware.cac.domain.ArgumentVO;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CountSettingVO
implements Serializable {
    private String countingId;
    private String type;
    private int usedCount;
    private List<AffectedVO> affected = new ArrayList();
    private ArgumentVO argument;

    public CountSettingVO() {
    }

    public CountSettingVO(CloudPurchaseDTO purchase) {
        this.usedCount = purchase.getUserCount();
        this.countingId = purchase.getProductCode();
        this.type = purchase.getCountType();
        this.affected.add(new AffectedVO(purchase.getProductCode()));
        this.argument = new ArgumentVO(Integer.valueOf(purchase.getUserCount()));
    }

    public CountSettingVO(String goodsCode, PurchaseCount count) {
        this.countingId = goodsCode;
        this.type = count.getType();
        this.usedCount = count.getUserCountBound();
        this.affected.add(new AffectedVO(goodsCode));
        this.argument = new ArgumentVO(Integer.valueOf(count.getUserCountBound()));
    }

    public int getUsedCount() {
        return this.usedCount;
    }

    public void setUsedCount(int usedCount) {
        this.usedCount = usedCount;
    }

    public String getCountingId() {
        return this.countingId;
    }

    public void setCountingId(String countingId) {
        this.countingId = countingId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<AffectedVO> getAffected() {
        return this.affected;
    }

    public void setAffected(List<AffectedVO> affected) {
        this.affected = affected;
    }

    public ArgumentVO getArgument() {
        return this.argument;
    }

    public void setArgument(ArgumentVO argument) {
        this.argument = argument;
    }
}

