/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.digiwin.dap.middleware.cac.domain.DecreaseLogVO;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class DecreaseLogExcel {
    @ExcelProperty(value={"\u8c03\u7528\u79df\u6237 (ID)"}, index=0)
    @ColumnWidth(value=50)
    private String tenantInfo;
    @ExcelProperty(value={"\u8c03\u7528\u5e94\u7528 (ID)"}, index=1)
    @ColumnWidth(value=50)
    private String appInfo;
    @ExcelProperty(value={"\u6263\u51cf\u65f6\u95f4"}, index=2)
    @ColumnWidth(value=20)
    private String decreaseTime;
    @ExcelProperty(value={"\u6263\u51cf\u6570\u91cf"}, index=3)
    @ColumnWidth(value=20)
    private Integer decreaseCount;

    public DecreaseLogExcel(DecreaseLogVO decreaseLogVO) {
        this.tenantInfo = StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{decreaseLogVO.getTenantName(), decreaseLogVO.getTenantId()});
        this.appInfo = StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{decreaseLogVO.getAppName(), decreaseLogVO.getAppId()});
        if (Objects.nonNull(decreaseLogVO.getDecreaseTime())) {
            this.decreaseTime = decreaseLogVO.getDecreaseTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        this.decreaseCount = decreaseLogVO.getDecreaseCount();
    }

    public String getTenantInfo() {
        return this.tenantInfo;
    }

    public void setTenantInfo(String tenantInfo) {
        this.tenantInfo = tenantInfo;
    }

    public String getAppInfo() {
        return this.appInfo;
    }

    public void setAppInfo(String appInfo) {
        this.appInfo = appInfo;
    }

    public String getDecreaseTime() {
        return this.decreaseTime;
    }

    public void setDecreaseTime(String decreaseTime) {
        this.decreaseTime = decreaseTime;
    }

    public Integer getDecreaseCount() {
        return this.decreaseCount;
    }

    public void setDecreaseCount(Integer decreaseCount) {
        this.decreaseCount = decreaseCount;
    }
}

