/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.digiwin.dap.middleware.cac.domain.InvokeLogVO;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class InvokeLogExcel {
    @ExcelProperty(value={"\u8c03\u7528\u7528\u6237 (ID)"}, index=0)
    @ColumnWidth(value=50)
    private String userInfo;
    @ExcelProperty(value={"\u8c03\u7528\u79df\u6237 (ID)"}, index=1)
    @ColumnWidth(value=50)
    private String tenantInfo;
    @ExcelProperty(value={"\u8c03\u7528\u5e94\u7528 (ID)"}, index=2)
    @ColumnWidth(value=50)
    private String appInfo;
    @ExcelProperty(value={"\u72b6\u6001"}, index=3)
    @ColumnWidth(value=20)
    private String requestStatus;
    @ExcelProperty(value={"\u8bf7\u6c42\u4fe1\u606f"}, index=4)
    @ColumnWidth(value=50)
    private String requestInfo;
    @ExcelProperty(value={"\u8c03\u7528\u65f6\u95f4"}, index=5)
    @ColumnWidth(value=20)
    private String invokeTime;

    public InvokeLogExcel(InvokeLogVO invokeLogVO) {
        this.userInfo = StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{invokeLogVO.getUserName(), invokeLogVO.getUserId()});
        this.tenantInfo = StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{invokeLogVO.getTenantName(), invokeLogVO.getTenantId()});
        this.appInfo = StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{invokeLogVO.getAppName(), invokeLogVO.getAppId()});
        this.requestStatus = "success".equalsIgnoreCase(invokeLogVO.getRequestStatus()) ? "\u6210\u529f" : "\u5931\u8d25";
        this.requestInfo = invokeLogVO.getRequestInfo();
        if (Objects.nonNull(invokeLogVO.getInvokeTime())) {
            this.invokeTime = invokeLogVO.getInvokeTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public String getTenantInfo() {
        return this.tenantInfo;
    }

    public void setTenantInfo(String tenantInfo) {
        this.tenantInfo = tenantInfo;
    }

    public String getAppInfo() {
        return this.appInfo;
    }

    public void setAppInfo(String appInfo) {
        this.appInfo = appInfo;
    }

    public String getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getRequestInfo() {
        return this.requestInfo;
    }

    public void setRequestInfo(String requestInfo) {
        this.requestInfo = requestInfo;
    }

    public String getInvokeTime() {
        return this.invokeTime;
    }

    public void setInvokeTime(String invokeTime) {
        this.invokeTime = invokeTime;
    }
}

