/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.digiwin.dap.middleware.cac.constant.DecreaseLogOperationTypeEnum;
import com.digiwin.dap.middleware.cac.domain.DecreaseLogVO;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.springframework.util.ObjectUtils;

public class TenantResourceDecreaseLogExcel {
    @ExcelProperty(value={"\u5e94\u7528\u540d\u79f0 (ID)"}, index=0)
    @ColumnWidth(value=50)
    private String appInfo;
    @ExcelProperty(value={"\u7528\u6237\u540d\u79f0 (ID)"}, index=1)
    @ColumnWidth(value=50)
    private String userInfo;
    @ExcelProperty(value={"\u7c7b\u578b"}, index=2)
    @ColumnWidth(value=20)
    private String operationType;
    @ExcelProperty(value={"\u4f7f\u7528\u6570\u91cf"}, index=3)
    @ColumnWidth(value=20)
    private String decreaseCount;
    @ExcelProperty(value={"\u4f7f\u7528\u65f6\u95f4"}, index=4)
    @ColumnWidth(value=20)
    private String decreaseTime;
    @ExcelProperty(value={"\u6362\u7b97\u5355\u4f4d\u540d\u79f0 (ID)"}, index=5)
    @ColumnWidth(value=50)
    private String unitConversion;
    @ExcelProperty(value={"\u6362\u7b97\u6570\u91cf"}, index=6)
    @ColumnWidth(value=50)
    private Integer conversionPoint;
    @ExcelProperty(value={"\u4f7f\u7528\u8bf4\u660e"}, index=7)
    private String remark;

    public TenantResourceDecreaseLogExcel() {
    }

    public TenantResourceDecreaseLogExcel(DecreaseLogVO decreaseLogVO) {
        this.userInfo = StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{decreaseLogVO.getUserName(), decreaseLogVO.getUserId()});
        this.appInfo = StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{decreaseLogVO.getAppName(), decreaseLogVO.getAppId()});
        if (Objects.nonNull(decreaseLogVO.getDecreaseTime())) {
            this.decreaseTime = decreaseLogVO.getDecreaseTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        this.operationType = DecreaseLogOperationTypeEnum.getDescByCode((Integer)decreaseLogVO.getOperationType());
        this.decreaseCount = decreaseLogVO.getQuantityUsed();
        this.conversionPoint = decreaseLogVO.getConversionPoint();
        this.unitConversion = ObjectUtils.isEmpty((Object)decreaseLogVO.getUnitConversionId()) ? null : StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{decreaseLogVO.getUnitConversionName(), decreaseLogVO.getUnitConversionId()});
        this.remark = decreaseLogVO.getRemark();
    }

    public TenantResourceDecreaseLogExcel(String user, String app, String decreaseTime, String operationType, String decreaseCount) {
        this.userInfo = user;
        this.appInfo = app;
        this.decreaseTime = decreaseTime;
        this.operationType = operationType;
        this.decreaseCount = decreaseCount;
    }

    public String getAppInfo() {
        return this.appInfo;
    }

    public void setAppInfo(String appInfo) {
        this.appInfo = appInfo;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getDecreaseCount() {
        return this.decreaseCount;
    }

    public void setDecreaseCount(String decreaseCount) {
        this.decreaseCount = decreaseCount;
    }

    public String getDecreaseTime() {
        return this.decreaseTime;
    }

    public void setDecreaseTime(String decreaseTime) {
        this.decreaseTime = decreaseTime;
    }

    public Integer getConversionPoint() {
        return this.conversionPoint;
    }

    public void setConversionPoint(Integer conversionPoint) {
        this.conversionPoint = conversionPoint;
    }

    public String getUnitConversion() {
        return this.unitConversion;
    }

    public void setUnitConversion(String unitConversion) {
        this.unitConversion = unitConversion;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

