/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.digiwin.dap.middleware.cac.constant.I18nCode;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.PaymentType;
import com.digiwin.dap.middleware.cac.domain.remote.TenantInfo;
import java.util.List;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AuthorizationInfoExcel {
    @ExcelProperty(value={"${productContent}"}, index=0)
    @ColumnWidth(value=30)
    private String productContent;
    @ExcelProperty(value={"${tenantContent}"}, index=1)
    @ColumnWidth(value=30)
    private String tenantContent;
    @ExcelProperty(value={"${moduleContent}"}, index=2)
    @ColumnWidth(value=30)
    private String moduleContent;
    @ExcelProperty(value={"${authDate}"}, index=3)
    @ColumnWidth(value=30)
    private String authDate;
    @ExcelProperty(value={"${expired}"}, index=4)
    @ColumnWidth(value=10)
    private String expired;
    @ExcelProperty(value={"${bufferPeriod}"}, index=5)
    @ColumnWidth(value=10)
    private String bufferPeriod;
    @ExcelProperty(value={"${paymentType}"}, index=6)
    @ColumnWidth(value=10)
    private String paymentType;
    @ExcelProperty(value={"${countInfo}"}, index=7)
    @ColumnWidth(value=30)
    private String countInfo;
    @ExcelProperty(value={"${tenantContact}"}, index=8)
    @ColumnWidth(value=10)
    private String tenantContact;
    @ExcelProperty(value={"${tenantTelephone}"}, index=9)
    @ColumnWidth(value=10)
    private String tenantTelephone;
    @ExcelProperty(value={"${tenantEmail}"}, index=10)
    @ColumnWidth(value=10)
    private String tenantEmail;
    @ExcelIgnore
    private List<AuthorizationModuleVO> modules;

    public AuthorizationInfoExcel() {
    }

    public AuthorizationInfoExcel(AuthorizationVO authorizationVO, TenantInfo tenantInfo) {
        this.productContent = String.format("%s(%s)", authorizationVO.getDisplayName(), authorizationVO.getCode());
        this.tenantContent = String.format("%s(%s)", authorizationVO.getTenantName(), authorizationVO.getTenantId());
        this.modules = authorizationVO.getEnabledModules();
        this.authDate = String.format("%s~%s", null == authorizationVO.getEffectiveTime() ? "" : authorizationVO.getEffectiveTime(), authorizationVO.getExpiredTime());
        this.expired = ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)authorizationVO.getExpired()) ? I18nCode.EXPORT_AUTH_STATUS_EXPIRED.getMessage() : I18nCode.EXPORT_AUTH_STATUS_NO_EXPIRED.getMessage();
        this.bufferPeriod = ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)authorizationVO.getBufferPeriod()) ? "Y" : "N";
        this.getPaymentTypeName(authorizationVO.getPaymentType(), authorizationVO.getCustomUnit(), authorizationVO.getTotalUserCount(), authorizationVO.getUserCount(), authorizationVO.getTotalUsage(), authorizationVO.getRemainingUsage());
        if (null != tenantInfo) {
            this.tenantContact = tenantInfo.getContacts();
            this.tenantTelephone = tenantInfo.getTelephone();
            this.tenantEmail = tenantInfo.getEmail();
        }
    }

    public AuthorizationInfoExcel(AuthorizationModuleVO moduleVO) {
        this.moduleContent = moduleVO.getName();
        this.authDate = String.format("%s~%s", null == moduleVO.getEffectiveTime() ? "" : moduleVO.getEffectiveTime(), moduleVO.getExpiredTime());
    }

    private void getPaymentTypeName(int paymentType, String customUnit, int totalUserCount, int userCount, int totalUsage, int remainingUsage) {
        if (ObjectUtils.nullSafeEquals((Object)PaymentType.Count.ordinal(), (Object)paymentType)) {
            this.paymentType = StringUtils.hasText((String)customUnit) ? customUnit : I18nCode.PAYMENTTYPE_0.getMessage();
            this.countInfo = String.format("%s/%s", remainingUsage, totalUsage);
        } else if (ObjectUtils.nullSafeEquals((Object)PaymentType.PersonMonth.ordinal(), (Object)paymentType)) {
            this.paymentType = I18nCode.PAYMENTTYPE_1.getMessage();
            this.countInfo = String.format("%s/%s", userCount, totalUserCount);
        } else if (ObjectUtils.nullSafeEquals((Object)PaymentType.CountByMonth.ordinal(), (Object)paymentType)) {
            this.paymentType = StringUtils.hasText((String)customUnit) ? String.format("%s/%s", customUnit, I18nCode.PAYMENTTYPE_21.getMessage()) : I18nCode.PAYMENTTYPE_2.getMessage();
            this.countInfo = String.format("%s/%s", remainingUsage, totalUsage);
        } else if (ObjectUtils.nullSafeEquals((Object)PaymentType.NoControl.ordinal(), (Object)paymentType)) {
            this.paymentType = I18nCode.PAYMENTTYPE_3.getMessage();
            this.countInfo = String.format("%s/\u221e", userCount);
        } else if (ObjectUtils.nullSafeEquals((Object)PaymentType.Month.ordinal(), (Object)paymentType)) {
            this.paymentType = I18nCode.PAYMENTTYPE_21.getMessage();
            this.countInfo = String.format("%s/\u221e", userCount);
        } else if (ObjectUtils.nullSafeEquals((Object)PaymentType.Year.ordinal(), (Object)paymentType)) {
            this.paymentType = I18nCode.PAYMENTTYPE_4.getMessage();
            this.countInfo = String.format("%s/\u221e", userCount);
        } else {
            this.paymentType = StringUtils.hasText((String)customUnit) ? String.format("%s/%s", customUnit, I18nCode.PAYMENTTYPE_21.getMessage()) : I18nCode.PAYMENTTYPE_2.getMessage();
            this.countInfo = String.format("%s/%s", remainingUsage, totalUsage);
        }
    }

    public String getProductContent() {
        return this.productContent;
    }

    public void setProductContent(String productContent) {
        this.productContent = productContent;
    }

    public String getTenantContent() {
        return this.tenantContent;
    }

    public void setTenantContent(String tenantContent) {
        this.tenantContent = tenantContent;
    }

    public String getModuleContent() {
        return this.moduleContent;
    }

    public void setModuleContent(String moduleContent) {
        this.moduleContent = moduleContent;
    }

    public String getAuthDate() {
        return this.authDate;
    }

    public void setAuthDate(String authDate) {
        this.authDate = authDate;
    }

    public String getExpired() {
        return this.expired;
    }

    public void setExpired(String expired) {
        this.expired = expired;
    }

    public String getBufferPeriod() {
        return this.bufferPeriod;
    }

    public void setBufferPeriod(String bufferPeriod) {
        this.bufferPeriod = bufferPeriod;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public String getCountInfo() {
        return this.countInfo;
    }

    public void setCountInfo(String countInfo) {
        this.countInfo = countInfo;
    }

    public String getTenantContact() {
        return this.tenantContact;
    }

    public void setTenantContact(String tenantContact) {
        this.tenantContact = tenantContact;
    }

    public String getTenantTelephone() {
        return this.tenantTelephone;
    }

    public void setTenantTelephone(String tenantTelephone) {
        this.tenantTelephone = tenantTelephone;
    }

    public String getTenantEmail() {
        return this.tenantEmail;
    }

    public void setTenantEmail(String tenantEmail) {
        this.tenantEmail = tenantEmail;
    }

    public List<AuthorizationModuleVO> getModules() {
        return this.modules;
    }

    public void setModules(List<AuthorizationModuleVO> modules) {
        this.modules = modules;
    }
}

