/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain.excel;

import com.alibaba.excel.write.handler.AbstractRowWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;

public class MergeRowStrategy
extends AbstractRowWriteHandler {
    private final Map<Integer, Integer> mergeRows = new HashMap();
    private final int lastCol;

    public MergeRowStrategy(Map<Integer, Long> dataRows, int lastCol) {
        this.lastCol = lastCol;
        Map<Long, Long> dataMap = dataRows.values().stream().collect(Collectors.groupingBy(p -> p, Collectors.counting()));
        for (Map.Entry<Integer, Long> entry : dataRows.entrySet()) {
            Long size = dataMap.getOrDefault(entry.getValue(), 1L);
            this.mergeRows.put(entry.getKey(), Math.toIntExact(size));
            dataMap.remove(entry.getValue());
        }
    }

    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer relativeRowIndex, Boolean isHead) {
        int curRowIndex;
        Integer eachRow;
        if (!isHead.booleanValue() && (eachRow = this.mergeRows.getOrDefault(curRowIndex = row.getRowNum(), 1)) > 1) {
            for (int colIndex = 0; colIndex <= this.lastCol; ++colIndex) {
                CellRangeAddress cellRangeAddress = new CellRangeAddress(curRowIndex, curRowIndex + eachRow - 1, colIndex, colIndex);
                writeSheetHolder.getSheet().addMergedRegionUnsafe(cellRangeAddress);
            }
        }
    }
}

