/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.domain.record;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.digiwin.dap.middleware.cac.constant.I18nCode;
import com.digiwin.dap.middleware.cac.domain.enumeration.PaymentType;
import com.digiwin.dap.middleware.cac.domain.record.RecordModuleItemVO;
import com.digiwin.dap.middleware.cac.domain.record.RecordVO;
import com.digiwin.dap.middleware.cac.domain.remote.PaymentTypeVO;
import com.digiwin.dap.middleware.serializer.Constants;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class RecordExcel {
    @ExcelIgnore
    private Long sid;
    @ExcelProperty(value={"\u6765\u6e90"}, index=0)
    private String sourceName;
    @ExcelProperty(value={"\u4ea7\u54c1\u540d\u79f0\uff08ID\uff09"}, index=1)
    private String goodsContent;
    @ExcelProperty(value={"\u79df\u6237\u540d\u79f0\uff08ID\uff09"}, index=2)
    private String tenantContent;
    @ExcelProperty(value={"\u8d2d\u4e70U\u6570"}, index=3)
    private String userCount;
    @ExcelProperty(value={"\u4ef7\u683c\u5355\u4f4d"}, index=4)
    private String paymentTypeName;
    @ExcelProperty(value={"\u6388\u6743\u8d77\u8bab\u65e5"}, index=5)
    private String authDate;
    @ExcelProperty(value={"\u5f02\u52a8\u65e5\u671f"}, index=6)
    private String createDate;
    @ExcelProperty(value={"\u5f02\u52a8\u8005\uff08ID\uff09"}, index=7)
    private String createById;
    @ExcelProperty(value={"\u5f02\u52a8\u5355\u53f7"}, index=8)
    private String orderCode;
    @ExcelProperty(value={"\u5907\u6ce8"}, index=9)
    private String remark;
    @ExcelProperty(value={"\u6a21\u7ec4\u540d\u79f0"}, index=10)
    private String moduleName;
    @ExcelProperty(value={"\u6709\u6548\u671f\u9650"}, index=11)
    private String moduleExpiredDate;

    public RecordExcel(RecordVO record, List<PaymentTypeVO> paymentTypes) {
        this.sid = record.getSid();
        this.sourceName = record.getSourceName();
        this.goodsContent = String.format("%s[%s]", record.getGoodsName(), record.getGoodsCode());
        this.tenantContent = String.format("%s[%s]", record.getTenantName(), record.getTenantId());
        Integer paymentType = record.getPaymentType();
        this.userCount = "\u221e";
        if (paymentType.equals(PaymentType.Count.ordinal()) || paymentType.equals(PaymentType.PersonMonth.ordinal()) || paymentType.equals(PaymentType.CountByMonth.ordinal())) {
            if (record.getUseCount() > 0) {
                this.userCount = record.getUseCount() + "";
            }
            if (record.getUserCount() > 0) {
                this.userCount = record.getUserCount() + "";
            }
        }
        Map<String, String> paymentTypeMap = paymentTypes.stream().collect(Collectors.toMap(PaymentTypeVO::uniqueKey, PaymentTypeVO::getName));
        this.paymentTypeName = paymentTypeMap.get(record.getGoodsCategory() + "-" + paymentType);
        this.authDate = String.format("%s~%s", RecordExcel.date2Str((LocalDateTime)record.getEffectiveDate(), (DateTimeFormatter)Constants.DATE_FORMATTER), RecordExcel.date2Str((LocalDateTime)record.getExpiredDate(), (DateTimeFormatter)Constants.DATE_FORMATTER));
        this.createDate = RecordExcel.date2Str((LocalDateTime)record.getCreateDate(), (DateTimeFormatter)Constants.DATETIME_FORMATTER);
        this.createById = record.getCreateById();
        if (record instanceof RecordModuleItemVO) {
            RecordModuleItemVO moduleItem = (RecordModuleItemVO)record;
            this.moduleName = moduleItem.getModuleName();
            if (moduleItem.getModuleExpiredDate() != null) {
                this.moduleExpiredDate = I18nCode.EXPORT_RECORD_DATA01.getMessage() + RecordExcel.date2Str((LocalDateTime)moduleItem.getModuleExpiredDate(), (DateTimeFormatter)Constants.DATETIME_FORMATTER);
            }
        }
        this.orderCode = record.getOrderCode();
        this.remark = record.getRemark();
    }

    private static String date2Str(LocalDateTime date, DateTimeFormatter formatter) {
        try {
            return date.format(formatter);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Long getSid() {
        return this.sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getGoodsContent() {
        return this.goodsContent;
    }

    public void setGoodsContent(String goodsContent) {
        this.goodsContent = goodsContent;
    }

    public String getTenantContent() {
        return this.tenantContent;
    }

    public void setTenantContent(String tenantContent) {
        this.tenantContent = tenantContent;
    }

    public String getUserCount() {
        return this.userCount;
    }

    public void setUserCount(String userCount) {
        this.userCount = userCount;
    }

    public String getPaymentTypeName() {
        return this.paymentTypeName;
    }

    public void setPaymentTypeName(String paymentTypeName) {
        this.paymentTypeName = paymentTypeName;
    }

    public String getAuthDate() {
        return this.authDate;
    }

    public void setAuthDate(String authDate) {
        this.authDate = authDate;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getCreateById() {
        return this.createById;
    }

    public void setCreateById(String createById) {
        this.createById = createById;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleExpiredDate() {
        return this.moduleExpiredDate;
    }

    public void setModuleExpiredDate(String moduleExpiredDate) {
        this.moduleExpiredDate = moduleExpiredDate;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

