/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.entity;

import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.entity.BaseEntity;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="purchasemodule")
public class PurchaseModule
extends BaseEntity {
    @Column(name="purchase_id", nullable=false, length=40)
    private String purchaseId;
    @Column(name="module_id", nullable=false, length=40)
    private String moduleId;
    @Column(name="module_name", length=40)
    private String moduleName;
    @Column(name="total_usage_bound", nullable=false)
    private int totalUsageBound;
    @Column(name="remain_usage_bound", nullable=false)
    private int remainUsageBound;
    @Column(name="effective_date_time", columnDefinition="DATETIME")
    private LocalDateTime effectiveDateTime;
    @Column(name="expired_date_time", columnDefinition="DATETIME")
    private LocalDateTime expiredDateTime;
    @Column(name="actions", nullable=false, length=10000)
    private String actions;

    public PurchaseModule() {
    }

    public PurchaseModule(String purchaseId, EnabledModuleDTO module) {
        this.purchaseId = purchaseId;
        this.update(module);
    }

    public PurchaseModule update(EnabledModuleDTO module) {
        this.moduleId = module.getId();
        this.moduleName = module.getName();
        this.totalUsageBound = module.getTotalUsage();
        this.remainUsageBound = module.getRemainingUsage();
        this.effectiveDateTime = module.getEffectiveTime();
        this.expiredDateTime = module.getExpiredTime();
        this.actions = module.getActions();
        return this;
    }

    public String getPurchaseId() {
        return this.purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public int getTotalUsageBound() {
        return this.totalUsageBound;
    }

    public void setTotalUsageBound(int totalUsageBound) {
        this.totalUsageBound = totalUsageBound;
    }

    public int getRemainUsageBound() {
        return this.remainUsageBound;
    }

    public void setRemainUsageBound(int remainUsageBound) {
        this.remainUsageBound = remainUsageBound;
    }

    public LocalDateTime getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(LocalDateTime effectiveDateTime) {
        this.effectiveDateTime = effectiveDateTime;
    }

    public LocalDateTime getExpiredDateTime() {
        return this.expiredDateTime;
    }

    public void setExpiredDateTime(LocalDateTime expiredDateTime) {
        this.expiredDateTime = expiredDateTime;
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }
}

