/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.domain.ApiGoodsVO;
import com.digiwin.dap.middleware.cac.entity.ApiGoods;
import com.digiwin.dap.middleware.cac.repository.ApiGoodsRepository;
import com.digiwin.dap.middleware.cac.service.basic.ApiGoodsCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiGoodsCrudServiceImpl
extends BaseEntityManagerService<ApiGoods>
implements ApiGoodsCrudService {
    @Autowired
    private ApiGoodsRepository apiGoodsRepository;

    protected ApiGoodsRepository getRepository() {
        return this.apiGoodsRepository;
    }

    @Transactional
    public void save(String mainGoodsCode, List<ApiGoodsVO> detailGoods) {
        List existingGoods = this.apiGoodsRepository.findByMainGoodsCode(mainGoodsCode);
        Map existingGoodsMap = existingGoods.stream().collect(Collectors.toMap(ApiGoods::getCode, Function.identity()));
        ArrayList<ApiGoods> newResources = new ArrayList<ApiGoods>();
        for (ApiGoodsVO vo : detailGoods) {
            ApiGoods existingGood = (ApiGoods)existingGoodsMap.get(vo.getCode());
            if (existingGood != null) {
                existingGoodsMap.remove(vo.getCode());
                continue;
            }
            ApiGoods newGood = new ApiGoods();
            newGood.setMainGoodsCode(mainGoodsCode);
            newGood.setCode(vo.getCode());
            newGood.setName(vo.getName());
            newGood.setCategory(vo.getCategory());
            newResources.add(newGood);
        }
        if (!existingGoodsMap.isEmpty()) {
            this.apiGoodsRepository.deleteAll(existingGoodsMap.values());
        }
        if (!newResources.isEmpty()) {
            this.saveAll(newResources);
        }
    }

    public List<ApiGoodsVO> list(String mainGoodsCode) {
        List db = this.apiGoodsRepository.findByMainGoodsCode(mainGoodsCode);
        return db.stream().map(ApiGoodsVO::toVO).collect(Collectors.toList());
    }
}

