/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.service.basic.HashManagerService;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.HashUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class BaseHashManagerService<T extends BaseEntity>
extends BaseEntityManagerService<T>
implements HashManagerService<T> {
    public void validate(T data) {
        String newHash;
        if (Boolean.FALSE.equals(this.dapEnv.getSignature()) || null == data) {
            return;
        }
        String hash = data.getHash();
        if (!Objects.equals(hash, newHash = this.generateHash(data))) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.DATA_CHECK, new Object[]{this.getMappingTableName(), data.getSid()});
        }
    }

    public long create(T data) {
        EntityUtils.setCreateFields(data);
        this.generateHash(data);
        this.getRepository().save(data);
        this.getRepository().flush();
        return data.getSid();
    }

    public void update(T data) {
        if (data.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10022);
        }
        EntityUtils.setModifyFields(data);
        this.generateHash(data);
        this.getRepository().save(data);
        this.getRepository().flush();
    }

    public T findBySid(long sid) {
        Optional entity = this.getRepository().findById((Object)sid);
        if (entity.isPresent()) {
            this.validate((BaseEntity)entity.get());
        }
        return (T)((BaseEntity)entity.orElse(null));
    }

    public List<T> findAll() {
        List entities = this.getRepository().findAll();
        entities.forEach(arg_0 -> this.validate(arg_0));
        return entities;
    }

    public List<T> flushHash() {
        List entities = this.getRepository().findAll();
        entities.forEach(arg_0 -> this.generateHash(arg_0));
        return entities;
    }

    public String generateHash(T data) {
        String hash = HashUtils.getHash((Object)this.getHashKey(data));
        data.setHash(hash);
        return hash;
    }

    public Map<String, Object> getHashKey(T data) {
        return Collections.singletonMap("sid", data.getSid());
    }
}

