/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.domain.CommonVO;
import com.digiwin.dap.middleware.cac.entity.Customer;
import com.digiwin.dap.middleware.cac.repository.CustomerRepository;
import com.digiwin.dap.middleware.cac.service.basic.CustomerCrudService;
import com.digiwin.dap.middleware.cac.service.basic.impl.BaseHashManagerService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerCrudServiceImpl
extends BaseHashManagerService<Customer>
implements CustomerCrudService {
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private IamService iamService;

    protected CustomerRepository getRepository() {
        return this.customerRepository;
    }

    public Map<String, Object> getHashKey(Customer entity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", entity.getId());
        map.put("name", entity.getName());
        return map;
    }

    public void deleteById(String tenantId) {
        this.getRepository().deleteByIdIs(tenantId);
    }

    public Customer findById(String tenantId) {
        return this.getRepository().findByIdIs(tenantId);
    }

    public boolean existsById(String tenantId) {
        return this.getRepository().existsByIdIs(tenantId);
    }

    public long create(Customer data) {
        List tenantSimples = this.iamService.getTenantSimples(Collections.singletonList(data.getId()));
        Boolean testTenant = tenantSimples.stream().findFirst().map(CommonVO::getTestTenant).orElse(null);
        data.setTestTenant(testTenant);
        return super.create((BaseEntity)data);
    }
}

