/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.constant.DecreaseLogEnum;
import com.digiwin.dap.middleware.cac.constant.DecreaseLogOperationTypeEnum;
import com.digiwin.dap.middleware.cac.domain.remote.ResourceGoodsPurchaseRecordVO;
import com.digiwin.dap.middleware.cac.domain.remote.ResourceGoodsRequest;
import com.digiwin.dap.middleware.cac.domain.remote.ResourceGoodsUseRecordVO;
import com.digiwin.dap.middleware.cac.entity.DecreaseLog;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.repository.DecreaseLogRepository;
import com.digiwin.dap.middleware.cac.service.basic.DecreaseLogCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.impl.BaseHashManagerService;
import com.digiwin.dap.middleware.cac.support.remote.DmcService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DecreaseLogCrudServiceImpl
extends BaseHashManagerService<DecreaseLog>
implements DecreaseLogCrudService {
    private static final Logger log = LoggerFactory.getLogger(DecreaseLogCrudServiceImpl.class);
    @Autowired
    private DecreaseLogRepository decreaseLogRepository;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private DmcService dmcService;

    protected DecreaseLogRepository getRepository() {
        return this.decreaseLogRepository;
    }

    public void syncDmcResourceGoodsUseRecord(String startDate, String endDate) {
        List resourceGoodsPurchaseRecordVOList = this.dmcService.findResourceGoodsPurchaseRecord();
        if (CollectionUtils.isEmpty((Collection)resourceGoodsPurchaseRecordVOList)) {
            return;
        }
        log.info("\u6388\u6743\u8bb0\u5f55:{}", (Object)JsonUtils.objToJson((Object)resourceGoodsPurchaseRecordVOList));
        for (ResourceGoodsPurchaseRecordVO resourceGoodsPurchaseRecordVO : resourceGoodsPurchaseRecordVOList) {
            PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(resourceGoodsPurchaseRecordVO.getPurchaseId());
            if (Objects.isNull(purchaseCount)) continue;
            long remainUsageCapacity = (long)purchaseCount.getTotalUsageBound() * 1024L * 1024L * 1024L - Long.parseLong(resourceGoodsPurchaseRecordVO.getOccupiedCapacity());
            if (remainUsageCapacity < 0L) {
                remainUsageCapacity = 0L;
            }
            purchaseCount.setRemainUsageCapacity(Long.valueOf(remainUsageCapacity));
            log.info("\u66f4\u65b0\u6388\u6743{}\u5269\u4f59\u5bb9\u91cf,\u5f53\u524d\u5269\u4f59\u5bb9\u91cf{},dmc\u5b9e\u9645\u4f7f\u7528\u5bb9\u91cf:{}", new Object[]{resourceGoodsPurchaseRecordVO.getPurchaseId(), purchaseCount.getRemainUsageCapacity(), resourceGoodsPurchaseRecordVO.getOccupiedCapacity()});
            this.purchaseCountCrudService.update((BaseEntity)purchaseCount);
        }
        ResourceGoodsRequest request = new ResourceGoodsRequest();
        request.setStartTime(startDate);
        request.setEndTime(endDate);
        List resourceGoodsUseRecordVOList = this.dmcService.findResourceGoodsUseRecord(request);
        ArrayList<DecreaseLog> decreaseLogList = new ArrayList<DecreaseLog>();
        for (ResourceGoodsUseRecordVO resourceGoodsUseRecordVO : resourceGoodsUseRecordVOList) {
            String productCode = resourceGoodsUseRecordVO.getProductCode();
            String tenantId = resourceGoodsUseRecordVO.getTenantId();
            String appId = resourceGoodsUseRecordVO.getAppId();
            String productName = resourceGoodsUseRecordVO.getProductName();
            long useCapacity = resourceGoodsUseRecordVO.getOccupiedCapacity();
            DecreaseLog decreaseLog = new DecreaseLog();
            decreaseLog.setLogId("");
            decreaseLog.setProductCode(productCode);
            decreaseLog.setAppId(appId);
            decreaseLog.setAppTenantId(tenantId);
            decreaseLog.setUseUsage(Long.valueOf(useCapacity));
            decreaseLog.setOperationType(DecreaseLogOperationTypeEnum.DEDUCT.getCode());
            decreaseLog.setTenantId(tenantId);
            decreaseLog.setType(DecreaseLogEnum.RESOURCE.getCode());
            decreaseLog.setProductName(productName);
            decreaseLog.setCreateDate(LocalDateTime.now().minusDays(1L));
            decreaseLog.setRemark("\u622a\u6b62\u5f53\u524d\u5df2\u4f7f\u7528\u5b58\u50a8\u6c47\u603b");
            decreaseLogList.add(decreaseLog);
        }
        this.decreaseLogRepository.saveAll(decreaseLogList);
    }
}

