/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.entity.GoodsResource;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.mapper.GoodsResourceMapper;
import com.digiwin.dap.middleware.cac.repository.GoodsResourceRepository;
import com.digiwin.dap.middleware.cac.service.basic.GoodsResourceCrudService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsResourceCrudServiceImpl
extends BaseEntityManagerService<GoodsResource>
implements GoodsResourceCrudService {
    @Autowired
    private GoodsResourceMapper goodsResourceMapper;
    @Autowired
    private GoodsResourceRepository goodsResourceRepository;

    protected GoodsResourceRepository getRepository() {
        return this.goodsResourceRepository;
    }

    @Transactional
    public void save(String code, List<String> newResourceCodes) {
        List resources = this.goodsResourceRepository.findByCode(code);
        List delResources = resources.stream().filter(p -> !newResourceCodes.contains(p.getResourceCode())).collect(Collectors.toList());
        this.goodsResourceRepository.deleteAll(delResources);
        List oldResourceCodes = resources.stream().map(GoodsResource::getResourceCode).collect(Collectors.toList());
        ArrayList newResources = new ArrayList();
        newResourceCodes.stream().filter(p -> !oldResourceCodes.contains(p)).forEach(resourceCode -> {
            GoodsResource goodsResource = new GoodsResource();
            goodsResource.setCode(code);
            goodsResource.setResourceCode(resourceCode);
            EntityUtils.setCreateFields((BaseEntity)goodsResource);
            newResources.add(goodsResource);
        });
        this.goodsResourceRepository.saveAll(newResources);
    }

    public Purchase findByCodeAndResourceCategory(String tenantId, String code, String resourceCategory) {
        return this.goodsResourceMapper.findByCodeAndResourceCategory(tenantId, code, resourceCategory);
    }

    public List<GoodsResource> findByResourceCode(String resourceCode) {
        List resources = this.goodsResourceRepository.findByResourceCode(resourceCode);
        return resources;
    }

    public List<GoodsResource> findByResourceCodeAndCode(String code, String resourceCode) {
        List resources = this.goodsResourceRepository.findByResourceCodeAndCode(resourceCode, code);
        return resources;
    }
}

