/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.mapper.PurchaseCountMapper;
import com.digiwin.dap.middleware.cac.repository.PurchaseCountRepository;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.impl.BaseHashManagerService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseCountCrudServiceImpl
extends BaseHashManagerService<PurchaseCount>
implements PurchaseCountCrudService {
    @Autowired
    private PurchaseCountMapper purchaseCountMapper;
    @Autowired
    private PurchaseCountRepository purchaseCountRepository;

    protected PurchaseCountRepository getRepository() {
        return this.purchaseCountRepository;
    }

    public Map<String, Object> getHashKey(PurchaseCount data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("purchaseId", data.getPurchaseId());
        map.put("paymentType", data.getPaymentType());
        map.put("type", data.getType());
        map.put("totalCountBound", data.getTotalCountBound());
        map.put("userCountBound", data.getUserCountBound());
        map.put("totalUsageBound", data.getTotalUsageBound());
        return map;
    }

    public void updateCustomUnit(List<String> purchaseIds, String customUnit) {
        this.purchaseCountMapper.updateCustomUnit(purchaseIds, customUnit);
    }

    public int updateRemainUsageBound(int decreaseCount, String purchaseId) {
        this.purchaseCountMapper.updateRemainUsageBound(decreaseCount, purchaseId);
        PurchaseCount purchaseCount = this.purchaseCountMapper.findByPurchaseId(purchaseId);
        return purchaseCount.getRemainUsageBound();
    }

    public void updateByPurchaseId(PurchaseCount purchaseCount) {
        this.update((BaseEntity)purchaseCount);
    }

    public PurchaseCount findByPurchaseId(String purchaseId) {
        PurchaseCount purchaseCount = this.purchaseCountRepository.findByPurchaseId(purchaseId);
        this.validate((BaseEntity)purchaseCount);
        return purchaseCount;
    }

    public List<PurchaseCount> findByPurchaseIds(List<String> purchaseIds) {
        List purchaseCounts = this.purchaseCountRepository.findByPurchaseIdIn(purchaseIds);
        purchaseCounts.forEach(arg_0 -> ((PurchaseCountCrudServiceImpl)this).validate(arg_0));
        return purchaseCounts;
    }
}

