/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.mapper.PurchaseMapper;
import com.digiwin.dap.middleware.cac.repository.PurchaseCountRepository;
import com.digiwin.dap.middleware.cac.repository.PurchaseModuleRepository;
import com.digiwin.dap.middleware.cac.repository.PurchaseRepository;
import com.digiwin.dap.middleware.cac.repository.UserInCountingRepository;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.impl.BaseHashManagerService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.serializer.Constants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseCrudServiceImpl
extends BaseHashManagerService<Purchase>
implements PurchaseCrudService {
    @Autowired
    private PurchaseMapper purchaseMapper;
    @Autowired
    private PurchaseRepository purchaseRepository;
    @Autowired
    private PurchaseCountRepository purchaseCountRepository;
    @Autowired
    private PurchaseModuleRepository purchaseModuleRepository;
    @Autowired
    private UserInCountingRepository userInCountingRepository;

    protected PurchaseRepository getRepository() {
        return this.purchaseRepository;
    }

    public Map<String, Object> getHashKey(Purchase entity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerId", entity.getCustomerId());
        map.put("productId", entity.getProductId());
        map.put("productCode", entity.getProductCode());
        map.put("itemId", entity.getItemId());
        map.put("expiredDateTime", Constants.DATE_FORMATTER.format(entity.getExpiredDateTime()));
        return map;
    }

    public Purchase findByPurchaseId(String purchaseId) {
        Purchase purchase = this.purchaseRepository.findByIdIs(purchaseId);
        this.validate((BaseEntity)purchase);
        return purchase;
    }

    public Purchase findByTenantIdAndGoodsCode(String tenantId, String goodsCode) {
        Purchase purchase = this.purchaseRepository.findFirstByCustomerIdAndProductCode(tenantId, goodsCode);
        this.validate((BaseEntity)purchase);
        return purchase;
    }

    public Purchase findByTenantIdAndGoodsSid(String tenantId, String goodsSid) {
        Purchase purchase = this.purchaseRepository.findByCustomerIdAndProductId(tenantId, goodsSid);
        this.validate((BaseEntity)purchase);
        return purchase;
    }

    public List<Purchase> findByPurchaseIds(List<String> ids) {
        List purchases = this.purchaseRepository.findByIdIn(ids);
        purchases.forEach(arg_0 -> ((PurchaseCrudServiceImpl)this).validate(arg_0));
        return purchases;
    }

    public List<Purchase> findByTenantId(String tenantId) {
        List purchases = this.purchaseRepository.findByCustomerId(tenantId);
        purchases.forEach(arg_0 -> ((PurchaseCrudServiceImpl)this).validate(arg_0));
        return purchases;
    }

    public List<Purchase> findByGoodsCode(String goodsCode) {
        List purchases = this.purchaseRepository.findByProductCode(goodsCode);
        purchases.forEach(arg_0 -> ((PurchaseCrudServiceImpl)this).validate(arg_0));
        return purchases;
    }

    public List<Purchase> findByGoodsCodeIn(List<String> goodsCodes) {
        List purchases = this.purchaseRepository.findByProductCodeIn(goodsCodes);
        purchases.forEach(arg_0 -> ((PurchaseCrudServiceImpl)this).validate(arg_0));
        return purchases;
    }

    public List<Purchase> findByTenantIdAndUserId(String tenantId, String userId) {
        List purchases = this.purchaseMapper.findByTenantIdAndUserId(tenantId, userId);
        purchases.forEach(arg_0 -> ((PurchaseCrudServiceImpl)this).validate(arg_0));
        return purchases;
    }

    public List<Purchase> findByTenantAndGoodsCodes(String tenantId, List<String> goodsCodes) {
        List purchases = this.purchaseMapper.findPurchasesByTenantAndGoodsCodes(tenantId, goodsCodes);
        purchases.forEach(arg_0 -> ((PurchaseCrudServiceImpl)this).validate(arg_0));
        return purchases;
    }

    public int deletePurchase(Purchase purchase) {
        if (purchase == null) {
            return 0;
        }
        this.purchaseCountRepository.deleteByPurchaseId(purchase.getId());
        this.purchaseModuleRepository.deleteByPurchaseId(purchase.getId());
        this.userInCountingRepository.deleteByPurchaseId(purchase.getId());
        this.purchaseRepository.deleteById((Object)purchase.getSid());
        return 1;
    }

    public int deletePurchase(List<Purchase> purchases) {
        if (purchases == null || purchases.isEmpty()) {
            return 0;
        }
        List purchaseIds = purchases.stream().map(Purchase::getId).collect(Collectors.toList());
        this.purchaseCountRepository.deleteByPurchaseIdIn(purchaseIds);
        this.purchaseModuleRepository.deleteByPurchaseIdIn(purchaseIds);
        this.userInCountingRepository.deleteByPurchaseIdIn(purchaseIds);
        return this.purchaseRepository.deleteByIdIn(purchaseIds);
    }

    public List<Purchase> findByTenantAndGoodsCodes(List<String> tenantIds, List<String> goodsCodes) {
        List purchases = this.purchaseMapper.findPurchasesByTenantsAndGoodsCodes(tenantIds, goodsCodes);
        purchases.forEach(arg_0 -> ((PurchaseCrudServiceImpl)this).validate(arg_0));
        return purchases;
    }

    public void updateInitializeState(String tenantId, String goodsCode, Integer initialize) {
        Purchase purchase = this.purchaseRepository.findFirstByCustomerIdAndProductCode(tenantId, goodsCode);
        if (purchase != null) {
            purchase.setInitialize(initialize);
            this.purchaseRepository.save((Object)purchase);
        }
    }

    public List<Purchase> findByTenantIdAndBundleCode(String tenantId, String bundleCode) {
        List purchases = this.purchaseRepository.findByCustomerIdAndBundleCode(tenantId, bundleCode);
        purchases.forEach(arg_0 -> ((PurchaseCrudServiceImpl)this).validate(arg_0));
        return purchases;
    }
}

