/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.entity.PurchaseModule;
import com.digiwin.dap.middleware.cac.repository.PurchaseModuleRepository;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseModuleCrudService;
import com.digiwin.dap.middleware.cac.service.basic.impl.BaseHashManagerService;
import com.digiwin.dap.middleware.serializer.Constants;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseModuleCrudServiceImpl
extends BaseHashManagerService<PurchaseModule>
implements PurchaseModuleCrudService {
    @Autowired
    private PurchaseModuleRepository purchaseModuleRepository;

    protected PurchaseModuleRepository getRepository() {
        return this.purchaseModuleRepository;
    }

    public Map<String, Object> getHashKey(PurchaseModule entity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("purchaseId", entity.getPurchaseId());
        map.put("moduleId", entity.getModuleId());
        map.put("moduleName", entity.getModuleName());
        map.put("totalUsageBound", entity.getTotalUsageBound());
        map.put("remainUsageBound", entity.getRemainUsageBound());
        map.put("expiredDateTime", Constants.DATE_FORMATTER.format(entity.getExpiredDateTime()));
        return map;
    }

    public List<PurchaseModule> findByPurchaseId(String purchaseId) {
        List purchaseModules = this.purchaseModuleRepository.findByPurchaseId(purchaseId);
        purchaseModules.forEach(arg_0 -> ((PurchaseModuleCrudServiceImpl)this).validate(arg_0));
        return purchaseModules;
    }

    public List<PurchaseModule> findByPurchaseIds(List<String> purchaseIds) {
        List purchaseModules = this.purchaseModuleRepository.findByPurchaseIdIn(purchaseIds);
        purchaseModules.forEach(arg_0 -> ((PurchaseModuleCrudServiceImpl)this).validate(arg_0));
        return purchaseModules;
    }

    public List<PurchaseModule> findUnExpiredByPurchaseIds(List<String> purchaseIds) {
        List purchaseModules = this.purchaseModuleRepository.findByPurchaseIdInAndExpiredDateTimeAfter(purchaseIds, LocalDateTime.now());
        purchaseModules.forEach(arg_0 -> ((PurchaseModuleCrudServiceImpl)this).validate(arg_0));
        return purchaseModules;
    }
}

