/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.domain.CommonVO;
import com.digiwin.dap.middleware.cac.domain.record.RecordConditionVO;
import com.digiwin.dap.middleware.cac.domain.record.RecordModuleItemVO;
import com.digiwin.dap.middleware.cac.domain.record.RecordModuleVO;
import com.digiwin.dap.middleware.cac.domain.record.RecordVO;
import com.digiwin.dap.middleware.cac.entity.Customer;
import com.digiwin.dap.middleware.cac.entity.Record;
import com.digiwin.dap.middleware.cac.mapper.RecordMapper;
import com.digiwin.dap.middleware.cac.repository.RecordRepository;
import com.digiwin.dap.middleware.cac.service.basic.CustomerCrudService;
import com.digiwin.dap.middleware.cac.service.basic.RecordCrudService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import com.github.pagehelper.page.PageMethod;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecordCrudServiceImpl
extends BaseEntityManagerService<Record>
implements RecordCrudService {
    @Autowired
    private RecordMapper recordMapper;
    @Autowired
    private RecordRepository recordRepository;
    @Autowired
    private CustomerCrudService customerCrudService;
    @Autowired
    private IamService iamService;

    protected RecordRepository getRepository() {
        return this.recordRepository;
    }

    public List<RecordVO> findByPage(RecordConditionVO condition) {
        PageMethod.startPage((int)condition.getPageNum(), (int)condition.getPageSize(), (String)condition.getOrderBy());
        List records = this.recordMapper.findByPage(condition, condition.getPageNum().intValue(), condition.getPageSize().intValue());
        if (!records.isEmpty()) {
            List recordSids = records.stream().map(RecordVO::getSid).collect(Collectors.toList());
            List modules = this.recordMapper.findRecordModules(recordSids);
            Map<Long, List<RecordModuleVO>> moduleMap = modules.stream().collect(Collectors.groupingBy(RecordModuleVO::getRecordSid));
            records.forEach(record -> record.setModules(moduleMap.getOrDefault(record.getSid(), Collections.emptyList())));
        }
        return records;
    }

    public List<RecordVO> findByCond(RecordConditionVO condition) {
        return this.recordMapper.findByCond(condition);
    }

    public List<RecordModuleItemVO> findItemsByCond(RecordConditionVO condition) {
        return this.recordMapper.findItemsByCond(condition);
    }

    public long create(Record entity) {
        Customer customer = this.customerCrudService.findById(entity.getTenantId());
        if (customer != null) {
            Boolean testTenant = customer.getTestTenant();
            if (testTenant == null) {
                List tenantSimples = this.iamService.getTenantSimples(Collections.singletonList(customer.getId()));
                testTenant = tenantSimples.stream().findFirst().map(CommonVO::getTestTenant).orElse(null);
            }
            entity.setTestTenant(testTenant);
        }
        return super.create((BaseEntity)entity);
    }
}

