/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.domain.unitconversion.dto.MergeUnitConversionDTO;
import com.digiwin.dap.middleware.cac.domain.unitconversion.vo.UnitConversionVO;
import com.digiwin.dap.middleware.cac.entity.DecreaseLog;
import com.digiwin.dap.middleware.cac.entity.UnitConversion;
import com.digiwin.dap.middleware.cac.repository.DecreaseLogRepository;
import com.digiwin.dap.middleware.cac.repository.UnitConversionRepository;
import com.digiwin.dap.middleware.cac.service.basic.UnitConversionService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UnitConversionServiceImpl
extends BaseEntityManagerService<UnitConversion>
implements UnitConversionService {
    @Autowired
    private UnitConversionRepository unitConversionRepository;
    @Autowired
    private DecreaseLogRepository decreaseLogRepository;

    protected JpaRepository getRepository() {
        return this.unitConversionRepository;
    }

    public Long compareAndSaveUnitConversion(MergeUnitConversionDTO dto) {
        UnitConversion unitConversion = this.unitConversionRepository.findById((Object)dto.getSid()).orElse(null);
        UnitConversion newUnitConversion = this.buildUnitConversion(dto);
        if (Objects.isNull(unitConversion)) {
            return this.create((BaseEntity)newUnitConversion);
        }
        newUnitConversion.setSid(unitConversion.getSid());
        this.update((BaseEntity)newUnitConversion);
        return newUnitConversion.getSid();
    }

    public void deleteUnitConversion(String id, String goodsCode) {
        UnitConversionVO unitConversionVO = this.findUnitConversionByIdAndGoodsCode(id, goodsCode);
        if (Objects.isNull(unitConversionVO)) {
            throw new BusinessException("\u5546\u54c1\u5355\u4f4d\u6362\u7b97\u914d\u7f6e\u4e0d\u5b58\u5728!");
        }
        List decreaseLogList = this.decreaseLogRepository.findByUnitConversionIdAndProductCode(unitConversionVO.getId(), unitConversionVO.getGoodsCode());
        if (!CollectionUtils.isEmpty((Collection)decreaseLogList)) {
            throw new BusinessException("\u5546\u54c1\u5355\u4f4d\u6362\u7b97\u914d\u7f6e\u5df2\u88ab\u4f7f\u7528,\u4e0d\u53ef\u5220\u9664!");
        }
        this.deleteById(unitConversionVO.getSid().longValue());
    }

    public UnitConversionVO findUnitConversionByIdAndGoodsCode(String id, String goodsCode) {
        List unitConversionList = this.unitConversionRepository.findUnitConversionByIdAndGoodsCode(id, goodsCode);
        if (CollectionUtils.isEmpty((Collection)unitConversionList)) {
            return null;
        }
        if (unitConversionList.size() > 1) {
            throw new BusinessException("\u5f53\u524d\u5546\u54c1\u5b58\u5728\u76f8\u540c\u7684\u5355\u4f4d\u8f6c\u6362\u914d\u7f6e!");
        }
        return this.buildUnitConversionVO((UnitConversion)unitConversionList.get(0));
    }

    public List<DecreaseLog> findDecreaseLogByGoodsCodeAndUnitConversionId(String goodsCode, String unitConversionId) {
        List decreaseLogList = this.decreaseLogRepository.findByUnitConversionIdAndProductCode(unitConversionId, goodsCode);
        return decreaseLogList;
    }

    private UnitConversion buildUnitConversion(MergeUnitConversionDTO dto) {
        if (dto == null) {
            return null;
        }
        UnitConversion unitConversion = new UnitConversion();
        unitConversion.setSid(dto.getSid().longValue());
        unitConversion.setId(dto.getId());
        unitConversion.setName(dto.getName());
        unitConversion.setConversionPoint(dto.getConversionPoint());
        unitConversion.setDescription(dto.getDescription());
        unitConversion.setGoodsCode(dto.getGoodsCode());
        unitConversion.setCreateBy(dto.getCreateBy());
        unitConversion.setCreateById(dto.getCreateById());
        unitConversion.setCreateDate(dto.getCreateDate());
        unitConversion.setModifyBy(dto.getModifyBy());
        unitConversion.setModifyById(dto.getModifyById());
        unitConversion.setModifyDate(dto.getModifyDate());
        return unitConversion;
    }

    private UnitConversionVO buildUnitConversionVO(UnitConversion unitConversion) {
        if (unitConversion == null) {
            return null;
        }
        UnitConversionVO unitConversionVO = new UnitConversionVO();
        unitConversionVO.setId(unitConversion.getId());
        unitConversionVO.setName(unitConversion.getName());
        unitConversionVO.setConversionPoint(unitConversion.getConversionPoint());
        unitConversionVO.setDescription(unitConversion.getDescription());
        unitConversionVO.setGoodsCode(unitConversion.getGoodsCode());
        unitConversionVO.setSid(Long.valueOf(unitConversion.getSid()));
        unitConversionVO.setCreateBy(unitConversion.getCreateBy());
        unitConversionVO.setCreateById(unitConversion.getCreateById());
        unitConversionVO.setCreateDate(unitConversion.getCreateDate());
        unitConversionVO.setModifyBy(unitConversion.getModifyBy());
        unitConversionVO.setModifyById(unitConversion.getModifyById());
        unitConversionVO.setModifyDate(unitConversion.getModifyDate());
        return unitConversionVO;
    }
}

