/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.basic.impl;

import com.digiwin.dap.middleware.cac.domain.enumeration.ProductType;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.UserInCounting;
import com.digiwin.dap.middleware.cac.mapper.UserInCountingMapper;
import com.digiwin.dap.middleware.cac.repository.UserInCountingRepository;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.UserInCountingCrudService;
import com.digiwin.dap.middleware.cac.service.basic.impl.BaseHashManagerService;
import com.digiwin.dap.middleware.cac.util.UserIdUtil;
import com.digiwin.dap.middleware.entity.BaseEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserInCountingCrudServiceImpl
extends BaseHashManagerService<UserInCounting>
implements UserInCountingCrudService {
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private UserInCountingRepository userInCountingRepository;
    @Autowired
    private UserInCountingMapper userInCountingMapper;
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private UserInCountingCrudService userInCountingCrudService;

    protected UserInCountingRepository getRepository() {
        return this.userInCountingRepository;
    }

    public Map<String, Object> getHashKey(UserInCounting entity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("purchaseId", entity.getPurchaseId());
        map.put("userId", entity.getUserId());
        return map;
    }

    public int addUser(String purchaseId, String userId) {
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchaseId);
        int userIdCount = this.userInCountingRepository.countByPurchaseIdAndUserId(purchaseId, userId);
        if (userIdCount == 0) {
            this.create((BaseEntity)new UserInCounting(purchaseId, userId));
            if (!UserIdUtil.isDigiwin((String)userId)) {
                purchaseCount.setUserCountBound(purchaseCount.getUserCountBound() + 1);
                this.purchaseCountCrudService.update((BaseEntity)purchaseCount);
            }
        }
        Purchase purchase = this.purchaseCrudService.findByPurchaseId(purchaseId);
        if (ProductType.bundle.name().equals(purchase.getProductType())) {
            List children = this.purchaseCrudService.findByTenantIdAndBundleCode(purchase.getCustomerId(), purchase.getProductCode());
            for (Purchase child : children) {
                this.userInCountingCrudService.addUser(child.getId(), userId);
            }
        }
        return purchaseCount.getUserCountBound();
    }

    public int removeUser(String purchaseId, String userId) {
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchaseId);
        int userIdCount = this.userInCountingRepository.countByPurchaseIdAndUserId(purchaseId, userId);
        if (userIdCount != 0) {
            this.userInCountingRepository.deleteByPurchaseIdAndUserId(purchaseId, userId);
            if (!UserIdUtil.isDigiwin((String)userId)) {
                purchaseCount.setUserCountBound(purchaseCount.getUserCountBound() - 1);
                this.purchaseCountCrudService.update((BaseEntity)purchaseCount);
            }
        }
        Purchase purchase = this.purchaseCrudService.findByPurchaseId(purchaseId);
        if (ProductType.bundle.name().equals(purchase.getProductType())) {
            List children = this.purchaseCrudService.findByTenantIdAndBundleCode(purchase.getCustomerId(), purchase.getProductCode());
            for (Purchase child : children) {
                this.userInCountingCrudService.removeUser(child.getId(), userId);
            }
        }
        return purchaseCount.getUserCountBound();
    }

    @Transactional
    public int batchRemoveUser(String purchaseId, List<String> userIds) {
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchaseId);
        Set exist = this.userInCountingMapper.getAuthedUserIdsByPurchaseIdAndUserIds(purchaseId, userIds);
        int released = 0;
        for (String userId : userIds) {
            if (!exist.contains(userId) || UserIdUtil.isDigiwin((String)userId)) continue;
            ++released;
        }
        purchaseCount.setUserCountBound(purchaseCount.getUserCountBound() - released);
        this.purchaseCountCrudService.update((BaseEntity)purchaseCount);
        this.userInCountingMapper.batchRemoveUser(purchaseId, userIds);
        Purchase purchase = this.purchaseCrudService.findByPurchaseId(purchaseId);
        if (ProductType.bundle.name().equals(purchase.getProductType())) {
            List children = this.purchaseCrudService.findByTenantIdAndBundleCode(purchase.getCustomerId(), purchase.getProductCode());
            for (Purchase child : children) {
                this.userInCountingCrudService.batchRemoveUser(child.getId(), userIds);
            }
        }
        return purchaseCount.getUserCountBound();
    }

    public List<UserInCounting> findByPurchaseId(String purchaseId) {
        List userInCountings = this.userInCountingRepository.findByPurchaseId(purchaseId);
        userInCountings.forEach(arg_0 -> ((UserInCountingCrudServiceImpl)this).validate(arg_0));
        return userInCountings;
    }

    public int countByPurchaseIdAndUserId(String purchaseId, String userId) {
        return this.userInCountingRepository.countByPurchaseIdAndUserId(purchaseId, userId);
    }
}

