/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cac.constant.I18nCode;
import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.AddBundleChildVO;
import com.digiwin.dap.middleware.cac.domain.AuthCompareResultVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationActionVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationCheckedVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleWithPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.CopyAppAuthVO;
import com.digiwin.dap.middleware.cac.domain.CountResultVO;
import com.digiwin.dap.middleware.cac.domain.CustomAttributeWithPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.EditParamVO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.ModuleAuthorizationCheckedVO;
import com.digiwin.dap.middleware.cac.domain.ObsoleteCheckResult;
import com.digiwin.dap.middleware.cac.domain.ObsoleteTenantAuthInfo;
import com.digiwin.dap.middleware.cac.domain.PurchaseDetailVO;
import com.digiwin.dap.middleware.cac.domain.PurchaseUserCountInfoVO;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.SearchParamVO;
import com.digiwin.dap.middleware.cac.domain.TenantPurchaseParameterVO;
import com.digiwin.dap.middleware.cac.domain.TenantPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.cac.domain.enumeration.NoAuthType;
import com.digiwin.dap.middleware.cac.domain.enumeration.Operate;
import com.digiwin.dap.middleware.cac.domain.enumeration.PaymentType;
import com.digiwin.dap.middleware.cac.domain.enumeration.ProductType;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsAuthDO;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsVO;
import com.digiwin.dap.middleware.cac.domain.remote.MarketingConfigDetailVO;
import com.digiwin.dap.middleware.cac.domain.remote.UserInTenantVO;
import com.digiwin.dap.middleware.cac.entity.Customer;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.PurchaseModule;
import com.digiwin.dap.middleware.cac.entity.UserInCounting;
import com.digiwin.dap.middleware.cac.mapper.PurchaseCountMapper;
import com.digiwin.dap.middleware.cac.mapper.PurchaseMapper;
import com.digiwin.dap.middleware.cac.repository.CustomerRepository;
import com.digiwin.dap.middleware.cac.service.basic.CustomerCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseModuleCrudService;
import com.digiwin.dap.middleware.cac.service.basic.UserInCountingCrudService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeArchiveService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeQueryService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeRegistrarService;
import com.digiwin.dap.middleware.cac.service.business.RecordService;
import com.digiwin.dap.middleware.cac.service.business.UserCountService;
import com.digiwin.dap.middleware.cac.service.business.impl.AuthorizeArchiveServiceImpl;
import com.digiwin.dap.middleware.cac.service.paymenttype.PaymentTypeContext;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.cac.support.remote.LmcService;
import com.digiwin.dap.middleware.cac.support.remote.MailService;
import com.digiwin.dap.middleware.cac.support.remote.OmcService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.internal.BusinessTypeEnum;
import com.digiwin.dap.middleware.lmc.request.SaveCompareOpLog;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AuthorizeArchiveServiceImpl
implements AuthorizeArchiveService {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizeArchiveServiceImpl.class);
    private static final ObjectMapper OBJECT_MAPPER = JsonUtils.createObjectMapper();
    @Autowired
    private IamService iamService;
    @Autowired
    private MailService mailService;
    @Autowired
    private PurchaseMapper purchaseMapper;
    @Autowired
    private CustomerCrudService customerCrudService;
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private UserCountService userCountService;
    @Autowired
    private PaymentTypeContext paymentTypeContext;
    @Autowired
    private PurchaseCountMapper purchaseCountMapper;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private AuthorizeQueryService authorizeQueryService;
    @Autowired
    private AuthorizeRegistrarService authorizeRegistrarService;
    @Autowired
    private PurchaseModuleCrudService purchaseModuleCrudService;
    @Autowired
    private UserInCountingCrudService userInCountingCrudService;
    @Autowired
    private LmcService lmcService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private RecordService recordService;
    @Autowired
    private OmcService omcService;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private EnvProperties envProperties;

    public void purchaseAuthorization(TenantPurchaseVO info) {
        this.saveAuthorization(info, info.getUpdateTenantAuth().booleanValue());
    }

    public void purchaseAuthorizationWithCountUser(TenantPurchaseVO info) {
        this.saveAuthorization(info, false);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAuthorizationsBufferPeriod(EditParamVO body) throws CloneNotSupportedException {
        List platFormGoodsInfos;
        CloudPurchaseDTO bundle;
        AuthorizationVO originAuthVO = this.authorizeQueryService.getAuthorization(body.getTenantId(), body.getProductCode());
        this.checkAuth(body, originAuthVO);
        body.setBufferPeriod(Boolean.TRUE);
        LocalDateTime calcExpiredDatieTime = originAuthVO.getExpiredTime().plusDays(body.getAuthorizationDays().intValue()).with(LocalTime.MAX).withNano(0);
        body.setExpiredTime(calcExpiredDatieTime);
        body.setEffectiveTime(originAuthVO.getEffectiveTime());
        body.setRemainingUsage(Integer.valueOf(originAuthVO.getRemainingUsage()));
        body.setTotalUsage(Integer.valueOf(originAuthVO.getTotalUsage()));
        body.setPaymentType(originAuthVO.getPaymentType());
        body.setMemo(I18nCode.EXPIRATION_SYSTEM_BUFFER_EXTENSION.getMessage());
        boolean empty = CollectionUtils.isEmpty((Collection)body.getModules());
        ArrayList<AuthorizationModuleVO> updateModules = new ArrayList<AuthorizationModuleVO>();
        for (AuthorizationModuleVO oldModule : originAuthVO.getEnabledModules()) {
            if (!empty && !body.getModules().stream().anyMatch(o -> oldModule.getId().equals(o.getId()))) continue;
            AuthorizationModuleVO updateModule = oldModule.clone();
            updateModule.setExpiredTime(updateModule.getExpiredTime().plusDays(body.getAuthorizationDays().intValue()).with(LocalTime.MAX).withNano(0));
            updateModules.add(updateModule);
        }
        body.setModules(updateModules);
        this.updatePurchaseAuthorization(body);
        if (com.digiwin.dap.middleware.util.StringUtils.hasLength((String)originAuthVO.getBundleCode()) && calcExpiredDatieTime.isAfter((bundle = this.authorizeQueryService.getCloudPurchase(body.getTenantId(), originAuthVO.getBundleCode())).getExpiredDateTime())) {
            bundle.setExpiredDateTime(calcExpiredDatieTime);
            bundle.getModules().forEach(module -> module.setExpiredTime(calcExpiredDatieTime));
            this.authorizeRegistrarService.update(bundle);
        }
        if (!CollectionUtils.isEmpty((Collection)(platFormGoodsInfos = this.gmcService.getPlatFormGoodsInfo(body.getTenantId(), body.getProductCode())))) {
            List platFormCodes = platFormGoodsInfos.stream().map(MarketingConfigDetailVO::getAttachedGoodsCode).collect(Collectors.toList());
            List platFormAuthInfos = this.authorizeQueryService.getCloudPurchase(Arrays.asList(body.getTenantId()), platFormCodes);
            platFormAuthInfos.forEach(p -> {
                if (calcExpiredDatieTime.isAfter(p.getExpiredDateTime())) {
                    p.setExpiredDateTime(calcExpiredDatieTime);
                    p.setMemo(I18nCode.EXPIRATION_SYSTEM_BUFFER_EXTENSION.getMessage());
                    MarketingConfigDetailVO match = platFormGoodsInfos.stream().filter(g -> g.getAttachedGoodsCode().equals(p.getProductCode())).findFirst().orElse(null);
                    if (null != match) {
                        match.getAttachedModules().forEach(m -> {
                            Optional<EnabledModuleDTO> enabledModuleDTO = p.getModules().stream().filter(pm -> pm.getId().equals(m.getId())).findFirst();
                            if (enabledModuleDTO.isPresent()) {
                                EnabledModuleDTO enabledModule = enabledModuleDTO.get();
                                enabledModule.setExpiredTime(calcExpiredDatieTime);
                                if (null != m.getActions()) {
                                    List actionVOS = this.deserializeActions(enabledModule.getActions());
                                    m.getActions().forEach(a -> {
                                        AuthorizationActionVO matchAction = actionVOS.stream().filter(ga -> a.getId().equals(ga.getId())).findFirst().orElse(null);
                                        matchAction.setExpiredTime(calcExpiredDatieTime);
                                    });
                                    enabledModule.setActions(JsonUtils.objToJson((Object)actionVOS));
                                }
                            }
                        });
                    }
                    this.authorizeRegistrarService.update(p);
                }
            });
        }
        this.appAuthChangeLogs(originAuthVO);
    }

    private List<AuthorizationActionVO> deserializeActions(String actions) {
        if (StringUtils.hasLength((String)actions)) {
            try {
                return (List)JsonUtils.createObjectMapper().readValue(actions, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return new ArrayList<AuthorizationActionVO>();
    }

    private void saveAuthorization(TenantPurchaseVO info, boolean update) {
        if (!this.customerCrudService.existsById(info.getTenantId())) {
            this.customerCrudService.create((BaseEntity)new Customer(info.getTenantId(), info.getTenantName()));
        }
        List purchases = this.authorizeQueryService.getCloudPurchase(info.getTenantId(), info.getAuthorizations().stream().map(a -> a.getCode()).collect(Collectors.toList()));
        Map<String, CloudPurchaseDTO> purchaseMap = purchases.stream().collect(Collectors.toMap(CloudPurchaseDTO::getProductCode, a -> a, (k1, k2) -> k1));
        for (PurchaseVO domainAuth : info.getAuthorizations()) {
            CloudPurchaseDTO entityAuth = purchaseMap.get(domainAuth.getCode());
            if (entityAuth != null && GoodsCategoryEnum.isApp((String)domainAuth.getCategoryId())) {
                if (entityAuth.getPaymentType() != domainAuth.getPaymentType()) {
                    if (Objects.equals(0, this.envProperties.getCloud())) {
                        throw new IllegalArgumentException(I18nError.ERROR_10005.getErrorMessage());
                    }
                    entityAuth.setPaymentType(domainAuth.getPaymentType());
                }
                if (update) {
                    domainAuth.setEffectiveTime(domainAuth.getEffectiveTime() == null ? LocalDateTime.now() : domainAuth.getEffectiveTime());
                    if (domainAuth.getEffectiveTime() != null && entityAuth.getExpiredDateTime() != null && domainAuth.getEffectiveTime().isAfter(entityAuth.getExpiredDateTime())) {
                        entityAuth.setEffectiveDateTime(domainAuth.getEffectiveTime());
                    }
                    entityAuth.setSourceId(domainAuth.getSourceId());
                    entityAuth.setSourceCode(domainAuth.getSourceCode());
                    entityAuth.setMemo(domainAuth.getMemo());
                    entityAuth.setCustomattributes(domainAuth.getCustomattributes());
                    entityAuth.setBundleCode(domainAuth.getBundleCode());
                    entityAuth.setBundleName(domainAuth.getBundleName());
                    this.paymentTypeContext.decideUpdatePaymentType(entityAuth, domainAuth);
                    Optional.ofNullable(domainAuth.getBufferPeriod()).ifPresent(arg_0 -> ((CloudPurchaseDTO)entityAuth).setBufferPeriod(arg_0));
                    entityAuth.setExpireNotice(domainAuth.getExpireNotice());
                    entityAuth.setBatchCode(info.getBatchCode());
                    entityAuth.setCustomUnit(domainAuth.getCustomUnit());
                    entityAuth.setResourceCategory(domainAuth.getResourceCategory());
                    if (Objects.nonNull(entityAuth.getRemainUsageCapacity())) {
                        long remainUsageCapacity = entityAuth.getRemainUsageCapacity() + (long)domainAuth.getTotalUsage() * 0x40000000L;
                        entityAuth.setRemainUsageCapacity(Long.valueOf(remainUsageCapacity));
                    }
                    this.authorizeRegistrarService.update(entityAuth);
                    this.processBundle(info, domainAuth, entityAuth);
                }
                this.addAuthUser(info, domainAuth.getCode());
                continue;
            }
            if (!GoodsCategoryEnum.isApp((String)domainAuth.getCategoryId()) && !GoodsCategoryEnum.isDevice((String)domainAuth.getCategoryId())) {
                domainAuth.setPaymentType(PaymentType.NoControl.ordinal());
            }
            CloudPurchaseDTO cloudPurchaseDTO = new CloudPurchaseDTO(info, domainAuth, purchases.size() + 1);
            this.paymentTypeContext.decidePaymentType(cloudPurchaseDTO, domainAuth);
            this.authorizeRegistrarService.insert(cloudPurchaseDTO);
            this.addAuthUser(info, domainAuth.getCode());
            this.processBundle(info, domainAuth, entityAuth);
        }
    }

    private void processBundle(TenantPurchaseVO info, PurchaseVO domainAuth, CloudPurchaseDTO entityAuth) {
        String tenantId = info.getTenantId();
        if (com.digiwin.dap.middleware.util.StringUtils.hasLength((String)domainAuth.getBundleCode())) {
            Purchase bundlePurchase;
            List userInCountings;
            Purchase oldPurchase;
            if (entityAuth != null && ObjectUtils.nullSafeEquals((Object)entityAuth.getBundleCode(), (Object)domainAuth.getBundleCode()) && (oldPurchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, domainAuth.getCode())) != null) {
                userInCountings = this.userInCountingCrudService.findByPurchaseId(oldPurchase.getId());
                this.userCountService.deleteUserInCountings(userInCountings, oldPurchase.getId());
                this.lmcService.saveCleanUser(oldPurchase, userInCountings, info.getTenantId(), "\u4ee5\u524d\u4e0d\u662f\u95ed\u73af\u5b50\u5546\u54c1\uff0c\u53d8\u6210\u95ed\u73af\u5b50\u5546\u54c1\uff0c\u8981\u5220\u9664\u65e7\u6388\u6743\u7528\u6237");
            }
            if ((bundlePurchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, domainAuth.getBundleCode())) != null) {
                userInCountings = this.userInCountingCrudService.findByPurchaseId(bundlePurchase.getId());
                List userIds = userInCountings.stream().map(UserInCounting::getUserId).collect(Collectors.toList());
                this.userCountService.batchUpdateUser(tenantId, domainAuth.getCode(), userIds);
            }
        }
    }

    private CountResultVO addAuthUser(TenantPurchaseVO authInfo, String goodsCode) {
        CountResultVO countResult;
        if (com.digiwin.dap.middleware.util.StringUtils.isNotEmpty((String)authInfo.getUserId()) && authInfo.isAuthUser()) {
            CountResultVO countResultVO = this.userCountService.addUser(authInfo.getTenantId(), goodsCode, authInfo.getUserId());
            if (!countResultVO.getSuccess().booleanValue()) {
                logger.error(String.format("\u6388\u6743\u7528\u6237\u5931\u8d25\uff0c\u603bU\u6570%s\uff0c\u5f53\u524dU\u6570%s", countResultVO.getTotalCount(), countResultVO.getCurrentCount()));
            }
        } else if (!CollectionUtils.isEmpty((Collection)authInfo.getUserIds()) && !(countResult = this.userCountService.batchUpdateUser(authInfo.getTenantId(), goodsCode, authInfo.getUserIds())).getSuccess().booleanValue()) {
            logger.error(String.format("\u6388\u6743\u7528\u6237\u5931\u8d25\uff0c\u603bU\u6570%s\uff0c\u5f53\u524dU\u6570%s", countResult.getTotalCount(), countResult.getCurrentCount()));
        }
        return new CountResultVO(false, 0, 0);
    }

    public List<CloudPurchaseDTO> calculateAuthorization(TenantPurchaseVO info) {
        ArrayList<CloudPurchaseDTO> results = new ArrayList<CloudPurchaseDTO>();
        if (this.customerCrudService.existsById(info.getTenantId())) {
            List purchases = this.authorizeQueryService.getCloudPurchase(info.getTenantId());
            info.getAuthorizations().forEach(authorizationVO -> {
                CloudPurchaseDTO existed = purchases.stream().filter(p -> p.getProductCode().equals(authorizationVO.getCode())).findFirst().orElse(null);
                if (existed != null) {
                    if (existed.getPaymentType() != authorizationVO.getPaymentType()) {
                        throw new IllegalArgumentException(I18nError.ERROR_10005.getErrorMessage());
                    }
                    this.paymentTypeContext.decideUpdatePaymentType(existed, authorizationVO);
                } else {
                    existed = new CloudPurchaseDTO(info, authorizationVO, purchases.size() + 1);
                    if (!ProductType.isApp((String)authorizationVO.getCategoryId())) {
                        authorizationVO.setPaymentType(PaymentType.NoControl.ordinal());
                        existed.setPaymentType(PaymentType.NoControl.ordinal());
                    }
                    this.paymentTypeContext.decidePaymentType(existed, authorizationVO);
                }
                results.add(existed);
            });
        }
        return results;
    }

    public void updatePurchaseAuthorization(EditParamVO editParamVO) {
        List purchases = this.authorizeQueryService.getCloudPurchase(editParamVO.getTenantId());
        CloudPurchaseDTO existed = purchases.stream().filter(p -> p.getProductCode().equals(editParamVO.getProductCode())).findFirst().orElse(null);
        if (null != existed) {
            LocalDateTime oldExpiredTime;
            ArrayList modules = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)editParamVO.getModules())) {
                editParamVO.getModules().forEach(o -> {
                    ArrayList existedModules = new ArrayList();
                    existed.getModules().forEach(j -> {
                        if (o.getId().equals(j.getId())) {
                            existedModules.add(j);
                            if (!o.getExpiredTime().isEqual(j.getExpiredTime())) {
                                EnabledModuleDTO enabledModuleDTO = new EnabledModuleDTO(o.getId(), o.getName(), o.getExpiredTime(), j.getExpiredTime());
                                modules.add(enabledModuleDTO);
                            }
                        }
                    });
                    if (existedModules.size() == 0) {
                        EnabledModuleDTO enabledModuleDTO = new EnabledModuleDTO(o.getId(), o.getName(), o.getExpiredTime(), o.getExpiredTime());
                        modules.add(enabledModuleDTO);
                    }
                });
            }
            if (null != (oldExpiredTime = existed.getExpiredDateTime()) && null != editParamVO.getEffectiveTime() && editParamVO.getEffectiveTime().isAfter(oldExpiredTime)) {
                logger.info("saveAuthorization existed.getExpiredDateTime():{}, authorizationVO.getEffectiveTime():{}", (Object)oldExpiredTime.toString(), (Object)editParamVO.getEffectiveTime().toString());
                existed.setEffectiveDateTime(editParamVO.getEffectiveTime());
            }
            if (existed.getPaymentType() != editParamVO.getPaymentType()) {
                throw new IllegalArgumentException(I18nError.ERROR_10005.getErrorMessage());
            }
            this.paymentTypeContext.decideUpdatePaymentType(existed, editParamVO);
            Optional.ofNullable(editParamVO.getBufferPeriod()).ifPresent(arg_0 -> ((CloudPurchaseDTO)existed).setBufferPeriod(arg_0));
            existed.setMemo(editParamVO.getMemo());
            existed.setSourceId(editParamVO.getSourceId());
            existed.setSourceCode(editParamVO.getSourceCode());
            existed.setExpireNotice(editParamVO.getExpireNotice());
            existed.setBatchCode(editParamVO.getBatchCode());
            if (!CollectionUtils.isEmpty((Collection)editParamVO.getCustomAttributes())) {
                existed.setCustomattributes(JsonUtils.objToJson((Object)editParamVO.getCustomAttributes()));
            }
            this.authorizeRegistrarService.update(existed);
            if (Boolean.TRUE.equals(editParamVO.getCurrentTenant()) || !CollectionUtils.isEmpty((Collection)editParamVO.getEmails())) {
                this.mailService.sendChangeAuthorizationExpiredTime(existed.getProductName(), oldExpiredTime, editParamVO.getExpiredTime(), editParamVO.getEmails(), editParamVO.getCurrentTenant(), editParamVO.getTenantId(), editParamVO.getTenantName(), modules);
            }
        }
    }

    public void batchUpdatePurchaseAuthorization(TenantPurchaseParameterVO tenantPurchaseInfo) {
        List tenantIds = tenantPurchaseInfo.getTenantIds();
        List modules = tenantPurchaseInfo.getModules();
        if (modules.size() == 0 || tenantIds.size() == 0) {
            throw new IllegalArgumentException(I18nError.ERROR_10024.getErrorMessage());
        }
        ArrayList<CloudPurchaseDTO> cloudPurchases = new ArrayList<CloudPurchaseDTO>();
        for (String tenantId : tenantIds) {
            CloudPurchaseDTO existed = this.authorizeQueryService.getCloudPurchase(tenantId, tenantPurchaseInfo.getAppId());
            if (existed == null || com.digiwin.dap.middleware.util.StringUtils.hasLength((String)tenantPurchaseInfo.getStrategySid()) && !tenantPurchaseInfo.getStrategySid().equals(existed.getStrategyId()) || tenantPurchaseInfo.isExcludeExpiredTenant() && existed.getExpiredDateTime().isBefore(LocalDateTime.now())) continue;
            if (existed.getPaymentType() != tenantPurchaseInfo.getPaymentType()) {
                throw new IllegalArgumentException(I18nError.ERROR_10005.getErrorMessage());
            }
            ArrayList newModules = new ArrayList(modules);
            this.paymentTypeContext.decideUpdatePaymentType(existed, newModules);
            if (existed.getModules().isEmpty()) continue;
            existed.setSourceId(tenantPurchaseInfo.getSourceId());
            existed.setSourceCode(tenantPurchaseInfo.getSourceCode());
            cloudPurchases.add(existed);
        }
        if (!cloudPurchases.isEmpty()) {
            this.authorizeRegistrarService.batchUpdate(cloudPurchases, tenantPurchaseInfo.getEmailSend().booleanValue());
            this.recordService.addRecord(Operate.Update, cloudPurchases);
        }
    }

    public PageSerializable<AuthorizationVO> getAuthorizationByPage(SearchParamVO searchParamVO, int pageNum, int pageSize, String orderBy, boolean enableDataPolicy) {
        List goodsCodeList;
        List goods;
        List<Object> purchases = enableDataPolicy ? this.purchaseMapper.findPurchases(searchParamVO, pageNum, pageSize, orderBy) : this.purchaseMapper.findPurchasesExcludePolicy(searchParamVO, pageNum, pageSize, orderBy);
        if (com.digiwin.dap.middleware.util.StringUtils.isNotEmpty((String)searchParamVO.getGoodsCategoryId()) && !CollectionUtils.isEmpty((Collection)purchases) && !CollectionUtils.isEmpty((Collection)(goods = this.gmcService.getGoodsByGoodsCategoryId(goodsCodeList = purchases.stream().map(Purchase::getProductCode).collect(Collectors.toList()), searchParamVO.getGoodsCategoryId())))) {
            List goodsCodeByCategoryIds = goods.stream().map(GoodsVO::getGoodsCode).collect(Collectors.toList());
            purchases = purchases.stream().filter(o -> goodsCodeByCategoryIds.contains(o.getProductCode())).collect(Collectors.toList());
        }
        PageSerializable purchasePage = PageSerializable.of((List)purchases);
        List authorizations = this.authorizeQueryService.getAuthorizations((List)purchases, Boolean.valueOf(true), Boolean.valueOf(Boolean.TRUE.equals(searchParamVO.getCountApiInvoke())));
        this.populateGoodsInfo(authorizations);
        PageSerializable authorizationPage = PageSerializable.of((List)authorizations);
        authorizationPage.setTotal(purchasePage.getTotal());
        return authorizationPage;
    }

    private void populateGoodsInfo(List<AuthorizationVO> authorizations) {
        if (CollectionUtils.isEmpty(authorizations)) {
            return;
        }
        List goodsList = this.gmcService.getGoodsByGoodsCodes(authorizations.stream().map(AuthorizationVO::getCode).collect(Collectors.toList()));
        Map goodsMap = goodsList.stream().collect(Collectors.toMap(GoodsVO::getCode, Function.identity()));
        authorizations.forEach(a -> {
            GoodsVO goodVO = goodsMap.getOrDefault(a.getCode(), new GoodsVO());
            a.setMarket(goodVO.getMarket());
            a.setOnShelve(goodVO.getOnSale());
            a.setGoodsSid(goodVO.getId());
        });
    }

    public List<CloudPurchaseDTO> queryCloudPurchaseList(String tenantId) {
        if (!this.customerCrudService.existsById(tenantId)) {
            return new ArrayList<CloudPurchaseDTO>();
        }
        return this.authorizeQueryService.getCloudPurchase(tenantId);
    }

    private List<CloudPurchaseDTO> queryCloudPurchaseList(String customerId, List<String> appIds) {
        if (!this.customerCrudService.existsById(customerId)) {
            return new ArrayList<CloudPurchaseDTO>();
        }
        return this.authorizeQueryService.getCloudPurchase(customerId, appIds);
    }

    public AuthorizationModuleWithPurchaseVO getAuthorizationModule(String tenantId, String goodsCode) {
        AuthorizationVO authorization = this.authorizeQueryService.getAuthorization(tenantId, goodsCode);
        if (authorization == null) {
            return null;
        }
        return new AuthorizationModuleWithPurchaseVO(authorization);
    }

    public CustomAttributeWithPurchaseVO getAuthorizationCustomAttribute(String customerId, String productCode) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(customerId, productCode);
        if (purchase == null) {
            return null;
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        return new CustomAttributeWithPurchaseVO(purchase, purchaseCount);
    }

    public AuthorizationCheckedVO checkUserCanUseProduct(String customerId, String productCode, String userId, Boolean checkUserAuth) {
        CloudPurchaseDTO purchase = this.purchaseCountMapper.findPurchaseGoods(customerId, productCode);
        if (purchase == null) {
            return new AuthorizationCheckedVO(NoAuthType.noPurchase.name());
        }
        if (!this.paymentTypeContext.checkAuthorizationValid(purchase).booleanValue()) {
            return new AuthorizationCheckedVO(NoAuthType.expired.name());
        }
        if (checkUserAuth.booleanValue() && !this.userCountService.checkUserInCounting(purchase.getPurchaseId(), userId)) {
            return new AuthorizationCheckedVO(NoAuthType.noAuthorization.name());
        }
        return new AuthorizationCheckedVO(true, purchase.getExpiredDateTime(), customerId, Collections.emptyList());
    }

    public AuthorizationCheckedVO checkUserProductAuthorization(String tenantId, String goodsCode, String userId) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        if (purchase == null) {
            return new AuthorizationCheckedVO(false);
        }
        return new AuthorizationCheckedVO(this.userCountService.checkUserInCounting(purchase.getId(), userId));
    }

    public AuthorizationCheckedVO checkUserCanUseModule(String customerId, String productCode, String moduleId, String userId) {
        CloudPurchaseDTO purchase = this.authorizeQueryService.getCloudPurchase(customerId, productCode);
        if (purchase == null) {
            return new AuthorizationCheckedVO(false);
        }
        if (!this.paymentTypeContext.checkAuthorizationValid(purchase).booleanValue()) {
            return new AuthorizationCheckedVO(false);
        }
        if (!this.userCountService.checkUserInCounting(purchase.getPurchaseId(), userId)) {
            return new AuthorizationCheckedVO(false);
        }
        EnabledModuleDTO module = purchase.getModules().stream().filter(m -> m.getId().equals(moduleId)).findFirst().orElse(null);
        if (module == null) {
            return new AuthorizationCheckedVO(false);
        }
        return new AuthorizationCheckedVO(this.paymentTypeContext.checkModuleInvalid(purchase.getPaymentType(), module).booleanValue());
    }

    public List<ModuleAuthorizationCheckedVO> checkUserCanUseModules(String customerId, String productCode, String userId) {
        CloudPurchaseDTO purchase = this.authorizeQueryService.getCloudPurchase(customerId, productCode);
        ArrayList<ModuleAuthorizationCheckedVO> result = new ArrayList<ModuleAuthorizationCheckedVO>();
        if (purchase == null) {
            return result;
        }
        if (!this.paymentTypeContext.checkAuthorizationValid(purchase).booleanValue() || !this.userCountService.checkUserInCounting(purchase.getPurchaseId(), userId)) {
            purchase.getModules().forEach(module -> result.add(new ModuleAuthorizationCheckedVO(module.getId(), Boolean.valueOf(false))));
            return result;
        }
        purchase.getModules().forEach(module -> result.add(new ModuleAuthorizationCheckedVO(module.getId(), this.paymentTypeContext.checkModuleInvalid(purchase.getPaymentType(), module))));
        return result;
    }

    public PageSerializable<PurchaseDetailVO> queryAuthExpireGoods(SearchParamVO searchParamVO, int pageNum, int pageSize, String orderBy) {
        List purchaseDetailVOS = this.purchaseMapper.findPurchaseDetailByPage(searchParamVO, orderBy);
        this.getTenantSidFromIam(purchaseDetailVOS);
        List purchaseIds = purchaseDetailVOS.stream().map(PurchaseDetailVO::getId).collect(Collectors.toList());
        if (!purchaseIds.isEmpty() && searchParamVO != null) {
            if (searchParamVO.getShowUserCount().booleanValue()) {
                ArrayList userInfoList = new ArrayList();
                List userInCountings = this.purchaseCountMapper.findPurchaseUserCountInPurchaseIds(purchaseIds);
                HashMap userCountInfoVOSMap = new HashMap();
                for (UserInCounting u : userInCountings) {
                    List userInCounting = (List)userCountInfoVOSMap.get(u.getPurchaseId());
                    if (userInCounting != null) {
                        userInCounting.add(u);
                        continue;
                    }
                    LinkedList<UserInCounting> linkedList = new LinkedList<UserInCounting>();
                    linkedList.add(u);
                    userCountInfoVOSMap.put(u.getPurchaseId(), linkedList);
                }
                purchaseDetailVOS.forEach(p -> {
                    UserInTenantVO userInfoMap = new UserInTenantVO();
                    ArrayList<String> userIds = new ArrayList<String>();
                    List userInCounting = (List)userCountInfoVOSMap.get(p.getId());
                    if (!CollectionUtils.isEmpty((Collection)userInCounting)) {
                        for (UserInCounting uic : userInCounting) {
                            PurchaseUserCountInfoVO purchaseUserCountInfoVO = new PurchaseUserCountInfoVO();
                            purchaseUserCountInfoVO.setUserId(uic.getUserId());
                            p.getUsers().add(purchaseUserCountInfoVO);
                            userIds.add(uic.getUserId());
                        }
                    }
                    userInfoMap.setTenantId(p.getTenantId());
                    userInfoMap.setUserIds(userIds);
                    userInfoList.add(userInfoMap);
                });
                return this.getPurchaseDetailVOSResult(pageNum, pageSize, userInfoList, searchParamVO.getTest(), searchParamVO.getShowUserCount(), purchaseDetailVOS);
            }
            HashSet userInfoSet = new HashSet();
            purchaseDetailVOS.forEach(p -> {
                UserInTenantVO4Compare userInfoMap = new UserInTenantVO4Compare(this);
                userInfoMap.setTenantId(p.getTenantId());
                userInfoSet.add(userInfoMap);
            });
            ArrayList userInfoList = new ArrayList();
            userInfoList.addAll(userInfoSet);
            return this.getPurchaseDetailVOSResult(pageNum, pageSize, userInfoList, searchParamVO.getTest(), searchParamVO.getShowUserCount(), purchaseDetailVOS);
        }
        return new PageSerializable();
    }

    private void getTenantSidFromIam(List<PurchaseDetailVO> purchaseDetailVOS) {
        Map tenantSidMap = this.iamService.getTenantSid(purchaseDetailVOS.stream().map(PurchaseDetailVO::getTenantId).collect(Collectors.toList()));
        purchaseDetailVOS.forEach(a -> a.setTenantSid((Long)tenantSidMap.get(a.getTenantId())));
    }

    private PageSerializable<PurchaseDetailVO> getPurchaseDetailVOSResult(int pageNum, int pageSize, List<UserInTenantVO> userInfoList, Boolean testTenant, Boolean showUserCount, List<PurchaseDetailVO> purchaseDetailVOS) {
        PageSerializable purchaseDetailVOSResult = null;
        List userCountInfoVOS = this.iamService.getUserDetails(userInfoList, UserUtils.getToken());
        int pageStartIndex = (pageNum - 1) * pageSize;
        if (userCountInfoVOS != null) {
            purchaseDetailVOSResult = this.getPurchaseDetailVOS(testTenant, showUserCount, pageSize, purchaseDetailVOS, userCountInfoVOS, pageStartIndex);
        }
        return purchaseDetailVOSResult == null ? new PageSerializable() : purchaseDetailVOSResult;
    }

    private PageSerializable<PurchaseDetailVO> getPurchaseDetailVOS(Boolean testTenant, Boolean showUserCount, int pageSize, List<PurchaseDetailVO> purchaseDetailVOS, List<PurchaseUserCountInfoVO> userCountInfoVOS, int pageStartIndex) {
        List purchaseDetailVOSList = purchaseDetailVOS.stream().map(PurchaseDetailVO::getTenantId).collect(Collectors.toList());
        Map<String, PurchaseUserCountInfoVO> userCountInfoVOSMap = userCountInfoVOS.stream().collect(Collectors.toMap(PurchaseUserCountInfoVO::getTenantId, v -> v, (k1, k2) -> k1));
        Set<String> userCountInfoVOSMapKeySet = userCountInfoVOSMap.keySet();
        HashSet<Object> tenantIdSet = new HashSet<Object>();
        tenantIdSet.addAll(purchaseDetailVOSList);
        tenantIdSet.addAll(userCountInfoVOSMapKeySet);
        Map<String, PurchaseUserCountInfoVO> userCountInfoVOSUserIdMap = userCountInfoVOS.stream().collect(Collectors.toMap(PurchaseUserCountInfoVO::getUserId, v -> v, (k1, k2) -> k2));
        List purchaseDetailVOSResult = purchaseDetailVOS.stream().filter(o -> {
            PurchaseUserCountInfoVO userCountInfoVO;
            if (tenantIdSet.contains(o.getTenantId()) && (userCountInfoVO = (PurchaseUserCountInfoVO)userCountInfoVOSMap.get(o.getTenantId())) != null && (testTenant == null || testTenant.equals(userCountInfoVO.getTestTenant()))) {
                o.setTestTenant(userCountInfoVO.getTestTenant());
                if (showUserCount != null && showUserCount.booleanValue()) {
                    o.getUsers().forEach(pu -> {
                        PurchaseUserCountInfoVO purchaseUserCountInfoVO = (PurchaseUserCountInfoVO)userCountInfoVOSUserIdMap.get(pu.getUserId());
                        if (purchaseUserCountInfoVO != null) {
                            pu.generate(purchaseUserCountInfoVO);
                        }
                    });
                }
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        int total = purchaseDetailVOSResult.size();
        purchaseDetailVOSResult = purchaseDetailVOSResult.stream().skip(pageStartIndex).limit(pageSize).collect(Collectors.toList());
        PageSerializable pageSerializable = new PageSerializable(purchaseDetailVOSResult);
        pageSerializable.setTotal((long)total);
        return pageSerializable;
    }

    public void copyAppAuthToChildTenants(CopyAppAuthVO copyAppAuthVO) {
        List purchaseList = this.queryCloudPurchaseList(copyAppAuthVO.getSourceTenantId(), copyAppAuthVO.getAppIds());
        purchaseList.forEach(cloudPurchaseDTO -> copyAppAuthVO.getCustomers().forEach(customerVO -> {
            cloudPurchaseDTO.setSourceId(copyAppAuthVO.getSourceId());
            cloudPurchaseDTO.setSourceCode(copyAppAuthVO.getSourceCode());
            cloudPurchaseDTO.setEffectiveDateTime(LocalDateTime.now());
            if (!this.customerCrudService.existsById(customerVO.getId())) {
                this.customerCrudService.create((BaseEntity)new Customer(customerVO.getId(), customerVO.getName()));
                this.addPurchaseInfo(cloudPurchaseDTO, copyAppAuthVO, customerVO.getId());
            } else {
                CloudPurchaseDTO purchaseDTO = this.authorizeQueryService.getCloudPurchase(customerVO.getId(), cloudPurchaseDTO.getProductCode());
                if (purchaseDTO == null) {
                    this.addPurchaseInfo(cloudPurchaseDTO, copyAppAuthVO, customerVO.getId());
                } else if (copyAppAuthVO.getType() == 0) {
                    boolean expireDate = cloudPurchaseDTO.getExpiredDateTime().isBefore(purchaseDTO.getExpiredDateTime());
                    if (expireDate) {
                        logger.warn(String.format("\u79df\u6237%s\u5df2\u6709%s\u5e94\u7528\u7684\u6388\u6743\u4fe1\u606f\uff0c\u4e14\u6388\u6743\u4fe1\u606f\u5927\u4e8e\u6307\u5b9a\u6388\u6743\uff0c\u4e0d\u8986\u76d6\u6388\u6743", purchaseDTO.getCustomerId(), purchaseDTO.getProductCode()));
                        return;
                    }
                    cloudPurchaseDTO.setPurchaseId(purchaseDTO.getPurchaseId());
                    cloudPurchaseDTO.setCustomerId(purchaseDTO.getCustomerId());
                    if (cloudPurchaseDTO.getTotalCount() > 0) {
                        cloudPurchaseDTO.setUserCount(purchaseDTO.getUserCount());
                    }
                    if (cloudPurchaseDTO.getTotalUsage() > 0) {
                        cloudPurchaseDTO.setRemainingUsage(cloudPurchaseDTO.getTotalUsage() - purchaseDTO.getTotalUsage() + cloudPurchaseDTO.getRemainingUsage());
                    }
                    this.authorizeRegistrarService.update(cloudPurchaseDTO);
                } else {
                    PurchaseDetailVO authAppInfo = copyAppAuthVO.getAuthorizations().stream().filter(g -> g.getId().equals(cloudPurchaseDTO.getProductCode())).findFirst().orElse(null);
                    if (authAppInfo == null) {
                        throw new BusinessException((ErrorHandler)I18nError.ERROR_10023, new Object[]{cloudPurchaseDTO.getProductCode()});
                    }
                    boolean expireDate = authAppInfo.getExpiredTime().isBefore(purchaseDTO.getExpiredDateTime());
                    if (expireDate) {
                        logger.warn(String.format("\u79df\u6237%s\u5df2\u6709%s\u5e94\u7528\u7684\u6388\u6743\u4fe1\u606f\uff0c\u4e14\u6388\u6743\u4fe1\u606f\u5927\u4e8e\u6307\u5b9a\u6388\u6743\uff0c\u4e0d\u8986\u76d6\u6388\u6743", purchaseDTO.getCustomerId(), purchaseDTO.getProductCode()));
                        return;
                    }
                    purchaseDTO.setExpiredDateTime(authAppInfo.getExpiredTime());
                    purchaseDTO.setStrategyId(authAppInfo.getStrategySid().toString());
                    if (purchaseDTO.getTotalCount() > 0) {
                        purchaseDTO.setTotalCount(authAppInfo.getTotalUsage().intValue());
                    }
                    if (purchaseDTO.getTotalUsage() > 0) {
                        purchaseDTO.setRemainingUsage(authAppInfo.getTotalUsage() - purchaseDTO.getTotalUsage() + purchaseDTO.getRemainingUsage());
                        purchaseDTO.setTotalUsage(authAppInfo.getTotalUsage().intValue());
                    }
                    authAppInfo.getModules().forEach(m -> {
                        EnabledModuleDTO enabledModuleDTO = purchaseDTO.getModules().stream().filter(o -> o.getId().equals(m.getId())).findFirst().orElse(null);
                        if (enabledModuleDTO == null) {
                            m.setRemainingUsage(authAppInfo.getTotalUsage().intValue());
                            m.setEffectiveTime(LocalDateTime.now());
                            enabledModuleDTO = new EnabledModuleDTO(m);
                            cloudPurchaseDTO.getModules().add(enabledModuleDTO);
                        } else {
                            enabledModuleDTO.setExpiredTime(authAppInfo.getExpiredTime());
                            enabledModuleDTO.setRemainingUsage(purchaseDTO.getRemainingUsage());
                            enabledModuleDTO.setOldExpiredTime(enabledModuleDTO.getExpiredTime());
                        }
                    });
                    purchaseDTO.setSourceId(copyAppAuthVO.getSourceId());
                    purchaseDTO.setSourceCode(copyAppAuthVO.getSourceCode());
                    this.authorizeRegistrarService.update(purchaseDTO);
                }
            }
        }));
    }

    public void copyAuthFromSourceApp(CopyAppAuthVO copyAppAuthVO) {
        List purchaseList = this.authorizeQueryService.getCloudPurchase(copyAppAuthVO.getTenantIds(), Collections.singletonList(copyAppAuthVO.getSourceAppId()));
        List existedPurchaseList = this.authorizeQueryService.getCloudPurchase(copyAppAuthVO.getTenantIds(), Collections.singletonList(copyAppAuthVO.getAppId()));
        PurchaseDetailVO purchaseDetailVO = (PurchaseDetailVO)copyAppAuthVO.getAuthorizations().get(0);
        purchaseList.forEach(cloudPurchaseDTO -> {
            CloudPurchaseDTO existedCloudPurchaseDTO = existedPurchaseList.stream().filter(c -> c.getCustomerId().equals(cloudPurchaseDTO.getCustomerId())).findFirst().orElse(null);
            if (null == existedCloudPurchaseDTO) {
                cloudPurchaseDTO.setInitialize(Integer.valueOf(0));
                cloudPurchaseDTO.setPurchaseId(UUID.randomUUID().toString());
                cloudPurchaseDTO.setProductId(purchaseDetailVO.getProductSid());
                cloudPurchaseDTO.setProductCode(copyAppAuthVO.getAppId());
                cloudPurchaseDTO.setProductName(purchaseDetailVO.getName());
                cloudPurchaseDTO.setPaymentType(purchaseDetailVO.getPaymentType());
                cloudPurchaseDTO.setCustomUnit(purchaseDetailVO.getCustomUnit());
                cloudPurchaseDTO.setStrategyId(copyAppAuthVO.getStrategyCode());
                if (cloudPurchaseDTO.getTotalCount() > 0) {
                    cloudPurchaseDTO.setTotalCount(copyAppAuthVO.getUserNumber().intValue());
                    cloudPurchaseDTO.setUserCount(0);
                }
                if (cloudPurchaseDTO.getTotalUsage() > 0) {
                    cloudPurchaseDTO.setTotalUsage(copyAppAuthVO.getUserNumber().intValue());
                    cloudPurchaseDTO.setRemainingUsage(cloudPurchaseDTO.getTotalUsage());
                }
                if (purchaseDetailVO.getEffectiveTime() != null) {
                    cloudPurchaseDTO.setEffectiveDateTime(purchaseDetailVO.getEffectiveTime());
                }
                if (purchaseDetailVO.getExpiredTime() != null) {
                    cloudPurchaseDTO.setExpiredDateTime(purchaseDetailVO.getExpiredTime());
                }
                ArrayList modules = new ArrayList();
                purchaseDetailVO.getModules().forEach(m -> {
                    m.setRemainingUsage(cloudPurchaseDTO.getRemainingUsage());
                    m.setEffectiveTime(cloudPurchaseDTO.getEffectiveDateTime());
                    m.setExpiredTime(cloudPurchaseDTO.getExpiredDateTime());
                    m.setTotalUsage(cloudPurchaseDTO.getTotalUsage());
                    EnabledModuleDTO enabledModuleDTO = new EnabledModuleDTO(m);
                    modules.add(enabledModuleDTO);
                });
                cloudPurchaseDTO.setModules(modules);
                this.authorizeRegistrarService.insert(cloudPurchaseDTO);
            } else {
                boolean totalUsage;
                boolean expireDate = cloudPurchaseDTO.getExpiredDateTime().isBefore(existedCloudPurchaseDTO.getExpiredDateTime());
                boolean totalCount = cloudPurchaseDTO.getTotalUsage() < copyAppAuthVO.getUserNumber();
                boolean bl = totalUsage = cloudPurchaseDTO.getTotalUsage() < copyAppAuthVO.getUserNumber();
                if (expireDate || totalCount || totalUsage) {
                    logger.warn(String.format("\u79df\u6237%s\u5df2\u6709%s\u5e94\u7528\u7684\u6388\u6743\u4fe1\u606f\uff0c\u4e14\u6388\u6743\u4fe1\u606f\u5927\u4e8e\u6307\u5b9a\u6388\u6743\uff0c\u4e0d\u8986\u76d6\u6388\u6743", existedCloudPurchaseDTO.getCustomerId(), existedCloudPurchaseDTO.getProductCode()));
                    return;
                }
                existedCloudPurchaseDTO.setExpiredDateTime(cloudPurchaseDTO.getExpiredDateTime());
                if (existedCloudPurchaseDTO.getTotalCount() > 0) {
                    existedCloudPurchaseDTO.setTotalCount(copyAppAuthVO.getUserNumber().intValue());
                }
                if (existedCloudPurchaseDTO.getTotalUsage() > 0) {
                    existedCloudPurchaseDTO.setRemainingUsage(copyAppAuthVO.getUserNumber() - existedCloudPurchaseDTO.getTotalUsage() + existedCloudPurchaseDTO.getRemainingUsage());
                    existedCloudPurchaseDTO.setTotalUsage(copyAppAuthVO.getUserNumber().intValue());
                }
                if (purchaseDetailVO.getEffectiveTime() != null) {
                    existedCloudPurchaseDTO.setEffectiveDateTime(purchaseDetailVO.getEffectiveTime());
                }
                if (purchaseDetailVO.getExpiredTime() != null && purchaseDetailVO.getExpiredTime().isAfter(existedCloudPurchaseDTO.getExpiredDateTime())) {
                    existedCloudPurchaseDTO.setExpiredDateTime(purchaseDetailVO.getExpiredTime());
                }
                this.authorizeRegistrarService.update(existedCloudPurchaseDTO);
            }
        });
    }

    private void addPurchaseInfo(CloudPurchaseDTO cloudPurchaseDTO, CopyAppAuthVO copyAppAuthVO, String customerId) {
        cloudPurchaseDTO.setPurchaseId(UUID.randomUUID().toString());
        cloudPurchaseDTO.setCustomerId(customerId);
        cloudPurchaseDTO.setInitialize(Integer.valueOf(0));
        if (copyAppAuthVO.getType() == 0) {
            if (!CollectionUtils.isEmpty((Collection)cloudPurchaseDTO.getModules())) {
                cloudPurchaseDTO.getModules().stream().forEach(o -> o.setEffectiveTime(LocalDateTime.now()));
            }
            if (cloudPurchaseDTO.getTotalCount() > 0) {
                cloudPurchaseDTO.setUserCount(0);
            }
            if (cloudPurchaseDTO.getTotalUsage() > 0) {
                cloudPurchaseDTO.setRemainingUsage(cloudPurchaseDTO.getTotalUsage());
            }
        } else {
            PurchaseDetailVO authAppInfo = copyAppAuthVO.getAuthorizations().stream().filter(g -> g.getId().equals(cloudPurchaseDTO.getProductCode())).findFirst().orElse(null);
            if (authAppInfo == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10023, new Object[]{cloudPurchaseDTO.getProductCode()});
            }
            if (cloudPurchaseDTO.getTotalCount() > 0) {
                cloudPurchaseDTO.setTotalCount(authAppInfo.getTotalUsage().intValue());
                cloudPurchaseDTO.setUserCount(0);
            }
            if (cloudPurchaseDTO.getTotalUsage() > 0) {
                cloudPurchaseDTO.setTotalUsage(authAppInfo.getTotalUsage().intValue());
                cloudPurchaseDTO.setRemainingUsage(authAppInfo.getTotalUsage().intValue());
            }
            cloudPurchaseDTO.setExpiredDateTime(authAppInfo.getExpiredTime());
            cloudPurchaseDTO.setStrategyId(authAppInfo.getStrategySid().toString());
            cloudPurchaseDTO.getModules().clear();
            authAppInfo.getModules().forEach(m -> {
                m.setRemainingUsage(m.getTotalUsage());
                m.setEffectiveTime(LocalDateTime.now());
                EnabledModuleDTO enabledModuleDTO = new EnabledModuleDTO(m);
                cloudPurchaseDTO.getModules().add(enabledModuleDTO);
            });
        }
        this.authorizeRegistrarService.insert(cloudPurchaseDTO);
    }

    public List<AuthCompareResultVO> getCompareResult(CopyAppAuthVO copyAppAuthVO) {
        List purchaseList = this.queryCloudPurchaseList(copyAppAuthVO.getSourceTenantId(), copyAppAuthVO.getAppIds());
        ArrayList<AuthCompareResultVO> authCompareResultVOS = new ArrayList<AuthCompareResultVO>();
        purchaseList.forEach(cloudPurchaseDTO -> {
            for (CopyAppAuthVO.CustomerVO customerVO : copyAppAuthVO.getCustomers()) {
                CloudPurchaseDTO purchaseDTO = this.authorizeQueryService.getCloudPurchase(customerVO.getId(), cloudPurchaseDTO.getProductCode());
                if (purchaseDTO == null) continue;
                boolean expireDate = cloudPurchaseDTO.getExpiredDateTime().isBefore(purchaseDTO.getExpiredDateTime());
                boolean totalCount = cloudPurchaseDTO.getTotalCount() < purchaseDTO.getTotalCount();
                boolean totalUsage = cloudPurchaseDTO.getTotalUsage() < purchaseDTO.getTotalUsage();
                AuthCompareResultVO authCompareResultVO = new AuthCompareResultVO();
                authCompareResultVO.setSourceTenantId(copyAppAuthVO.getSourceTenantId());
                authCompareResultVO.setSourceTenantName(copyAppAuthVO.getSourceTenantName());
                authCompareResultVO.setTenantId(customerVO.getId());
                authCompareResultVO.setTenantName(customerVO.getName());
                authCompareResultVO.setAppId(cloudPurchaseDTO.getProductCode());
                authCompareResultVO.setAppName(cloudPurchaseDTO.getProductName());
                if (expireDate) {
                    authCompareResultVO.setExpiredDateTime(purchaseDTO.getExpiredDateTime());
                    authCompareResultVO.setSourceExpiredDateTime(cloudPurchaseDTO.getExpiredDateTime());
                }
                if (totalCount) {
                    authCompareResultVO.setTotalCount(Integer.valueOf(purchaseDTO.getTotalCount()));
                    authCompareResultVO.setSourceTotalCount(Integer.valueOf(cloudPurchaseDTO.getTotalCount()));
                }
                if (totalUsage) {
                    authCompareResultVO.setTotalUsage(Integer.valueOf(purchaseDTO.getTotalUsage()));
                    authCompareResultVO.setSourceTotalUsage(Integer.valueOf(cloudPurchaseDTO.getTotalUsage()));
                }
                if (!expireDate && !totalCount && !totalUsage) continue;
                authCompareResultVOS.add(authCompareResultVO);
            }
        });
        return authCompareResultVOS;
    }

    public AuthorizationCheckedVO checkUserCanUsePlatformProduct(String customerId, String productCode, String userId, List<String> apps, List<String> tenants, Boolean checkUserAuth) {
        if (!tenants.isEmpty()) {
            apps.add(productCode);
            List purchaseDetailVOS = this.purchaseCountMapper.findPurchaseByApps(apps);
            purchaseDetailVOS = purchaseDetailVOS.stream().filter(o -> tenants.contains(o.getCustomerId())).collect(Collectors.toList());
            return this.checkAuthCore(customerId, userId, purchaseDetailVOS, checkUserAuth);
        }
        if (apps.isEmpty()) {
            return this.checkUserCanUseProduct(customerId, productCode, userId, checkUserAuth);
        }
        apps.add(productCode);
        List purchaseApps = this.purchaseCountMapper.findAllPurchaseByUser(customerId, apps);
        return this.checkAuthCore(customerId, userId, purchaseApps, checkUserAuth);
    }

    private AuthorizationCheckedVO checkAuthCore(String customerId, String userId, List<CloudPurchaseDTO> purchaseApps, Boolean checkUserAuth) {
        Optional<CloudPurchaseDTO> optional;
        if (purchaseApps.isEmpty()) {
            return new AuthorizationCheckedVO(NoAuthType.noPurchase.name());
        }
        List tenantIds = purchaseApps.stream().map(CloudPurchaseDTO::getCustomerId).collect(Collectors.toList());
        if ((purchaseApps = purchaseApps.stream().filter(p -> this.paymentTypeContext.checkAuthorizationValid(p)).collect(Collectors.toList())).isEmpty()) {
            boolean match = tenantIds.stream().anyMatch(t -> t.equals(customerId));
            return new AuthorizationCheckedVO(NoAuthType.expired.name(), match ? customerId : (String)tenantIds.get(0));
        }
        if (checkUserAuth.booleanValue()) {
            tenantIds = purchaseApps.stream().map(CloudPurchaseDTO::getCustomerId).collect(Collectors.toList());
            if ((purchaseApps = this.purchaseCountMapper.findUserAuthByUser(userId, purchaseApps.stream().map(CloudPurchaseDTO::getPurchaseId).collect(Collectors.toList()))).isEmpty()) {
                boolean match = tenantIds.stream().anyMatch(t -> t.equals(customerId));
                return new AuthorizationCheckedVO(NoAuthType.noAuthorization.name(), match ? customerId : (String)tenantIds.get(0));
            }
        }
        CloudPurchaseDTO purchase = (optional = purchaseApps.stream().filter(p -> p.getCustomerId().equals(customerId)).findFirst()).isPresent() ? optional.get() : (CloudPurchaseDTO)purchaseApps.get(0);
        List matchTenantIds = purchaseApps.stream().map(CloudPurchaseDTO::getCustomerId).distinct().collect(Collectors.toList());
        return new AuthorizationCheckedVO(true, purchase.getExpiredDateTime(), purchase.getCustomerId(), matchTenantIds);
    }

    public void copyTenantAuth(String sourceId, String sourceTenantId, String tenantId, String tenantName) {
        List authVOS = this.purchaseMapper.findTenantCascadeAuthInfo(sourceTenantId);
        if (!authVOS.isEmpty()) {
            Customer customer = new Customer();
            customer.setName(tenantName);
            customer.setId(tenantId);
            customer.setCreateUserId(UserUtils.getUserId());
            customer.setCreateDateTime(LocalDateTime.now());
            this.customerCrudService.create((BaseEntity)customer);
            ArrayList purchases = new ArrayList();
            ArrayList purchaseCounts = new ArrayList();
            ArrayList purchaseModules = new ArrayList();
            ArrayList userInCountings = new ArrayList();
            authVOS.forEach(a -> {
                GoodsStrategy orderStrategy = null;
                LocalDateTime expiredTime = null;
                Purchase purchase = new Purchase();
                BeanUtils.copyProperties((Object)a, (Object)purchase);
                purchase.setId(UUID.randomUUID().toString());
                purchase.setSid(SnowFlake.getInstance().newId());
                purchase.setCustomerId(tenantId);
                purchase.setCreateDateTime(LocalDateTime.now());
                purchase.setCreateUserId(UserUtils.getUserId());
                purchase.setEffectiveDateTime(LocalDateTime.now());
                purchase.setInitialize(Integer.valueOf(0));
                if (com.digiwin.dap.middleware.util.StringUtils.isNotEmpty((String)purchase.getStrategyId())) {
                    orderStrategy = this.gmcService.getSellingStrategy(purchase.getProductCode(), purchase.getStrategyId());
                }
                if (null != orderStrategy && null != orderStrategy.getTenancyPeriod()) {
                    expiredTime = LocalDateTime.now().plusMonths(orderStrategy.getTenancyPeriod().intValue()).with(LocalTime.MAX).withNano(0);
                }
                if (null != expiredTime && expiredTime.isAfter(a.getExpiredDateTime())) {
                    purchase.setExpiredDateTime(expiredTime);
                }
                this.purchaseCrudService.generateHash((BaseEntity)purchase);
                purchases.add(purchase);
                PurchaseCount purchaseCount = new PurchaseCount();
                BeanUtils.copyProperties((Object)a.getPurchaseCount(), (Object)purchaseCount);
                purchaseCount.setPurchaseId(purchase.getId());
                purchaseCount.setSid(SnowFlake.getInstance().newId());
                this.purchaseCountCrudService.generateHash((BaseEntity)purchaseCount);
                purchaseCounts.add(purchaseCount);
                LocalDateTime finalExpiredTime = expiredTime;
                a.getPurchaseModules().forEach(m -> {
                    PurchaseModule purchaseModule = new PurchaseModule();
                    BeanUtils.copyProperties((Object)m, (Object)purchaseModule);
                    purchaseModule.setPurchaseId(purchase.getId());
                    purchaseModule.setSid(SnowFlake.getInstance().newId());
                    purchaseModule.setEffectiveDateTime(LocalDateTime.now());
                    if (null != finalExpiredTime && finalExpiredTime.isAfter(m.getExpiredDateTime())) {
                        purchaseModule.setExpiredDateTime(finalExpiredTime);
                    }
                    this.purchaseModuleCrudService.generateHash((BaseEntity)purchaseModule);
                    purchaseModules.add(purchaseModule);
                });
                a.getUserInCountings().forEach(u -> {
                    UserInCounting userInCounting = new UserInCounting();
                    BeanUtils.copyProperties((Object)u, (Object)userInCounting);
                    userInCounting.setSid(SnowFlake.getInstance().newId());
                    userInCounting.setPurchaseId(purchase.getId());
                    String sourceTenantPrefix = String.format("%s$", sourceTenantId);
                    String tenantPrefix = String.format("%s$", tenantId);
                    if (u.getUserId().startsWith(sourceTenantPrefix)) {
                        userInCounting.setUserId(u.getUserId().replace(sourceTenantPrefix, tenantPrefix));
                    }
                    this.userInCountingCrudService.generateHash((BaseEntity)userInCounting);
                    userInCountings.add(userInCounting);
                });
            });
            this.purchaseCrudService.insertAll(purchases);
            this.purchaseCountCrudService.insertAll(purchaseCounts);
            this.purchaseModuleCrudService.insertAll(purchaseModules);
            this.userInCountingCrudService.insertAll(userInCountings);
            this.recordService.addRecord(Operate.Insert, sourceId, customer, purchases, purchaseCounts, purchaseModules);
        }
    }

    public List<Map> checkAuthResult(String productCode, String userId, List<String> tenants) {
        List tenantAuthVOS = this.purchaseMapper.findByProductCodeInTenants(tenants, productCode);
        ArrayList<Map> results = new ArrayList<Map>();
        tenants.forEach(t -> {
            HashMap<String, Object> tenantAuthMap = new HashMap<String, Object>();
            tenantAuthMap.put("id", t);
            tenantAuthVOS.forEach(a -> {
                if (t.equals(a.getTenantId())) {
                    UserInCounting user;
                    if (LocalDateTime.now().isBefore(a.getExpiredDateTime()) && LocalDateTime.now().isAfter(a.getEffectiveDateTime())) {
                        tenantAuthMap.put("isTenantAuth", true);
                    }
                    if (a.getUserInCountings().size() > 0 && null != (user = (UserInCounting)a.getUserInCountings().stream().filter(u -> userId.equals(u.getUserId())).findFirst().orElse(null))) {
                        tenantAuthMap.put("isUserAuth", true);
                    }
                }
            });
            if (!tenantAuthMap.containsKey("isTenantAuth")) {
                tenantAuthMap.put("isTenantAuth", false);
            }
            if (!tenantAuthMap.containsKey("isUserAuth")) {
                tenantAuthMap.put("isUserAuth", false);
            }
            results.add(tenantAuthMap);
        });
        return results;
    }

    private void checkAuth(EditParamVO body, AuthorizationVO originAuthVO) {
        if (originAuthVO == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10017, new Object[]{body.getTenantId(), body.getProductCode()});
        }
        if (!ProductType.app.name().equalsIgnoreCase(originAuthVO.getCategoryId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10025, new Object[]{body.getProductCode()});
        }
        if (Boolean.TRUE.equals(originAuthVO.getBufferPeriod())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10026, new Object[]{body.getTenantId(), body.getProductCode()});
        }
    }

    private void appAuthChangeLogs(AuthorizationVO originAuthVO) {
        AuthorizationVO modifyAuthVO = this.authorizeQueryService.getAuthorization(originAuthVO.getPurchaseId());
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        SaveCompareOpLog dto = new SaveCompareOpLog();
        dto.setAppId("digiwincloud");
        dto.setModuleId("default");
        dto.setActId("default");
        dto.setSource("CAC");
        dto.setActionId("tenant.app.update");
        dto.setTableName("purchase");
        if (authoredUser != null) {
            dto.setEditUserId(authoredUser.getUserId());
            dto.setEditUserName(authoredUser.getUserName());
        }
        dto.setRemark(I18nCode.EXPIRATION_SYSTEM_BUFFER_EXTENSION.getMessage());
        dto.setOperationType(BusinessTypeEnum.UPDATE.getDescribe());
        ArrayList logFieldList = new ArrayList();
        String fieldName = "fieldName";
        String displayName = "displayName";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(fieldName, "remainingUsage");
        map.put(displayName, "\u5269\u4f59\u6b21\u6570");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "totalUsage");
        map.put(displayName, "\u603b\u4f7f\u7528\u6570\u91cf");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "expiredTime");
        map.put(displayName, "\u5230\u671f\u65f6\u95f4");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "effectiveTime");
        map.put(displayName, "\u6388\u6743\u5f00\u901a\u65e5");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "bufferPeriod");
        map.put(displayName, "\u6388\u6743\u7f13\u51b2\u671f");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "enabledModules");
        map.put(displayName, "\u53d8\u66f4\u6a21\u7ec4");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "enabledModules.expiredTime");
        map.put(displayName, "\u6388\u6743\u5230\u671f\u65f6\u95f4");
        logFieldList.add(map);
        dto.setLogFieldList(logFieldList);
        ArrayList<HashMap<String, String>> primaryKeyList = new ArrayList<HashMap<String, String>>();
        map = new HashMap();
        map.put("path", "");
        map.put("keyName", "purchaseId");
        primaryKeyList.add(map);
        map = new HashMap();
        map.put("path", "enabledModules");
        map.put("keyName", "id");
        map.put("showField", "name");
        primaryKeyList.add(map);
        dto.setPrimaryKeyList(primaryKeyList);
        if (modifyAuthVO != null) {
            dto.setPrimaryKey(modifyAuthVO.getPurchaseId());
            dto.setTenantId(modifyAuthVO.getTenantId());
            dto.setTableName(modifyAuthVO.getTenantName());
            dto.setModifyJson((Map)OBJECT_MAPPER.convertValue((Object)modifyAuthVO, Map.class));
            dto.setOriginJson((Map)OBJECT_MAPPER.convertValue((Object)originAuthVO, Map.class));
            this.lmcService.saveCompareOpLog(dto, UserUtils.getToken(), dto.getTenantId());
        }
    }

    public ObsoleteCheckResult obsoleteAuthorization(List<ObsoleteTenantAuthInfo> obsoleteAuthInfos) {
        List tenantIds = obsoleteAuthInfos.stream().map(ObsoleteTenantAuthInfo::getTenantId).collect(Collectors.toList());
        List goodsCodes = obsoleteAuthInfos.stream().map(ObsoleteTenantAuthInfo::getGoodsCode).collect(Collectors.toList());
        ObsoleteCheckResult result = new ObsoleteCheckResult();
        if (!CollectionUtils.isEmpty(tenantIds) && !CollectionUtils.isEmpty(goodsCodes)) {
            List purchaseList = this.authorizeQueryService.getCloudPurchase(tenantIds, goodsCodes);
            ArrayList<CloudPurchaseDTO> finalPurchaseList = new ArrayList<CloudPurchaseDTO>();
            for (CloudPurchaseDTO p2 : purchaseList) {
                ObsoleteTenantAuthInfo matchAuthInfo = obsoleteAuthInfos.stream().filter(o -> p2.getCustomerId().equals(o.getTenantId()) && p2.getProductCode().equals(o.getGoodsCode())).findFirst().orElse(null);
                if (matchAuthInfo == null) continue;
                p2.setSourceId(matchAuthInfo.getSourceId());
                p2.setMemo(matchAuthInfo.getRemark());
                p2.setInitialize(Integer.valueOf(0));
                if (matchAuthInfo.getOldExpiredDateTime() != null && matchAuthInfo.getOldTotalUsageBound() != null) {
                    if (!matchAuthInfo.getPlatform().booleanValue()) {
                        if (this.paymentTypeContext.checkObsoleteAuthEnable(p2, matchAuthInfo).booleanValue()) {
                            String errorMsg = String.format("\u79df\u6237\u4e0b%s\u5e94\u7528%s\u6388\u6743\u4fe1\u606f\u4e0e\u51fa\u8d27\u65e7\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u4f5c\u5e9f\u6388\u6743", matchAuthInfo.getTenantId(), matchAuthInfo.getGoodsCode());
                            logger.error(errorMsg);
                            result.setSuccess(Boolean.valueOf(false));
                            result.setMessage(this.buildErrorMsg(result.getMessage(), matchAuthInfo.getGoodsCode()));
                            continue;
                        }
                        p2.setEffectiveDateTime(matchAuthInfo.getOldEffectiveDateTime());
                        p2.setExpiredDateTime(matchAuthInfo.getOldExpiredDateTime());
                        p2.getModules().forEach(m -> {
                            m.setOldExpiredTime(m.getExpiredTime());
                            m.setExpiredTime(p2.getExpiredDateTime());
                        });
                        if (p2.getTotalCount() > 0) {
                            p2.setTotalCount(matchAuthInfo.getOldTotalUsageBound().intValue());
                        } else if (p2.getTotalUsage() > 0) {
                            p2.setTotalUsage(matchAuthInfo.getOldTotalUsageBound().intValue());
                        }
                        finalPurchaseList.add(p2);
                        continue;
                    }
                    if (this.paymentTypeContext.checkObsoleteAuthEnable(p2, matchAuthInfo).booleanValue()) continue;
                    p2.setExpiredDateTime(matchAuthInfo.getOldExpiredDateTime());
                    finalPurchaseList.add(p2);
                    continue;
                }
                if (!matchAuthInfo.getPlatform().booleanValue()) {
                    if (this.paymentTypeContext.checkObsoleteAuthEnable(p2, matchAuthInfo).booleanValue()) {
                        logger.error(String.format("\u79df\u6237%s\u4e0b\u5e94\u7528%s\u7684\u6388\u6743\u4e0e\u5f53\u524d\u4f5c\u5e9f\u6388\u6743\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u4f5c\u5e9f\uff0c\u8bf7\u786e\u8ba4\uff01", p2.getCustomerId(), p2.getProductCode()));
                        result.setSuccess(Boolean.valueOf(false));
                        result.setMessage(this.buildErrorMsg(result.getMessage(), matchAuthInfo.getGoodsCode()));
                        continue;
                    }
                    p2.setExpiredDateTime(LocalDateTime.now());
                    p2.getModules().forEach(m -> {
                        m.setOldExpiredTime(m.getExpiredTime());
                        m.setExpiredTime(LocalDateTime.now());
                    });
                    finalPurchaseList.add(p2);
                    continue;
                }
                if (this.paymentTypeContext.checkObsoleteAuthEnable(p2, matchAuthInfo).booleanValue()) continue;
                p2.setExpiredDateTime(LocalDateTime.now());
                p2.getModules().forEach(m -> {
                    m.setOldExpiredTime(m.getExpiredTime());
                    m.setExpiredTime(LocalDateTime.now());
                });
                finalPurchaseList.add(p2);
            }
            if (result.getSuccess().booleanValue()) {
                finalPurchaseList.forEach(p -> this.authorizeRegistrarService.update(p));
            }
        }
        return result;
    }

    private String buildErrorMsg(String errorMessage, String goodsCode) {
        return com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)errorMessage) ? goodsCode : errorMessage + ";" + goodsCode;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchAddBundleChildren(TenantPurchaseParameterVO body) {
        List tenantIds = Optional.ofNullable(body.getTenantIds()).orElse(new ArrayList());
        List all = this.purchaseCrudService.findByGoodsCode(body.getAppId());
        if (Boolean.TRUE.equals(body.getAllChecked())) {
            tenantIds.addAll(all.stream().filter(a -> !Boolean.TRUE.equals(body.isExcludeExpiredTenant()) || !a.getExpiredDateTime().isBefore(LocalDateTime.now())).map(Purchase::getCustomerId).collect(Collectors.toList()));
        }
        HashMap tenantMap = this.customerRepository.findByIdIn(tenantIds).stream().collect(HashMap::new, (m, v) -> m.put(v.getId(), v), HashMap::putAll);
        HashMap purchaseMap = all.stream().collect(HashMap::new, (m, v) -> m.put(v.getCustomerId(), v), HashMap::putAll);
        List allCount = this.purchaseCountCrudService.findByPurchaseIds(all.stream().map(Purchase::getId).collect(Collectors.toList()));
        HashMap countMap = allCount.stream().collect(HashMap::new, (m, v) -> m.put(v.getPurchaseId(), v), HashMap::putAll);
        ArrayList<GoodsAuthDO> toAuth = new ArrayList<GoodsAuthDO>();
        for (AddBundleChildVO bundleChild : body.getBundleChildren()) {
            for (String tenantId : tenantIds) {
                Customer customer = (Customer)tenantMap.get(tenantId);
                Purchase purchase = (Purchase)purchaseMap.get(tenantId);
                PurchaseCount purchaseCount = (PurchaseCount)countMap.get(purchase.getId());
                GoodsAuthDO vo = new GoodsAuthDO();
                vo.setAppId(bundleChild.getAppId());
                vo.setStrategyCode(bundleChild.getStrategyCode());
                vo.setSourceId(body.getSourceId());
                vo.setTenantId(tenantId);
                vo.setTenantName(customer.getName());
                vo.setEffectiveDateTime(purchase.getEffectiveDateTime());
                vo.setExpiredDateTime(purchase.getExpiredDateTime());
                vo.setUserNumber(Integer.valueOf(purchaseCount.getTotalCountBound() > 0 ? purchaseCount.getTotalCountBound() : purchaseCount.getTotalUsageBound()));
                vo.setBundleCode(((Purchase)all.get(0)).getProductCode());
                vo.setBundleName(((Purchase)all.get(0)).getProductName());
                toAuth.add(vo);
            }
        }
        this.omcService.purchaseApp(toAuth);
    }
}

