/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middleware.cac.domain.AppAuthUserDTO;
import com.digiwin.dap.middleware.cac.domain.AppAuthUserVO;
import com.digiwin.dap.middleware.cac.domain.AppInfo;
import com.digiwin.dap.middleware.cac.domain.AuthorizationSimplifiedVO;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.CurrentStrategyVO;
import com.digiwin.dap.middleware.cac.domain.MigrateAppVO;
import com.digiwin.dap.middleware.cac.domain.QueryPageTenantVO;
import com.digiwin.dap.middleware.cac.domain.TenantVO;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.cac.domain.remote.SysVO;
import com.digiwin.dap.middleware.cac.domain.remote.TenantInfo;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.PurchaseModule;
import com.digiwin.dap.middleware.cac.mapper.CustomerMapper;
import com.digiwin.dap.middleware.cac.mapper.PurchaseCountMapper;
import com.digiwin.dap.middleware.cac.mapper.PurchaseMapper;
import com.digiwin.dap.middleware.cac.mapper.UserInCountingMapper;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseModuleCrudService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeOtherService;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AuthorizeOtherServiceImpl
implements AuthorizeOtherService {
    private Logger logger = LoggerFactory.getLogger(AuthorizeOtherServiceImpl.class);
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private PurchaseMapper purchaseMapper;
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private IamService iamService;
    @Autowired
    private PurchaseCountMapper purchaseCountMapper;
    @Autowired
    private UserInCountingMapper userInCountingMapper;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private PurchaseModuleCrudService purchaseModuleCrudService;

    public List<TenantVO> findTenants(String goodsCode, boolean excludeName) {
        List tenants = this.customerMapper.findTenants(goodsCode);
        if (excludeName) {
            tenants.forEach(tenant -> tenant.setTenantName(null));
        }
        List purchaseIds = tenants.stream().map(TenantVO::getPurchaseId).collect(Collectors.toList());
        this.purchaseCrudService.findByPurchaseIds(purchaseIds);
        return tenants;
    }

    public List<String> findGoodsCode(String tenantId, String userId) {
        List authGoods = this.findGoodsInfo(tenantId, userId);
        return authGoods.stream().map(SysVO::getId).collect(Collectors.toList());
    }

    public List<SysVO> findGoodsInfo(String tenantId, String userId) {
        List goods = this.purchaseMapper.findByTenantIdAndUserId(tenantId, userId);
        ArrayList<SysVO> sysVOS = new ArrayList<SysVO>(goods.size());
        goods.forEach(g -> {
            SysVO sysVO = new SysVO(g);
            sysVOS.add(sysVO);
        });
        return sysVOS;
    }

    public List<TenantInfo> findTenantsByIsvApps(String isvTenantId) {
        List appIds = this.gmcService.getIsvGoods(isvTenantId);
        if (CollectionUtils.isEmpty((Collection)appIds)) {
            this.logger.warn("\u670d\u52a1\u5546{}\u4e0b\u6ca1\u6709\u5f52\u5c5e\u5e94\u7528", (Object)isvTenantId);
            return Collections.emptyList();
        }
        List purchases = this.purchaseCountMapper.findPurchaseByApps(appIds);
        if (CollectionUtils.isEmpty((Collection)purchases)) {
            String appIdsStr = String.join((CharSequence)",", appIds);
            this.logger.warn("\u670d\u52a1\u5546{}\u4e0b\u7684\u5e94\u7528[{}]\u6ca1\u6709\u6388\u6743\u4fe1\u606f", (Object)isvTenantId, (Object)appIdsStr);
            return Collections.emptyList();
        }
        List tenantIds = purchases.stream().map(CloudPurchaseDTO::getCustomerId).distinct().collect(Collectors.toList());
        List tenantInfos = this.iamService.getTenantInfos(tenantIds, null, Boolean.valueOf(true));
        Map<String, List<CloudPurchaseDTO>> tenantAuthsMap = purchases.stream().collect(Collectors.groupingBy(CloudPurchaseDTO::getCustomerId));
        tenantInfos.forEach(t -> {
            List tenantAuths = (List)tenantAuthsMap.get(t.getId());
            if (!CollectionUtils.isEmpty((Collection)tenantAuths)) {
                ArrayList appInfos = new ArrayList(tenantAuths.size());
                tenantAuths.forEach(a -> {
                    AppInfo appInfo = new AppInfo(a);
                    appInfos.add(appInfo);
                });
                t.setAuths(appInfos);
            }
        });
        return tenantInfos;
    }

    public List<AppInfo> findAuthUsersInApps(String tenantId, List<String> appIds) {
        AppAuthUserDTO appAuthUserDTO = new AppAuthUserDTO();
        appAuthUserDTO.setAppIds(appIds);
        appAuthUserDTO.setTenantIds(Collections.singletonList(tenantId));
        List appAuthUserVOS = this.userInCountingMapper.getAppAuthUsers(appAuthUserDTO);
        if (!appAuthUserVOS.isEmpty()) {
            return ((AppAuthUserVO)appAuthUserVOS.get(0)).getApps();
        }
        return Collections.emptyList();
    }

    @Transactional
    public void unbundle(String purchaseId) {
        Purchase purchase = this.purchaseCrudService.findByPurchaseId(purchaseId);
        Optional.ofNullable(purchase).ifPresent(a -> {
            a.setBundleCode(null);
            a.setBundleName(null);
            this.purchaseCrudService.update((BaseEntity)a);
        });
    }

    public CurrentStrategyVO getCurrentStrategy(String appId, String tenantId) {
        CurrentStrategyVO currentStrategyVO = new CurrentStrategyVO();
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, appId);
        if (purchase == null) {
            return currentStrategyVO;
        }
        GoodsStrategy sellingStrategy = Optional.ofNullable(this.gmcService.getSellingStrategy(appId, purchase.getStrategyId())).orElse(new GoodsStrategy());
        currentStrategyVO.setProductCode(purchase.getProductCode());
        currentStrategyVO.setProductName(purchase.getProductName());
        currentStrategyVO.setStrategySid(purchase.getStrategyId());
        currentStrategyVO.setStrategyId(sellingStrategy.getCode());
        currentStrategyVO.setStrategyName(sellingStrategy.getName());
        currentStrategyVO.setEffectiveTime(purchase.getEffectiveDateTime());
        currentStrategyVO.setExpireTime(purchase.getExpiredDateTime());
        return currentStrategyVO;
    }

    public List<AuthorizationSimplifiedVO> findTenantAuth(String goodsCode) {
        List byGoodsCode = this.purchaseCrudService.findByGoodsCode(goodsCode);
        if (byGoodsCode.isEmpty()) {
            return new ArrayList<AuthorizationSimplifiedVO>();
        }
        HashMap tenantMap = this.customerMapper.findTenants(goodsCode).stream().collect(HashMap::new, (m, v) -> m.put(v.getTenantId(), v), HashMap::putAll);
        Map tenantSidMap = this.iamService.getTenantSid(byGoodsCode.stream().map(Purchase::getCustomerId).collect(Collectors.toList()));
        HashMap countMap = this.purchaseCountCrudService.findByPurchaseIds(byGoodsCode.stream().map(Purchase::getId).collect(Collectors.toList())).stream().collect(HashMap::new, (m, v) -> m.put(v.getPurchaseId(), v), HashMap::putAll);
        return byGoodsCode.stream().map(a -> new AuthorizationSimplifiedVO(a, (PurchaseCount)countMap.get(a.getId()), (TenantVO)tenantMap.get(a.getCustomerId()), (Long)tenantSidMap.get(a.getCustomerId()))).collect(Collectors.toList());
    }

    public void expireModules(MigrateAppVO vo) {
        List oldModuleIds = vo.getOldModuleIds();
        List tenantIds = vo.getTenantIds();
        String targetAppId = vo.getTargetAppId();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            tenantIds = this.purchaseCrudService.findByGoodsCode(targetAppId).stream().map(Purchase::getCustomerId).distinct().collect(Collectors.toList());
        }
        for (String tenantId : tenantIds) {
            Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, targetAppId);
            if (purchase == null) continue;
            List modules = this.purchaseModuleCrudService.findByPurchaseId(purchase.getId());
            modules.removeIf(a -> !oldModuleIds.contains(a.getModuleId()));
            for (PurchaseModule module : modules) {
                this.logger.info("\u5e94\u7528\uff1a{}\uff0c\u79df\u6237\uff1a{}\uff0c\u6a21\u7ec4\uff1a{}\u7f6e\u4e3a\u8fc7\u671f", new Object[]{targetAppId, tenantId, module.getModuleId()});
                module.setExpiredDateTime(LocalDateTime.now());
                this.purchaseModuleCrudService.generateHash((BaseEntity)module);
            }
            this.purchaseModuleCrudService.saveAll((Iterable)modules);
        }
    }

    public PageSerializable<TenantVO> findTenants(Page page, QueryPageTenantVO queryPageTenantVO) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List tenants = this.customerMapper.findTenantsByCondition(queryPageTenantVO);
        if (CollectionUtils.isEmpty((Collection)tenants)) {
            return PageSerializable.of(Collections.emptyList());
        }
        List tenantIds = tenants.stream().map(TenantVO::getTenantId).collect(Collectors.toList());
        List tenantInfos = this.iamService.getTenantInfos(tenantIds, null, null);
        if (!CollectionUtils.isEmpty((Collection)tenantInfos)) {
            Map tenantInfoMap = tenantInfos.stream().collect(Collectors.toMap(TenantInfo::getId, Function.identity(), (v1, v2) -> v1));
            for (TenantVO tenant : tenants) {
                TenantInfo tenantInfo = (TenantInfo)tenantInfoMap.get(tenant.getTenantId());
                if (!Objects.nonNull(tenantInfo)) continue;
                tenant.setTenantSid(tenantInfo.getSid());
                tenant.setCustomerId(tenantInfo.getCustomerId());
            }
        }
        return PageSerializable.of((List)tenants);
    }
}

