/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middleware.cac.domain.AuthorizationExportVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationInfoVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.BatchCodeQueryRequest;
import com.digiwin.dap.middleware.cac.domain.BatchCodeQueryResponse;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.CurrentTenantQueryDTO;
import com.digiwin.dap.middleware.cac.domain.CustomQueryCondition;
import com.digiwin.dap.middleware.cac.domain.InPackCheckResponse;
import com.digiwin.dap.middleware.cac.domain.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.cac.domain.PackRenewCheckResponse;
import com.digiwin.dap.middleware.cac.domain.PurchaseModuleVO;
import com.digiwin.dap.middleware.cac.domain.StatisticInvokeLogDTO;
import com.digiwin.dap.middleware.cac.domain.StatisticInvokeLogVO;
import com.digiwin.dap.middleware.cac.domain.TenantPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.TenantVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.DenyRenewReasonEnum;
import com.digiwin.dap.middleware.cac.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.cac.domain.enumeration.PaymentType;
import com.digiwin.dap.middleware.cac.domain.enumeration.ProductType;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsVO2;
import com.digiwin.dap.middleware.cac.domain.remote.PaymentTypeVO;
import com.digiwin.dap.middleware.cac.domain.remote.ResourceGoods;
import com.digiwin.dap.middleware.cac.domain.remote.TenantInfo;
import com.digiwin.dap.middleware.cac.entity.Customer;
import com.digiwin.dap.middleware.cac.entity.GoodsResource;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.Record;
import com.digiwin.dap.middleware.cac.mapper.InvokeLogMapper;
import com.digiwin.dap.middleware.cac.mapper.PurchaseMapper;
import com.digiwin.dap.middleware.cac.mapper.StatisticInvokeLogMapper;
import com.digiwin.dap.middleware.cac.repository.RecordRepository;
import com.digiwin.dap.middleware.cac.service.basic.CustomerCrudService;
import com.digiwin.dap.middleware.cac.service.basic.GoodsResourceCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseModuleCrudService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeQueryService;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.cac.support.remote.OmcService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class AuthorizeQueryServiceImpl
implements AuthorizeQueryService {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizeQueryServiceImpl.class);
    @Autowired
    private CustomerCrudService customerCrudService;
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private PurchaseModuleCrudService purchaseModuleCrudService;
    @Autowired
    private PurchaseMapper purchaseMapper;
    @Autowired
    private IamService iamService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private InvokeLogMapper invokeLogMapper;
    @Autowired
    private StatisticInvokeLogMapper statisticInvokeLogMapper;
    @Autowired
    private GoodsResourceCrudService goodsResourceCrudService;
    @Autowired
    private RecordRepository recordRepository;
    @Autowired
    private OmcService omcService;
    private static final Set<String> SPECIAL_PRODUCT_TYPES;

    public AuthorizationVO getAuthorization(String purchaseId) {
        Purchase purchase = this.purchaseCrudService.findByPurchaseId(purchaseId);
        return this.getAuthorization(purchase);
    }

    public AuthorizationVO getAuthorization(String tenantId, String goodsCode) {
        return this.getAuthorization(tenantId, goodsCode, Boolean.TRUE.booleanValue());
    }

    public AuthorizationVO getAuthorization(String tenantId, String goodsCode, boolean containExpiredModules) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        return this.getAuthorization(purchase, Boolean.valueOf(containExpiredModules));
    }

    public AuthorizationVO getAuthorization(Purchase purchase) {
        return this.getAuthorization(purchase, Boolean.TRUE);
    }

    public AuthorizationVO getAuthorization(Purchase purchase, Boolean containExpiredModules) {
        if (purchase == null) {
            return null;
        }
        List authorizations = this.getAuthorizations(Collections.singletonList(purchase), containExpiredModules);
        return authorizations.isEmpty() ? null : (AuthorizationVO)authorizations.get(0);
    }

    public List<AuthorizationVO> getAuthorizations(String tenantId) {
        List purchases = this.purchaseCrudService.findByTenantId(tenantId);
        return this.getAuthorizations(purchases);
    }

    public List<AuthorizationVO> getAuthorizations(String tenantId, Boolean countApiInvoke) {
        List purchases = this.purchaseCrudService.findByTenantId(tenantId);
        return this.getAuthorizations(purchases, Boolean.TRUE, countApiInvoke);
    }

    public List<AuthorizationVO> getAuthorizations(String tenantId, String userId) {
        List purchases = this.purchaseCrudService.findByTenantIdAndUserId(tenantId, userId);
        return this.getAuthorizations(purchases);
    }

    public List<AuthorizationVO> getAuthorizations(List<Purchase> purchases) {
        return this.getAuthorizations(purchases, Boolean.TRUE);
    }

    public List<AuthorizationVO> getAuthorizations(List<Purchase> purchases, Boolean containExpiredModules) {
        return this.getAuthorizations(purchases, containExpiredModules, Boolean.FALSE);
    }

    public List<AuthorizationVO> getAuthorizations(List<Purchase> purchases, Boolean containExpiredModules, Boolean countApiInvoke) {
        if (purchases == null || purchases.isEmpty()) {
            return Collections.emptyList();
        }
        List purchaseIds = purchases.stream().map(Purchase::getId).collect(Collectors.toList());
        List purchaseCodes = purchases.stream().map(Purchase::getProductCode).collect(Collectors.toList());
        List purchaseCounts = this.purchaseCountCrudService.findByPurchaseIds(purchaseIds);
        List goodsResources = this.goodsResourceCrudService.findAll();
        List purchaseModules = containExpiredModules != false ? this.purchaseModuleCrudService.findByPurchaseIds(purchaseIds) : this.purchaseModuleCrudService.findUnExpiredByPurchaseIds(purchaseIds);
        Map<Object, Object> todayInvokeCountMap = new HashMap();
        Map<Object, Object> statisticInvokeLogMap = new HashMap();
        if (Boolean.TRUE.equals(countApiInvoke)) {
            List productCodeList = purchases.stream().filter(e -> GoodsCategoryEnum.API.name().equalsIgnoreCase(e.getProductType())).map(Purchase::getProductCode).collect(Collectors.toList());
            List tenantIdList = purchases.stream().map(Purchase::getCustomerId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(productCodeList) && !CollectionUtils.isEmpty(tenantIdList)) {
                List statisticInvokeLogList;
                LocalDateTime tomorrowStartTime;
                LocalDateTime todayStartTime = LocalDate.now().atStartOfDay();
                List todayInvokeStatisticList = this.invokeLogMapper.statisticInvokeLog(productCodeList, tenantIdList, todayStartTime, tomorrowStartTime = todayStartTime.plusDays(1L));
                if (!CollectionUtils.isEmpty((Collection)todayInvokeStatisticList)) {
                    todayInvokeCountMap = todayInvokeStatisticList.stream().collect(Collectors.toMap(e -> e.getAppTenantId() + ":-" + e.getProductCode(), StatisticInvokeLogDTO::getInvokeCount, (v1, v2) -> v1));
                }
                if (!CollectionUtils.isEmpty((Collection)(statisticInvokeLogList = this.statisticInvokeLogMapper.statisticAllMonthLog(productCodeList, tenantIdList)))) {
                    statisticInvokeLogMap = statisticInvokeLogList.stream().collect(Collectors.toMap(e -> e.getAppTenantId() + ":-" + e.getProductCode(), Function.identity(), (v1, v2) -> v1));
                }
            }
        }
        Map mainResourceMap = goodsResources.stream().filter(p -> purchaseCodes.contains(p.getCode())).collect(Collectors.groupingBy(GoodsResource::getCode, Collectors.mapping(ResourceGoods::resourceGoods, Collectors.toList())));
        Map resourceMainMap = goodsResources.stream().filter(p -> purchaseCodes.contains(p.getCode())).collect(Collectors.groupingBy(GoodsResource::getResourceCode, Collectors.mapping(ResourceGoods::mainGoods, Collectors.toList())));
        ArrayList<AuthorizationVO> authorizations = new ArrayList<AuthorizationVO>();
        for (Purchase purchase : purchases) {
            PurchaseCount purchaseCount = purchaseCounts.stream().filter(o -> purchase.getId().equals(o.getPurchaseId())).findFirst().get();
            List purchaseModule = purchaseModules.stream().filter(o -> purchase.getId().equals(o.getPurchaseId())).collect(Collectors.toList());
            AuthorizationVO authorization = new AuthorizationVO(purchase, purchaseCount, purchaseModule);
            authorization.setResourceGoods((List)mainResourceMap.getOrDefault(purchase.getProductCode(), new ArrayList()));
            authorization.setMainGoods((List)resourceMainMap.getOrDefault(purchase.getProductCode(), new ArrayList()));
            String key = purchase.getCustomerId() + ":-" + purchase.getProductCode();
            authorization.setTodayInvokeCount((Long)Optional.ofNullable(todayInvokeCountMap.get(key)).orElse(0L));
            authorization.setTotalInvokeCount(Optional.ofNullable(statisticInvokeLogMap.get(key)).map(StatisticInvokeLogVO::getTotalInvokeCount).orElse(0L));
            authorization.setFailInvokeCount(Optional.ofNullable(statisticInvokeLogMap.get(key)).map(StatisticInvokeLogVO::getFailInvokeCount).orElse(0L));
            authorizations.add(authorization);
        }
        return authorizations;
    }

    public AuthorizationInfoVO getAuthorizationInfo(String tenantId) {
        return new AuthorizationInfoVO(this.customerCrudService.findById(tenantId), this.getAuthorizations(tenantId));
    }

    public AuthorizationInfoVO getAuthorizationInfo(String tenantId, String userId) {
        return new AuthorizationInfoVO(this.customerCrudService.findById(tenantId), this.getAuthorizations(tenantId, userId));
    }

    public List<AuthorizationInfoVO> getAuthorizationInfos() {
        ArrayList<AuthorizationInfoVO> authorizationInfos = new ArrayList<AuthorizationInfoVO>();
        List tenants = this.customerCrudService.findAll();
        List purchases = this.purchaseCrudService.findAll();
        List purchaseDetail = this.getAuthorizations(purchases);
        Map<String, List<AuthorizationVO>> authorizationMap = purchaseDetail.stream().collect(Collectors.groupingBy(AuthorizationVO::getCustomerId));
        for (Customer tenant : tenants) {
            List authorizations = authorizationMap.getOrDefault(tenant.getId(), Collections.emptyList());
            authorizationInfos.add(new AuthorizationInfoVO(tenant, authorizations));
        }
        return authorizationInfos;
    }

    public CloudPurchaseDTO getCloudPurchase(String tenantId, String goodsCode) {
        return this.getCloudPurchase(tenantId, goodsCode, Boolean.TRUE.booleanValue());
    }

    public CloudPurchaseDTO getCloudPurchase(String tenantId, String goodsCode, boolean containExpiredModules) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        return this.getCloudPurchase(purchase);
    }

    public CloudPurchaseDTO getCloudPurchase(Purchase purchase) {
        return this.getCloudPurchase(purchase, Boolean.TRUE);
    }

    public CloudPurchaseDTO getCloudPurchase(Purchase purchase, Boolean containExpiredModule) {
        if (purchase == null) {
            return null;
        }
        List cloudPurchases = this.getCloudPurchases(Collections.singletonList(purchase), containExpiredModule);
        return cloudPurchases.isEmpty() ? null : (CloudPurchaseDTO)cloudPurchases.get(0);
    }

    public List<CloudPurchaseDTO> getCloudPurchases(List<Purchase> purchases) {
        return this.getCloudPurchases(purchases, Boolean.TRUE);
    }

    public List<CloudPurchaseDTO> getCloudPurchase(String tenantId) {
        List purchases = this.purchaseCrudService.findByTenantId(tenantId);
        return this.getCloudPurchases(purchases);
    }

    public List<CloudPurchaseDTO> getCloudPurchase(String tenantId, List<String> goodsCode) {
        List purchases = this.purchaseCrudService.findByTenantAndGoodsCodes(tenantId, goodsCode);
        return this.getCloudPurchases(purchases);
    }

    public List<CloudPurchaseDTO> getCloudPurchases(List<Purchase> purchases, Boolean containExpiredModule) {
        if (purchases == null || purchases.isEmpty()) {
            return Collections.emptyList();
        }
        List purchaseIds = purchases.stream().map(Purchase::getId).collect(Collectors.toList());
        List purchaseCounts = this.purchaseCountCrudService.findByPurchaseIds(purchaseIds);
        List purchaseModules = containExpiredModule != false ? this.purchaseModuleCrudService.findByPurchaseIds(purchaseIds) : this.purchaseModuleCrudService.findUnExpiredByPurchaseIds(purchaseIds);
        ArrayList<CloudPurchaseDTO> result = new ArrayList<CloudPurchaseDTO>();
        purchases.forEach(purchase -> {
            PurchaseCount purchaseCount = purchaseCounts.stream().filter(o -> purchase.getId().equals(o.getPurchaseId())).findFirst().get();
            List purchaseModule = purchaseModules.stream().filter(o -> purchase.getId().equals(o.getPurchaseId())).collect(Collectors.toList());
            result.add(new CloudPurchaseDTO(purchase, purchaseCount, purchaseModule));
        });
        return result;
    }

    public List<AuthorizationInfoVO> getAuthorizationInfoByModuleId(String moduleId, Boolean test) {
        List auths = this.purchaseMapper.findByModuleId(moduleId);
        if (auths.isEmpty()) {
            return auths;
        }
        List filterTenants = this.iamService.getTenantInfos(auths.stream().map(AuthorizationInfoVO::getTenantId).collect(Collectors.toList()), test, Boolean.valueOf(false));
        if (filterTenants == null) {
            return auths;
        }
        if (filterTenants.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AuthorizationInfoVO> finalAuths = new ArrayList<AuthorizationInfoVO>();
        auths.forEach(a -> {
            TenantInfo tenantInfo = filterTenants.stream().filter(t -> t.getId().equals(a.getTenantId())).findFirst().orElse(null);
            if (tenantInfo != null) {
                a.setTest(tenantInfo.getTestTenant());
                finalAuths.add((AuthorizationInfoVO)a);
            }
        });
        return finalAuths;
    }

    public List<AuthorizationExportVO> findByDate(String beginTime, String endTime) {
        ArrayList<AuthorizationExportVO> authInfos = new ArrayList<AuthorizationExportVO>();
        List purchases = this.purchaseMapper.findByDate(beginTime, endTime);
        if (!CollectionUtils.isEmpty((Collection)purchases)) {
            List paymentTypes = this.gmcService.getPaymentType();
            List purchaseModules = this.purchaseModuleCrudService.findByPurchaseIds(purchases.stream().map(AuthorizationVO::getId).collect(Collectors.toList()));
            purchases.forEach(purchase -> {
                AuthorizationExportVO authorizationExportVO = new AuthorizationExportVO(purchase);
                if (purchase.getTotalUserCount() > 0) {
                    authorizationExportVO.setTotalUsage(purchase.getTotalUserCount());
                } else {
                    authorizationExportVO.setTotalUsage(purchase.getTotalUsage());
                }
                Map<String, String> paymentTypeMap = paymentTypes.stream().collect(Collectors.toMap(PaymentTypeVO::uniqueKey, PaymentTypeVO::getName));
                String paymentTypeName = paymentTypeMap.get(purchase.getCategoryId() + "-" + purchase.getPaymentType());
                authorizationExportVO.setTotalUserNumInfo(String.format("%s %s", authorizationExportVO.getTotalUsage(), paymentTypeName));
                if (ProductType.platform.name().equalsIgnoreCase(purchase.getCategoryId()) || ProductType.app.name().equalsIgnoreCase(purchase.getCategoryId())) {
                    if (purchase.getPaymentType() == PaymentType.NoControl.ordinal() || purchase.getPaymentType() == PaymentType.Month.ordinal()) {
                        authorizationExportVO.setTotalUserNumInfo(String.format("\u221e %s", paymentTypeName));
                    } else if (purchase.getPaymentType() == PaymentType.CountByMonth.ordinal()) {
                        authorizationExportVO.setTotalUserNumInfo(String.format("%s %s%s", authorizationExportVO.getTotalUsage(), purchase.getCustomUnit(), paymentTypeName.substring(paymentTypeName.indexOf("/"))));
                    }
                }
                List modules = purchaseModules.stream().filter(o -> purchase.getId().equals(o.getPurchaseId())).map(AuthorizationModuleVO::new).collect(Collectors.toList());
                authorizationExportVO.setEnabledModules(modules);
                authInfos.add(authorizationExportVO);
            });
        }
        return authInfos;
    }

    public List<CloudPurchaseDTO> getCloudPurchase(List<String> tenantIds, List<String> goodsCode) {
        List purchases = this.purchaseCrudService.findByTenantAndGoodsCodes(tenantIds, goodsCode);
        return this.getCloudPurchases(purchases);
    }

    public List<AuthorizationVO> findByCondition(CustomQueryCondition customQueryCondition) {
        ArrayList<AuthorizationVO> finalAuthorizations = new ArrayList<AuthorizationVO>();
        List authorizationVOS = this.purchaseMapper.findByAppId(customQueryCondition.getAppId());
        if (!CollectionUtils.isEmpty((Collection)customQueryCondition.getUnexpiredModules())) {
            authorizationVOS.forEach(a -> {
                List matchModules = a.getEnabledModules().stream().filter(m -> customQueryCondition.getUnexpiredModules().contains(m.getId()) && LocalDateTime.now().isBefore(m.getExpiredTime())).collect(Collectors.toList());
                if (customQueryCondition.getUnexpiredModules().size() != matchModules.size()) {
                    logger.warn("\u79df\u6237{}\u8d2d\u4e70\u7684\u5e94\u7528{}\u4e0b\u7684\u6a21\u7ec4[{}]\u4e0e\u6307\u5b9a\u6a21\u7ec4[{}]\u4e0d\u5339\u914d", new Object[]{a.getTenantId(), a.getCode(), matchModules.stream().map(AuthorizationModuleVO::getId).collect(Collectors.joining(";")), String.join((CharSequence)";", customQueryCondition.getUnexpiredModules())});
                } else {
                    matchModules = a.getEnabledModules().stream().filter(m -> !customQueryCondition.getUnexpiredModules().contains(m.getId()) && LocalDateTime.now().isBefore(m.getExpiredTime())).collect(Collectors.toList());
                    if (matchModules.isEmpty()) {
                        finalAuthorizations.add((AuthorizationVO)a);
                        return;
                    }
                    logger.warn("\u79df\u6237{}\u8d2d\u4e70\u7684\u5e94\u7528{}\u4e0b\u7684\u5176\u4ed6\u6a21\u7ec4[{}]\u672a\u8fc7\u671f", new Object[]{a.getTenantId(), a.getCode(), matchModules.stream().map(AuthorizationModuleVO::getId).collect(Collectors.joining(";"))});
                }
            });
        } else if (!CollectionUtils.isEmpty((Collection)customQueryCondition.getIncludeModulesOnly())) {
            List moduleIds = customQueryCondition.getIncludeModulesOnly().stream().map(PurchaseModuleVO::getModuleId).collect(Collectors.toList());
            authorizationVOS.forEach(a -> {
                List noMatchModules = a.getEnabledModules().stream().filter(m -> !moduleIds.contains(m.getId())).collect(Collectors.toList());
                if (!noMatchModules.isEmpty()) {
                    logger.warn("\u79df\u6237{}\u8d2d\u4e70\u7684\u5e94\u7528{}\u4e0b\u5b58\u5728\u5176\u4ed6\u7684\u6a21\u7ec4[{}]", new Object[]{a.getTenantId(), a.getCode(), noMatchModules.stream().map(AuthorizationModuleVO::getId).collect(Collectors.joining(";"))});
                } else {
                    customQueryCondition.getIncludeModulesOnly().forEach(c -> {
                        AuthorizationModuleVO authorizationModuleVO = a.getEnabledModules().stream().filter(m -> m.getId().equals(c.getModuleId())).findFirst().orElse(null);
                        if (authorizationModuleVO == null) {
                            logger.error("\u79df\u6237{}\u8d2d\u4e70\u7684\u5e94\u7528{}\u4e0b\u7684\u6a21\u7ec4\u65e0\u6307\u5b9a\u6a21\u7ec4[{}]", new Object[]{a.getTenantId(), a.getCode(), customQueryCondition.getIncludeModulesOnly().stream().map(PurchaseModuleVO::getModuleId).collect(Collectors.joining(";"))});
                            AuthorizationModuleVO authorizationModuleVO1 = new AuthorizationModuleVO();
                            authorizationModuleVO1.setId(c.getModuleId());
                            noMatchModules.add(authorizationModuleVO1);
                        } else if (c.getExpiredDateTime() != null && !c.getExpiredDateTime().isAfter(authorizationModuleVO.getExpiredTime())) {
                            noMatchModules.add(authorizationModuleVO);
                        }
                    });
                    if (!noMatchModules.isEmpty()) {
                        logger.warn("\u79df\u6237{}\u8d2d\u4e70\u7684\u5e94\u7528{}\u4e0b\u7684\u6a21\u7ec4[{}]\u8fc7\u671f", new Object[]{a.getTenantId(), a.getCode(), noMatchModules.stream().map(AuthorizationModuleVO::getId).collect(Collectors.joining(";"))});
                    } else {
                        finalAuthorizations.add((AuthorizationVO)a);
                    }
                }
            });
        } else if (!CollectionUtils.isEmpty((Collection)customQueryCondition.getModules())) {
            List moduleIds = customQueryCondition.getModules().stream().map(PurchaseModuleVO::getModuleId).collect(Collectors.toList());
            authorizationVOS.forEach(a -> {
                List matchModules = a.getEnabledModules().stream().filter(m -> moduleIds.contains(m.getId())).collect(Collectors.toList());
                if (customQueryCondition.getModules().size() > matchModules.size()) {
                    logger.warn("\u79df\u6237{}\u8d2d\u4e70\u7684\u5e94\u7528{}\u4e0b\u7684\u6a21\u7ec4[{}]\u4e0e\u6307\u5b9a\u6a21\u7ec4[{}]\u4e0d\u5339\u914d", new Object[]{a.getTenantId(), a.getCode(), matchModules.stream().map(AuthorizationModuleVO::getId).collect(Collectors.joining(";")), customQueryCondition.getModules().stream().map(PurchaseModuleVO::getModuleId).collect(Collectors.joining(";"))});
                } else {
                    ArrayList noMatchModules = new ArrayList();
                    customQueryCondition.getModules().forEach(m -> {
                        AuthorizationModuleVO authorizationModuleVO = matchModules.stream().filter(d -> d.getId().equals(m.getModuleId()) && (m.getExpiredDateTime() != null && m.getExpiredDateTime().isAfter(d.getExpiredTime()) || m.getExpiredDateTime() == null)).findFirst().orElse(null);
                        if (authorizationModuleVO == null) {
                            authorizationModuleVO = new AuthorizationModuleVO();
                            authorizationModuleVO.setId(m.getModuleId());
                            noMatchModules.add(authorizationModuleVO);
                        }
                    });
                    if (!noMatchModules.isEmpty()) {
                        logger.warn("\u79df\u6237{}\u8d2d\u4e70\u7684\u5e94\u7528{}\u4e0b\u7684\u6a21\u7ec4[{}]\u8fc7\u671f", new Object[]{a.getTenantId(), a.getCode(), noMatchModules.stream().map(AuthorizationModuleVO::getId).collect(Collectors.joining(";"))});
                    } else {
                        finalAuthorizations.add((AuthorizationVO)a);
                    }
                }
            });
        }
        return finalAuthorizations;
    }

    public AuthorizationInfoVO getAuthorizationsSimple(String tenantId, CurrentTenantQueryDTO body) {
        List purchases = this.purchaseCrudService.findByTenantId(tenantId);
        if (body.getQueryExpire() == 0) {
            purchases = purchases.stream().filter(a -> a.getExpiredDateTime().isAfter(LocalDateTime.now())).collect(Collectors.toList());
        } else if (body.getQueryExpire() == 1) {
            purchases = purchases.stream().filter(a -> a.getExpiredDateTime().isBefore(LocalDateTime.now())).collect(Collectors.toList());
        }
        return new AuthorizationInfoVO(this.customerCrudService.findById(tenantId), purchases.stream().map(AuthorizationVO::new).collect(Collectors.toList()));
    }

    public List<TenantVO> findUpdateErpTenant(TenantPurchaseDTO dto) {
        List goodsList = this.gmcService.getGoodsSimpleInfoList(Collections.singletonMap("updateErp", Boolean.TRUE));
        if (goodsList.isEmpty()) {
            return Collections.emptyList();
        }
        dto.setGoodsCodes(goodsList.stream().map(GoodsVO2::getCode).collect(Collectors.toList()));
        List list = this.purchaseMapper.findTenantMaxExpiredDateTime(dto);
        return new ArrayList<TenantVO>(list.stream().collect(Collectors.toMap(TenantVO::getTenantId, v -> v, (v1, v2) -> v1)).values());
    }

    public List<BatchCodeQueryResponse> findBatchDetail(BatchCodeQueryRequest input) {
        String batchCode = input.getBatchCode();
        List processedGoods = this.getLatestPackDetail(batchCode);
        ArrayList<BatchCodeQueryResponse> response = new ArrayList<BatchCodeQueryResponse>();
        for (Purchase purchase : processedGoods) {
            BatchCodeQueryResponse aResponse = new BatchCodeQueryResponse();
            response.add(aResponse);
            BeanUtils.copyProperties((Object)purchase, (Object)aResponse);
            aResponse.setStrategy(this.gmcService.getSellingStrategy(purchase.getProductCode(), purchase.getStrategyId()));
            PurchaseCount count = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
            aResponse.setTotalCountBound(count.getTotalCountBound());
            aResponse.setTotalUsageBound(count.getTotalUsageBound());
            aResponse.setPaymentType(count.getPaymentType());
            if (!GoodsCategoryEnum.isDevice((String)purchase.getProductType())) continue;
            List devices = this.omcService.findDeviceByOrderCode(purchase.getProductId());
            aResponse.setTotalUsageBound(devices.size());
            aResponse.setDeviceCodes(devices.stream().map(OrderCloudDeviceVO::getCode).collect(Collectors.toList()));
        }
        return response;
    }

    @NotNull
    private List<Purchase> getLatestPackDetail(String batchCode) {
        List records = this.recordRepository.findByBatchCode(batchCode);
        Record packRecord = records.stream().filter(a -> GoodsCategoryEnum.PACK.id().equalsIgnoreCase(a.getGoodsCategory())).findFirst().orElseThrow(() -> new BusinessException("\u4e0d\u5b58\u5728"));
        List detailGoodsCodes = records.stream().filter(a -> !GoodsCategoryEnum.PACK.id().equalsIgnoreCase(a.getGoodsCategory())).map(Record::getGoodsCode).collect(Collectors.toList());
        if (detailGoodsCodes.isEmpty()) {
            return new ArrayList<Purchase>();
        }
        List detailGoods = this.purchaseMapper.findPurchasesByTenantAndGoodsCodes(packRecord.getTenantId(), detailGoodsCodes);
        Map<String, Purchase> latestSpecialTypesMap = detailGoods.stream().filter(p -> this.isSpecialProductType(p.getProductType())).collect(Collectors.groupingBy(Purchase::getProductCode, Collectors.collectingAndThen(Collectors.maxBy(Comparator.comparing(BaseEntity::getSid)), optional -> optional.orElse(null))));
        List<Purchase> processedGoods = detailGoods.stream().filter(p -> !this.isSpecialProductType(p.getProductType())).collect(Collectors.toList());
        processedGoods.addAll(latestSpecialTypesMap.values());
        return processedGoods;
    }

    private boolean isSpecialProductType(String productType) {
        return productType != null && SPECIAL_PRODUCT_TYPES.contains(productType.toLowerCase());
    }

    public PackRenewCheckResponse checkPackRenew(String batchCode) {
        List latestPackDetail = this.getLatestPackDetail(batchCode);
        List records = this.recordRepository.findByBatchCode(batchCode);
        Record packRecord = records.stream().filter(a -> GoodsCategoryEnum.PACK.id().equalsIgnoreCase(a.getGoodsCategory())).findFirst().orElseThrow(() -> new BusinessException("\u4e0d\u5b58\u5728"));
        String packCode = packRecord.getGoodsCode();
        Purchase packPurchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(packRecord.getTenantId(), packCode);
        DenyRenewReasonEnum reason = null;
        if (latestPackDetail.stream().anyMatch(a -> !batchCode.equals(a.getBatchCode()))) {
            reason = DenyRenewReasonEnum.INDIVIDUALLY_AUTHORIZED;
        } else if (packPurchase.getExpiredDateTime().isBefore(LocalDateTime.now().minusDays(7L))) {
            reason = DenyRenewReasonEnum.OVERDUE;
        } else if (this.packDetailChanged(latestPackDetail, packRecord.getGoodsCode())) {
            reason = DenyRenewReasonEnum.PACK_DETAIL_CHANGED;
        }
        return new PackRenewCheckResponse(Boolean.valueOf(reason == null), reason);
    }

    private boolean packDetailChanged(List<Purchase> latestPackDetail, String packCode) {
        List detailGoods = this.gmcService.getPackDetail(packCode);
        if (latestPackDetail.size() != detailGoods.size()) {
            return true;
        }
        Map<String, Purchase> purchaseMap = latestPackDetail.stream().collect(Collectors.toMap(Purchase::getProductCode, purchase -> purchase, (p1, p2) -> p1));
        return detailGoods.stream().anyMatch(goods -> !purchaseMap.containsKey(goods.getCode()));
    }

    public InPackCheckResponse checkInPack(String goodsCode, String tenantId, String batchCode) {
        List records;
        Optional<Record> optionalRecord;
        boolean inPack = false;
        if (ObjectUtils.isEmpty((Object)batchCode)) {
            batchCode = "";
            Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
            if (purchase != null) {
                batchCode = purchase.getBatchCode();
            }
        }
        if ((optionalRecord = (records = this.recordRepository.findByBatchCode(batchCode)).stream().filter(a -> GoodsCategoryEnum.PACK.id().equalsIgnoreCase(a.getGoodsCategory())).findFirst()).isPresent()) {
            Record record = optionalRecord.get();
            Purchase packPurchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(record.getTenantId(), record.getGoodsCode());
            LocalDateTime expiredDateTime = packPurchase.getExpiredDateTime();
            LocalDateTime now = LocalDateTime.now();
            if (now.isBefore(expiredDateTime) || Duration.between(expiredDateTime, now).toDays() <= 7L) {
                inPack = true;
            }
        }
        return new InPackCheckResponse(inPack);
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("device");
        types.add("service");
        SPECIAL_PRODUCT_TYPES = Collections.unmodifiableSet(types);
    }
}

