/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.MessageType;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.ProductTypeVO;
import com.digiwin.dap.middleware.cac.domain.PurchaseDetailExtVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.cac.domain.enumeration.Operate;
import com.digiwin.dap.middleware.cac.domain.enumeration.ProductType;
import com.digiwin.dap.middleware.cac.entity.GoodsResource;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.PurchaseModule;
import com.digiwin.dap.middleware.cac.service.basic.CustomerCrudService;
import com.digiwin.dap.middleware.cac.service.basic.GoodsResourceCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseModuleCrudService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeQueryService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeRegistrarService;
import com.digiwin.dap.middleware.cac.service.business.RecordService;
import com.digiwin.dap.middleware.cac.support.remote.LmcService;
import com.digiwin.dap.middleware.cac.support.remote.MailService;
import com.digiwin.dap.middleware.cac.util.BatchCodeUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuthorizeRegistrarServiceImpl
implements AuthorizeRegistrarService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizeRegistrarServiceImpl.class);
    @Autowired
    private LmcService lmcService;
    @Autowired
    private MailService mailService;
    @Autowired
    private RecordService recordService;
    @Autowired
    private CustomerCrudService customerCrudService;
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private AuthorizeQueryService authorizeQueryService;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private PurchaseModuleCrudService purchaseModuleCrudService;
    @Autowired
    private GoodsResourceCrudService goodsResourceCrudService;
    @Autowired
    private ProducerService producerService;

    public Purchase insert(CloudPurchaseDTO cloudPurchase) {
        Purchase purchase = cloudPurchase.generatePurchase();
        PurchaseCount purchaseCount = cloudPurchase.generatePurchaseCount();
        if (GoodsCategoryEnum.API.name().equalsIgnoreCase(purchase.getProductType()) || GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(purchase.getProductType())) {
            purchaseCount.setUsageAlert(Boolean.valueOf(true));
            purchaseCount.setAlertThreshold(Integer.valueOf((int)Math.ceil((double)purchaseCount.getRemainUsageBound() * 0.2)));
        }
        List purchaseModules = cloudPurchase.generatePurchaseModule();
        this.purchaseCrudService.create((BaseEntity)purchase);
        this.purchaseCountCrudService.create((BaseEntity)purchaseCount);
        purchaseModules.forEach(purchaseModule -> this.purchaseModuleCrudService.generateHash((BaseEntity)purchaseModule));
        this.purchaseModuleCrudService.insertAll((Iterable)purchaseModules);
        this.recordService.addRecord(Operate.Insert, cloudPurchase);
        this.recordService.addUserCountRecord(cloudPurchase);
        if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(purchase.getProductType())) {
            this.sendMessageToDmc(purchase, purchaseCount);
        }
        return purchase;
    }

    public void deletePurchaseByTenantId(String tenantId) {
        List purchases = this.purchaseCrudService.findByTenantId(tenantId);
        this.purchaseCrudService.deletePurchase(purchases);
        this.customerCrudService.deleteById(tenantId);
    }

    public void deleteByTenantIdAndGoodsSid(String tenantId, String goodsSid) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsSid(tenantId, goodsSid);
        this.purchaseCrudService.deletePurchase(purchase);
    }

    public void update(CloudPurchaseDTO cloudPurchase) {
        cloudPurchase.setBatchCode(Optional.ofNullable(cloudPurchase.getBatchCode()).orElse(BatchCodeUtil.generateBatchCode((String)BatchCodeUtil.AUTO)));
        String purchaseId = cloudPurchase.getPurchaseId();
        Purchase purchase = this.purchaseCrudService.findByPurchaseId(purchaseId);
        purchase.setId(purchaseId);
        purchase.setStrategyId(cloudPurchase.getStrategyId());
        purchase.setEffectiveDateTime(cloudPurchase.getEffectiveDateTime());
        purchase.setExpiredDateTime(cloudPurchase.getExpiredDateTime());
        purchase.setBufferPeriod(Boolean.valueOf(cloudPurchase.getBufferPeriod() != null && cloudPurchase.getBufferPeriod() != false));
        purchase.setGoodsAliasId("".equals(cloudPurchase.getGoodsAliasId()) ? null : cloudPurchase.getGoodsAliasId());
        purchase.setMemo(cloudPurchase.getMemo());
        purchase.setExpireNotice(cloudPurchase.getExpireNotice());
        purchase.setBundleCode(cloudPurchase.getBundleCode());
        purchase.setBundleName(cloudPurchase.getBundleName());
        purchase.setResourceCategory(cloudPurchase.getResourceCategory());
        purchase.setBatchCode(cloudPurchase.getBatchCode());
        this.purchaseCrudService.update((BaseEntity)purchase);
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchaseId);
        purchaseCount.setPurchaseId(purchaseId);
        if (cloudPurchase.getRemainingUsage() > purchaseCount.getRemainUsageBound()) {
            purchaseCount.setAlertCount(Integer.valueOf(0));
        }
        purchaseCount.setTotalUsageBound(cloudPurchase.getTotalUsage());
        purchaseCount.setRemainUsageBound(cloudPurchase.getRemainingUsage());
        purchaseCount.setRemainUsageCapacity(cloudPurchase.getRemainUsageCapacity());
        purchaseCount.setTotalCountBound(cloudPurchase.getTotalCount());
        purchaseCount.setMonthlyUsageBound(cloudPurchase.getMonthlyUsageBound());
        purchaseCount.setCustomattributes(cloudPurchase.getCustomattributes());
        purchaseCount.setCustomUnit(cloudPurchase.getCustomUnit());
        purchaseCount.setPaymentType(cloudPurchase.getPaymentType());
        this.purchaseCountCrudService.update((BaseEntity)purchaseCount);
        List existsModules = this.purchaseModuleCrudService.findByPurchaseId(purchaseId);
        Map<String, PurchaseModule> moduleMap = existsModules.stream().collect(Collectors.toMap(PurchaseModule::getModuleId, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(BaseEntity::getSid))));
        cloudPurchase.getModules().forEach(updateModule -> {
            if (moduleMap.containsKey(updateModule.getId())) {
                this.purchaseModuleCrudService.update((BaseEntity)((PurchaseModule)moduleMap.get(updateModule.getId())).update(updateModule));
            } else {
                this.purchaseModuleCrudService.create((BaseEntity)new PurchaseModule(purchaseId, updateModule));
            }
        });
        this.recordService.addRecord(Operate.Update, cloudPurchase);
        this.recordService.addUserCountRecord(cloudPurchase);
        if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(purchase.getProductType())) {
            this.sendMessageToDmc(purchase, purchaseCount);
        }
    }

    public void batchUpdate(List<CloudPurchaseDTO> cloudPurchases, boolean mailSend) {
        for (CloudPurchaseDTO cloudPurchase : cloudPurchases) {
            List purchaseModules = cloudPurchase.generatePurchaseModule();
            purchaseModules.forEach(purchaseModule -> this.purchaseModuleCrudService.generateHash((BaseEntity)purchaseModule));
            List existModules = this.purchaseModuleCrudService.findByPurchaseId(cloudPurchase.getPurchaseId());
            for (PurchaseModule purchaseModule2 : purchaseModules) {
                Optional<PurchaseModule> existModule = existModules.stream().filter(a -> a.getModuleId().equals(purchaseModule2.getModuleId())).findFirst();
                existModule.ifPresent(module -> purchaseModule2.setSid(module.getSid()));
            }
            this.purchaseModuleCrudService.saveAll((Iterable)purchaseModules);
            if (!mailSend || purchaseModules.isEmpty()) continue;
            this.mailService.sendBatchAuthorizationModule(cloudPurchase.getProductName(), purchaseModules, cloudPurchase.getCustomerId());
        }
        this.lmcService.saveBatchAuthMoudleLog(cloudPurchases);
    }

    public void updateExpiredDateTime(ProductTypeVO productType) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsSid(productType.getTenantId(), productType.getGoodsId());
        if (purchase == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10015);
        }
        if (ProductType.app.name().equals(purchase.getProductType())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10016);
        }
        purchase.setExpiredDateTime(LocalDateTime.now().withNano(0));
        purchase.setMemo(productType.getMemo());
        this.purchaseCrudService.update((BaseEntity)purchase);
    }

    @Transactional
    public void updateGoodsAndModuleExpiredDateTime(ProductTypeVO productType) {
        CloudPurchaseDTO purchase = this.authorizeQueryService.getCloudPurchase(productType.getTenantId(), productType.getGoodsId());
        if (purchase == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10017, new Object[]{productType.getTenantId(), productType.getGoodsId()});
        }
        LocalDateTime dateTime = productType.getExpiredDateTime() == null ? LocalDateTime.now().withNano(0) : productType.getExpiredDateTime();
        purchase.setExpiredDateTime(dateTime);
        purchase.setMemo(productType.getMemo());
        purchase.getModules().forEach(module -> module.setExpiredTime(dateTime));
        purchase.setBatchCode(productType.getBatchCode());
        this.update(purchase);
    }

    private void sendMessageToDmc(Purchase purchase, PurchaseCount purchaseCount) {
        try {
            List goodsResourceList = this.goodsResourceCrudService.findByResourceCode(purchase.getProductCode());
            PurchaseDetailExtVO purchaseDetailExtVO = this.buildPurchaseDetailExtVO(purchase, purchaseCount);
            if (!CollectionUtils.isEmpty((Collection)goodsResourceList) && Objects.nonNull(purchaseDetailExtVO)) {
                purchaseDetailExtVO.setAppId(goodsResourceList.stream().map(GoodsResource::getCode).distinct().collect(Collectors.toList()));
            }
            MessageBody messageBody = new MessageBody();
            messageBody.setOpType(MessageType.INTERNAL.name());
            messageBody.setData((Object)purchaseDetailExtVO);
            messageBody.setHeaderTag("dmcResourceGoodsPurchase");
            this.producerService.internal(messageBody);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private PurchaseDetailExtVO buildPurchaseDetailExtVO(Purchase purchase, PurchaseCount purchaseCount) {
        if (purchase == null || purchaseCount == null) {
            return null;
        }
        PurchaseDetailExtVO purchaseDetailExtVO = new PurchaseDetailExtVO();
        purchaseDetailExtVO.setId(purchase.getId());
        purchaseDetailExtVO.setSequenceId(purchase.getSequenceId());
        purchaseDetailExtVO.setPurchaseType(purchase.getType());
        purchaseDetailExtVO.setShipmentId(purchase.getShipmentId());
        purchaseDetailExtVO.setCustomerId(purchase.getCustomerId());
        purchaseDetailExtVO.setMemo(purchase.getMemo());
        purchaseDetailExtVO.setProductId(purchase.getProductId());
        purchaseDetailExtVO.setProductCode(purchase.getProductCode());
        purchaseDetailExtVO.setItemId(purchase.getItemId());
        purchaseDetailExtVO.setStrategyId(purchase.getStrategyId());
        purchaseDetailExtVO.setProductType(purchase.getProductType());
        purchaseDetailExtVO.setProductName(purchase.getProductName());
        purchaseDetailExtVO.setProductVersion(purchase.getProductVersion());
        purchaseDetailExtVO.setTrialDays(purchase.getTrialDays());
        purchaseDetailExtVO.setUseType(purchase.getUseType());
        purchaseDetailExtVO.setState(purchase.getState());
        purchaseDetailExtVO.setTicketId(purchase.getTicketId());
        purchaseDetailExtVO.setCreateUserId(purchase.getCreateUserId());
        purchaseDetailExtVO.setCreateDateTime(purchase.getCreateDateTime());
        purchaseDetailExtVO.setEffectiveDateTime(purchase.getEffectiveDateTime());
        purchaseDetailExtVO.setExpiredDateTime(purchase.getExpiredDateTime());
        purchaseDetailExtVO.setRegisterUserId(purchase.getRegisterUserId());
        purchaseDetailExtVO.setRegisterDateTime(purchase.getRegisterDateTime());
        purchaseDetailExtVO.setConfirmUserId(purchase.getConfirmUserId());
        purchaseDetailExtVO.setConfirmDateTime(purchase.getConfirmDateTime());
        purchaseDetailExtVO.setEnabled(purchase.isEnabled());
        purchaseDetailExtVO.setBufferPeriod(purchase.getBufferPeriod());
        purchaseDetailExtVO.setMultiLogin(purchase.isMultiLogin());
        purchaseDetailExtVO.setGoodsAliasId(purchase.getGoodsAliasId());
        purchaseDetailExtVO.setTenantName(purchase.getTenantName());
        purchaseDetailExtVO.setInitialize(purchase.getInitialize());
        purchaseDetailExtVO.setExpireNotice(purchase.getExpireNotice());
        purchaseDetailExtVO.setTransferUnused(purchase.getTransferUnused());
        purchaseDetailExtVO.setMonthlyPlan(purchase.getMonthlyPlan());
        purchaseDetailExtVO.setBundleCode(purchase.getBundleCode());
        purchaseDetailExtVO.setBundleName(purchase.getBundleName());
        purchaseDetailExtVO.setResourceCategory(purchase.getResourceCategory());
        purchaseDetailExtVO.setBatchCode(purchase.getBatchCode());
        purchaseDetailExtVO.setPaymentType(purchaseCount.getPaymentType());
        purchaseDetailExtVO.setCustomUnit(purchaseCount.getCustomUnit());
        purchaseDetailExtVO.setPurchaseCountType(purchaseCount.getType());
        purchaseDetailExtVO.setTotalCountBound(purchaseCount.getTotalCountBound());
        purchaseDetailExtVO.setUserCountBound(purchaseCount.getUserCountBound());
        purchaseDetailExtVO.setTotalUsageBound(purchaseCount.getTotalUsageBound());
        purchaseDetailExtVO.setRemainUsageBound(purchaseCount.getRemainUsageBound());
        purchaseDetailExtVO.setCustomattributes(purchaseCount.getCustomattributes());
        purchaseDetailExtVO.setMonthlyUsageBound(purchaseCount.getMonthlyUsageBound());
        purchaseDetailExtVO.setUsageAlert(purchaseCount.getUsageAlert());
        purchaseDetailExtVO.setAlertThreshold(purchaseCount.getAlertThreshold());
        purchaseDetailExtVO.setAlertCount(purchaseCount.getAlertCount());
        return purchaseDetailExtVO;
    }
}

