/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middleware.cac.domain.DecreaseLogVO;
import com.digiwin.dap.middleware.cac.domain.DevSysVO;
import com.digiwin.dap.middleware.cac.domain.SearchDecreaseLogCondition;
import com.digiwin.dap.middleware.cac.mapper.DecreaseLogMapper;
import com.digiwin.dap.middleware.cac.service.business.DecreaseLogService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.domain.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DecreaseLogServiceImpl
implements DecreaseLogService {
    @Autowired
    private DecreaseLogMapper decreaseLogMapper;
    @Autowired
    private IamService iamService;

    public PageSerializable<DecreaseLogVO> searchByCondition(Page page, SearchDecreaseLogCondition condition) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List list = this.decreaseLogMapper.findByCondition(condition);
        this.fillInfo(list);
        return PageSerializable.of((List)list);
    }

    public List<DecreaseLogVO> searchByCondition(SearchDecreaseLogCondition condition) {
        List list = this.decreaseLogMapper.findByCondition(condition);
        this.fillInfo(list);
        return list;
    }

    public PageSerializable<DecreaseLogVO> searchByConditionAndGroundByUser(Page page, SearchDecreaseLogCondition condition) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List list = this.decreaseLogMapper.findByConditionAndGroundByUser(condition);
        this.fillInfo(list);
        return PageSerializable.of((List)list);
    }

    private void fillInfo(List<DecreaseLogVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List appIdList = list.stream().map(DecreaseLogVO::getAppId).collect(Collectors.toList());
        List devSysVOList = this.iamService.getDevSysList(appIdList);
        if (!CollectionUtils.isEmpty((Collection)devSysVOList)) {
            devSysVOList.forEach(DevSysVO::language);
            Map<String, String> appNameMap = devSysVOList.stream().filter(e -> StringUtils.hasText((String)e.getName())).collect(Collectors.toMap(DevSysVO::getId, DevSysVO::getName, (v1, v2) -> v1));
            list.forEach(e -> e.setAppName(appNameMap.getOrDefault(e.getAppId(), e.getAppId())));
        } else {
            list.forEach(e -> e.setAppName(e.getAppId()));
        }
        list.stream().map(vo -> {
            if (!StringUtils.hasText((String)vo.getUserId())) {
                String quantityUsed = vo.getQuantityUsed();
                if (quantityUsed == null || quantityUsed.trim().isEmpty() || quantityUsed.trim().equals("0")) {
                    vo.setQuantityUsed("0");
                } else {
                    try {
                        BigDecimal bytes = new BigDecimal(quantityUsed);
                        BigDecimal gb = bytes.divide(BigDecimal.valueOf(0x40000000L), 2, 4);
                        vo.setQuantityUsed(gb.toString());
                    }
                    catch (NumberFormatException e) {
                        vo.setQuantityUsed("0");
                    }
                }
                return vo;
            }
            return vo;
        }).collect(Collectors.toList());
    }
}

