/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.service.basic.HashManagerService;
import com.digiwin.dap.middleware.cac.service.business.EnvService;
import com.digiwin.dap.middleware.cac.support.remote.Connectivity;
import com.digiwin.dap.middleware.cac.util.Md5;
import com.digiwin.dap.middleware.cac.util.SqlUtil;
import com.digiwin.dap.middleware.entity.BaseEntity;
import java.lang.reflect.ParameterizedType;
import java.net.NetworkInterface;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.persistence.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class EnvServiceImpl
implements EnvService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private List<HashManagerService<? extends BaseEntity>> hashManagerServices;

    public List<String> getMacAddress() {
        ArrayList<String> macList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                if (mac == null || mac.length != 6) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], ""));
                }
                macList.add(sb.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collections.sort(macList);
        return macList;
    }

    public UUID getIdentity() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.getMacAddress()) {
            sb.append(s).append(System.getProperty("line.separator"));
        }
        sb.append(Paths.get("", new String[0]).toAbsolutePath().toString()).append(System.getProperty("line.separator"));
        return UUID.nameUUIDFromBytes(Md5.encode((String)sb.toString()).getBytes());
    }

    public String getAssemblyVersion() {
        return this.envProperties.getVersion();
    }

    public String checkInternetConnectivity() {
        return Connectivity.checkInternetConnectivity().toString();
    }

    public void reloadHash() {
        for (HashManagerService hashManagerService : this.hashManagerServices) {
            Class clazz = null;
            try {
                clazz = Class.forName(((ParameterizedType)hashManagerService.getClass().getGenericSuperclass()).getActualTypeArguments()[0].getTypeName());
            }
            catch (ClassCastException e) {
                clazz = (Class)((ParameterizedType)((Class)hashManagerService.getClass().getGenericSuperclass()).getGenericSuperclass()).getActualTypeArguments()[0];
            }
            catch (Exception e) {
                continue;
            }
            if (clazz == null) continue;
            String prefix = String.format("update %s set hash = \ncase", clazz.getAnnotation(Table.class).name());
            List entities = hashManagerService.flushHash();
            List updates = SqlUtil.packageSql((String)prefix, (List)entities, (int)500);
            for (String sql : updates) {
                this.jdbcTemplate.execute(sql);
            }
        }
    }
}

