/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middleware.cac.domain.DevSysVO;
import com.digiwin.dap.middleware.cac.domain.InvokeLogVO;
import com.digiwin.dap.middleware.cac.domain.SearchInvokeLogCondition;
import com.digiwin.dap.middleware.cac.entity.InvokeLog;
import com.digiwin.dap.middleware.cac.mapper.InvokeLogMapper;
import com.digiwin.dap.middleware.cac.repository.InvokeLogRepository;
import com.digiwin.dap.middleware.cac.service.business.InvokeLogService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.domain.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvokeLogServiceImpl
implements InvokeLogService {
    @Autowired
    private InvokeLogRepository invokeLogRepository;
    @Autowired
    private InvokeLogMapper invokeLogMapper;
    @Autowired
    private IamService iamService;

    public InvokeLogVO queryByLogId(String logId) {
        InvokeLog invokeLog = this.invokeLogRepository.findByLogId(logId);
        if (invokeLog == null) {
            return null;
        }
        InvokeLogVO invokeLogVO = new InvokeLogVO();
        BeanUtils.copyProperties((Object)invokeLog, (Object)invokeLogVO);
        invokeLogVO.setInvokeTime(invokeLog.getCreateDate());
        this.fillInfo(Collections.singletonList(invokeLogVO));
        return invokeLogVO;
    }

    public PageSerializable<InvokeLogVO> searchByCondition(Page page, SearchInvokeLogCondition condition) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize(), (String)page.getOrderBy());
        List list = this.invokeLogMapper.findByCondition(condition);
        this.fillInfo(list);
        return PageSerializable.of((List)list);
    }

    public List<InvokeLogVO> searchByCondition(SearchInvokeLogCondition condition) {
        List list = this.invokeLogMapper.findByCondition(condition);
        this.fillInfo(list);
        return list;
    }

    private void fillInfo(List<InvokeLogVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List appIdList = list.stream().map(InvokeLogVO::getAppId).collect(Collectors.toList());
        List devSysVOList = this.iamService.getDevSysList(appIdList);
        if (!CollectionUtils.isEmpty((Collection)devSysVOList)) {
            devSysVOList.forEach(DevSysVO::language);
            Map<String, String> appNameMap = devSysVOList.stream().filter(e -> StringUtils.hasText((String)e.getName())).collect(Collectors.toMap(DevSysVO::getId, DevSysVO::getName, (v1, v2) -> v1));
            list.forEach(e -> e.setAppName(appNameMap.getOrDefault(e.getAppId(), e.getAppId())));
        } else {
            list.forEach(e -> e.setAppName(e.getAppId()));
        }
    }
}

