/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.cac.domain.enumeration.Operate;
import com.digiwin.dap.middleware.cac.domain.enumeration.ProductType;
import com.digiwin.dap.middleware.cac.domain.record.RecordConditionVO;
import com.digiwin.dap.middleware.cac.domain.record.RecordExcel;
import com.digiwin.dap.middleware.cac.domain.record.RecordModuleItemVO;
import com.digiwin.dap.middleware.cac.domain.record.RecordSyncVO;
import com.digiwin.dap.middleware.cac.domain.record.RecordVO;
import com.digiwin.dap.middleware.cac.domain.record.report.PreOrderRelateCodeVO;
import com.digiwin.dap.middleware.cac.domain.record.report.RecordReportRequestVO;
import com.digiwin.dap.middleware.cac.domain.record.report.RecordReportVO;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsVO;
import com.digiwin.dap.middleware.cac.entity.Customer;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.PurchaseCountLog;
import com.digiwin.dap.middleware.cac.entity.PurchaseModule;
import com.digiwin.dap.middleware.cac.entity.Record;
import com.digiwin.dap.middleware.cac.entity.RecordModule;
import com.digiwin.dap.middleware.cac.mapper.RecordMapper;
import com.digiwin.dap.middleware.cac.repository.PurchaseCountLogRepository;
import com.digiwin.dap.middleware.cac.repository.RecordRepository;
import com.digiwin.dap.middleware.cac.service.basic.CustomerCrudService;
import com.digiwin.dap.middleware.cac.service.basic.RecordCrudService;
import com.digiwin.dap.middleware.cac.service.basic.RecordModuleCrudService;
import com.digiwin.dap.middleware.cac.service.business.RecordService;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RecordServiceImpl
implements RecordService {
    @Autowired
    private GmcService gmcService;
    @Autowired
    private RecordCrudService recordCrudService;
    @Autowired
    private CustomerCrudService customerCrudService;
    @Autowired
    private RecordModuleCrudService recordModuleCrudService;
    @Autowired
    private RecordMapper recordMapper;
    @Autowired
    private IamService iamService;
    @Autowired
    private RecordRepository recordRepository;
    @Autowired
    private PurchaseCountLogRepository purchaseCountLogRepository;

    public void addRecord(Operate operate, CloudPurchaseDTO cloudPurchase) {
        if (!(ProductType.isApp((String)cloudPurchase.getProductType()) || GoodsCategoryEnum.isDevice((String)cloudPurchase.getProductType()) || GoodsCategoryEnum.isService((String)cloudPurchase.getProductType()))) {
            return;
        }
        Customer customer = this.customerCrudService.findById(cloudPurchase.getCustomerId());
        Record record = new Record();
        record.setSid(SnowFlake.getInstance().newId());
        record.setOperate(operate.name());
        record.setSourceId(cloudPurchase.getSourceId() == null ? "DirectAuthorization" : cloudPurchase.getSourceId());
        record.setTenantSid(0L);
        record.setTenantId(customer.getId());
        record.setTenantName(customer.getName());
        record.setGoodsCategory(cloudPurchase.getProductType());
        if (ProductType.isApp((String)record.getGoodsCategory())) {
            try {
                record.setGoodsSid(Long.parseLong(cloudPurchase.getProductId()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            record.setOrderCode(cloudPurchase.getSourceCode());
        } else {
            record.setOrderCode(cloudPurchase.getProductId());
        }
        record.setGoodsCode(cloudPurchase.getProductCode());
        record.setGoodsName(cloudPurchase.getProductName());
        record.setPaymentType(cloudPurchase.getPaymentType());
        record.setCustomunit(cloudPurchase.getCustomUnit());
        record.setUserCount(cloudPurchase.getTotalCount());
        record.setUseCount(cloudPurchase.getTotalUsage());
        record.setEffectiveDate(cloudPurchase.getEffectiveDateTime());
        record.setExpiredDate(cloudPurchase.getExpiredDateTime());
        record.setRemark(StringUtils.isEmpty((Object)cloudPurchase.getMemo()) ? cloudPurchase.getSourceCode() : cloudPurchase.getMemo());
        record.setMemo(cloudPurchase.getSourceCode());
        record.setBatchCode(cloudPurchase.getBatchCode());
        if (UserUtils.getUserId() != null) {
            record.setCreateById(String.format("%s(%s)", UserUtils.getUserName(), UserUtils.getUserId()));
        }
        ArrayList<RecordModule> recordModules = new ArrayList<RecordModule>();
        for (EnabledModuleDTO module : cloudPurchase.getModules()) {
            RecordModule recordModule = new RecordModule();
            recordModule.setRecordSid(record.getSid());
            recordModule.setId(module.getId());
            recordModule.setName(module.getName());
            recordModule.setUseCount(module.getTotalUsage());
            recordModule.setEffectiveDate(module.getEffectiveTime());
            recordModule.setExpiredDate(module.getExpiredTime());
            recordModules.add(recordModule);
        }
        this.recordCrudService.create((BaseEntity)record);
        this.recordModuleCrudService.insertAll(recordModules);
    }

    public void addRecord(Operate operate, List<CloudPurchaseDTO> cloudPurchases) {
        for (CloudPurchaseDTO cloudPurchase : cloudPurchases) {
            this.addRecord(operate, cloudPurchase);
        }
    }

    public void addRecord(Operate operate, String sourceId, Purchase purchase, PurchaseCount purchaseCount, List<PurchaseModule> purchaseModules) {
        if (!ProductType.isApp((String)purchase.getProductType())) {
            return;
        }
        Record record = this.getRecord(operate, sourceId, purchase);
        this.setPurchaseCount(record, purchaseCount);
        ArrayList<RecordModule> recordModules = new ArrayList<RecordModule>();
        for (PurchaseModule module : purchaseModules) {
            recordModules.add(this.getRecordModule(record.getSid(), module));
        }
        this.recordCrudService.create((BaseEntity)record);
        this.recordModuleCrudService.insertAll(recordModules);
    }

    public void addRecord(Operate operate, String sourceId, Customer customer, List<Purchase> purchases, List<PurchaseCount> purchaseCounts, List<PurchaseModule> purchaseModules) {
        Map<String, PurchaseCount> purchaseCountMap = purchaseCounts.stream().collect(Collectors.toMap(PurchaseCount::getPurchaseId, a -> a, (k1, k2) -> k1));
        Map<String, List<PurchaseModule>> purchaseModuleMap = purchaseModules.stream().collect(Collectors.groupingBy(PurchaseModule::getPurchaseId));
        for (Purchase purchase : purchases) {
            this.addRecord(operate, sourceId, purchase, purchaseCountMap.get(purchase.getId()), purchaseModuleMap.getOrDefault(purchase.getId(), Collections.emptyList()));
        }
    }

    public List<RecordExcel> exportRecord(RecordConditionVO body) {
        List paymentTypes = this.gmcService.getPaymentType();
        ArrayList<RecordExcel> recordExcels = new ArrayList<RecordExcel>();
        if (body.getContainModule().booleanValue()) {
            List recordItems = this.recordCrudService.findItemsByCond(body);
            for (RecordModuleItemVO record : recordItems) {
                recordExcels.add(new RecordExcel((RecordVO)record, paymentTypes));
            }
        } else {
            List recordItems = this.recordCrudService.findByCond(body);
            for (RecordVO record : recordItems) {
                recordExcels.add(new RecordExcel(record, paymentTypes));
            }
        }
        return recordExcels;
    }

    private Record getRecord(Operate operate, String sourceId, Purchase purchase) {
        Customer customer = this.customerCrudService.findById(purchase.getCustomerId());
        Record record = new Record();
        record.setSid(SnowFlake.getInstance().newId());
        record.setOperate(operate.name());
        record.setSourceId(sourceId == null ? "DirectAuthorization" : sourceId);
        record.setTenantSid(0L);
        record.setTenantId(customer.getId());
        record.setTenantName(customer.getName());
        record.setGoodsCategory(purchase.getProductType());
        if (ProductType.isApp((String)record.getGoodsCategory())) {
            record.setGoodsSid(Long.parseLong(purchase.getProductId()));
        } else {
            record.setOrderCode(purchase.getProductId());
        }
        record.setGoodsCode(purchase.getProductCode());
        record.setGoodsName(purchase.getProductName());
        record.setEffectiveDate(purchase.getEffectiveDateTime());
        record.setExpiredDate(purchase.getExpiredDateTime());
        if (UserUtils.getUserId() != null) {
            record.setCreateById(String.format("%s(%s)", UserUtils.getUserName(), UserUtils.getUserId()));
        }
        return record;
    }

    private void setPurchaseCount(Record record, PurchaseCount purchaseCount) {
        if (purchaseCount == null) {
            return;
        }
        record.setPaymentType(purchaseCount.getPaymentType());
        record.setCustomunit(purchaseCount.getCustomUnit());
        record.setUserCount(purchaseCount.getTotalCountBound());
        record.setUseCount(purchaseCount.getTotalUsageBound());
    }

    private RecordModule getRecordModule(long recordSid, PurchaseModule purchaseModule) {
        RecordModule recordModule = new RecordModule();
        recordModule.setRecordSid(recordSid);
        recordModule.setId(purchaseModule.getModuleId());
        recordModule.setName(purchaseModule.getModuleName());
        recordModule.setUseCount(purchaseModule.getTotalUsageBound());
        recordModule.setEffectiveDate(purchaseModule.getEffectiveDateTime());
        recordModule.setExpiredDate(purchaseModule.getExpiredDateTime());
        return recordModule;
    }

    public List<RecordReportVO> queryReport(RecordReportRequestVO request) {
        request.setTestTenantIds(this.iamService.getTestTenantIds());
        PageMethod.startPage((int)request.getPageNum(), (int)request.getPageSize());
        List result = this.recordMapper.findRecord4Report(request);
        Map goods = this.gmcService.getGoodsByGoodsIds(result.stream().map(RecordReportVO::getGoodsCode).collect(Collectors.toList()));
        for (RecordReportVO app : result) {
            GoodsVO goodsVO = Optional.ofNullable(goods.get(app.getGoodsCode())).orElse(new GoodsVO());
            app.setProductCode(goodsVO.getProductCode());
            app.setProductName(goodsVO.getProductName());
        }
        return result;
    }

    public List<RecordReportVO> queryRelateCodeReport(PreOrderRelateCodeVO request) {
        return this.recordMapper.findRelateCode(request);
    }

    @Transactional(rollbackFor={Exception.class})
    public void sync(RecordSyncVO body) {
        List byOrderCode = this.recordRepository.findByOrderCode(body.getOrderCode());
        if (!CollectionUtils.isEmpty((Collection)byOrderCode)) {
            byOrderCode.forEach(a -> a.setRemark(body.getRemark()));
        }
    }

    public void addUserCountRecord(CloudPurchaseDTO cloudPurchaseDTO) {
        if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(cloudPurchaseDTO.getProductType()) && null != cloudPurchaseDTO.getCurrentAuthInfo()) {
            PurchaseCountLog purchaseCountLog = new PurchaseCountLog();
            BeanUtils.copyProperties((Object)cloudPurchaseDTO.getCurrentAuthInfo(), (Object)purchaseCountLog);
            EntityUtils.setCreateFields((BaseEntity)purchaseCountLog);
            this.purchaseCountLogRepository.save((Object)purchaseCountLog);
        }
    }
}

