/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middleware.cac.domain.InvokeLogSummaryDevOmVO;
import com.digiwin.dap.middleware.cac.domain.SearchStatisticInvokeLogCondition;
import com.digiwin.dap.middleware.cac.domain.StatisticInvokeLogDTO;
import com.digiwin.dap.middleware.cac.domain.StatisticInvokeLogVO;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsVO;
import com.digiwin.dap.middleware.cac.domain.remote.TenantInfo;
import com.digiwin.dap.middleware.cac.domain.request.SearchInvokeLogDevOmRequest;
import com.digiwin.dap.middleware.cac.entity.StatisticInvokeLog;
import com.digiwin.dap.middleware.cac.mapper.InvokeLogMapper;
import com.digiwin.dap.middleware.cac.mapper.StatisticInvokeLogMapper;
import com.digiwin.dap.middleware.cac.repository.StatisticInvokeLogRepository;
import com.digiwin.dap.middleware.cac.service.basic.StatisticInvokeLogCrudService;
import com.digiwin.dap.middleware.cac.service.business.StatisticInvokeLogService;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class StatisticInvokeLogServiceImpl
implements StatisticInvokeLogService {
    @Autowired
    private StatisticInvokeLogMapper statisticInvokeLogMapper;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private IamService iamService;
    @Autowired
    private InvokeLogMapper invokeLogMapper;
    @Autowired
    private StatisticInvokeLogRepository statisticInvokeLogRepository;
    @Autowired
    private StatisticInvokeLogCrudService statisticInvokeLogCrudService;

    public PageSerializable<StatisticInvokeLogVO> searchProductMonthInvokeLogsByCondition(Page page, SearchStatisticInvokeLogCondition condition) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List list = this.statisticInvokeLogMapper.searchProductMonthInvokeLogsByCondition(condition);
        this.fillInfo(list);
        return PageSerializable.of((List)list);
    }

    public List<StatisticInvokeLogVO> searchProductMonthInvokeLogsByCondition(SearchStatisticInvokeLogCondition condition) {
        List list = this.statisticInvokeLogMapper.searchProductMonthInvokeLogsByCondition(condition);
        this.fillInfo(list);
        return list;
    }

    private void fillInfo(List<StatisticInvokeLogVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List goodsCodeList = list.stream().map(StatisticInvokeLogVO::getProductCode).collect(Collectors.toList());
        List goodsVOList = this.gmcService.getGoodsByGoodsCodes(goodsCodeList);
        if (!CollectionUtils.isEmpty((Collection)goodsVOList)) {
            Map<String, String> goodsNameMap = goodsVOList.stream().filter(e -> StringUtils.hasText((String)e.getDisplayName())).collect(Collectors.toMap(GoodsVO::getCode, GoodsVO::getDisplayName, (v1, v2) -> v1));
            list.forEach(e -> e.setProductName(goodsNameMap.getOrDefault(e.getProductCode(), e.getProductCode())));
        } else {
            list.forEach(e -> e.setProductName(e.getProductCode()));
        }
    }

    public PageSerializable<StatisticInvokeLogVO> searchAppMonthInvokeLogsByCondition(Page page, SearchStatisticInvokeLogCondition condition) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List list = this.statisticInvokeLogMapper.searchAppMonthInvokeLogsByCondition(condition);
        return PageSerializable.of((List)list);
    }

    public List<StatisticInvokeLogVO> searchAppMonthInvokeLogsByCondition(SearchStatisticInvokeLogCondition condition) {
        return this.statisticInvokeLogMapper.searchAppMonthInvokeLogsByCondition(condition);
    }

    public PageSerializable<StatisticInvokeLogVO> searchTenantMonthInvokeLogsByCondition(Page page, SearchStatisticInvokeLogCondition condition) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List list = this.statisticInvokeLogMapper.searchTenantMonthInvokeLogsByCondition(condition);
        return PageSerializable.of((List)list);
    }

    public void statisticDayAndMonthInvokeRecord(LocalDate start, LocalDate end) {
        LocalDateTime endDate;
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String dateStr = start.format(dateFormatter);
        String monthStr = start.format(monthFormatter);
        LocalDateTime startDate = start.atStartOfDay();
        List statisticLogList = this.invokeLogMapper.statisticLog(startDate, endDate = end.atStartOfDay());
        if (CollectionUtils.isEmpty((Collection)statisticLogList)) {
            return;
        }
        List productCodeList = statisticLogList.stream().map(StatisticInvokeLogDTO::getProductCode).collect(Collectors.toList());
        List goodsVOList = this.gmcService.getGoodsByGoodsCodes(productCodeList);
        Map<Object, Object> goodsMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)goodsVOList)) {
            goodsMap = goodsVOList.stream().collect(Collectors.toMap(GoodsVO::getCode, Function.identity(), (v1, v2) -> v1));
        }
        Map<Object, Object> appTenantMap = new HashMap();
        List appTenantIdList = statisticLogList.stream().map(StatisticInvokeLogDTO::getAppTenantId).collect(Collectors.toList());
        List tenantInfos = this.iamService.getTenantInfos(appTenantIdList, null, null);
        if (!CollectionUtils.isEmpty((Collection)tenantInfos)) {
            appTenantMap = tenantInfos.stream().collect(Collectors.toMap(TenantInfo::getId, TenantInfo::getName, (v1, v2) -> v1));
        }
        for (StatisticInvokeLogDTO dto : statisticLogList) {
            StatisticInvokeLog statisticInvokeLog = this.statisticInvokeLogRepository.findByAppIdAndAppTenantIdAndProductCodeAndTenantIdAndStatisticTypeAndStatisticDate(dto.getAppId(), dto.getAppTenantId(), dto.getProductCode(), dto.getTenantId(), "day", dateStr);
            if (statisticInvokeLog != null) {
                if ("success".equals(dto.getRequestStatus())) {
                    statisticInvokeLog.setSuccessInvokeCount(dto.getInvokeCount());
                } else {
                    statisticInvokeLog.setFailInvokeCount(dto.getInvokeCount());
                }
                statisticInvokeLog.setTotalInvokeCount(Long.valueOf(statisticInvokeLog.getFailInvokeCount() + statisticInvokeLog.getSuccessInvokeCount()));
                statisticInvokeLog.setProductTenantId((String)Optional.ofNullable(goodsMap.get(dto.getProductCode())).map(GoodsVO::getDevId).orElse(null));
                statisticInvokeLog.setProductTenantName((String)Optional.ofNullable(goodsMap.get(dto.getProductCode())).map(GoodsVO::getDevName).orElse(null));
                this.statisticInvokeLogCrudService.update((BaseEntity)statisticInvokeLog);
                continue;
            }
            StatisticInvokeLog statisticLog = new StatisticInvokeLog();
            statisticLog.setStatisticType("day");
            statisticLog.setStatisticDate(dateStr);
            statisticLog.setAppId(dto.getAppId());
            statisticLog.setAppTenantId(dto.getAppTenantId());
            statisticLog.setAppTenantName((String)Optional.ofNullable(appTenantMap.get(dto.getAppTenantId())).orElse(dto.getAppTenantId()));
            statisticLog.setProductCode(dto.getProductCode());
            statisticLog.setProductName(Optional.ofNullable(goodsMap.get(dto.getProductCode())).map(GoodsVO::getDisplayName).orElse(dto.getProductCode()));
            statisticLog.setTenantId(dto.getTenantId());
            statisticLog.setProductTenantId((String)Optional.ofNullable(goodsMap.get(dto.getProductCode())).map(GoodsVO::getDevId).orElse(null));
            statisticLog.setProductTenantName((String)Optional.ofNullable(goodsMap.get(dto.getProductCode())).map(GoodsVO::getDevName).orElse(null));
            if ("success".equals(dto.getRequestStatus())) {
                statisticLog.setSuccessInvokeCount(dto.getInvokeCount());
                statisticLog.setFailInvokeCount(Long.valueOf(0L));
            } else {
                statisticLog.setFailInvokeCount(dto.getInvokeCount());
                statisticLog.setSuccessInvokeCount(Long.valueOf(0L));
            }
            statisticLog.setTotalInvokeCount(Long.valueOf(statisticLog.getFailInvokeCount() + statisticLog.getSuccessInvokeCount()));
            this.statisticInvokeLogCrudService.create((BaseEntity)statisticLog);
        }
        List statisticInvokeLogOfDayList = this.statisticInvokeLogRepository.findByStatisticTypeAndStatisticDate("day", dateStr);
        if (CollectionUtils.isEmpty((Collection)statisticInvokeLogOfDayList)) {
            return;
        }
        for (StatisticInvokeLog ofDay : statisticInvokeLogOfDayList) {
            LocalDate monthFirstDay = start.withDayOfMonth(1);
            LocalDate monthLastDay = start.with(TemporalAdjusters.lastDayOfMonth());
            String monthFirstDayStr = monthFirstDay.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String monthLastDayStr = monthLastDay.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            StatisticInvokeLogDTO statisticInvokeLogDTO = this.statisticInvokeLogMapper.statisticDayLog(ofDay.getAppId(), ofDay.getAppTenantId(), ofDay.getProductCode(), ofDay.getTenantId(), monthFirstDayStr, monthLastDayStr);
            StatisticInvokeLog ofMonth = this.statisticInvokeLogRepository.findByAppIdAndAppTenantIdAndProductCodeAndTenantIdAndStatisticTypeAndStatisticDate(ofDay.getAppId(), ofDay.getAppTenantId(), ofDay.getProductCode(), ofDay.getTenantId(), "month", monthStr);
            if (ofMonth != null) {
                ofMonth.setAppTenantId(ofDay.getAppTenantId());
                ofMonth.setAppTenantName(ofDay.getAppTenantName());
                ofMonth.setProductTenantId(ofDay.getProductTenantId());
                ofMonth.setProductTenantName(ofDay.getProductTenantName());
                ofMonth.setSuccessInvokeCount(statisticInvokeLogDTO.getSuccessInvokeCount());
                ofMonth.setFailInvokeCount(statisticInvokeLogDTO.getFailInvokeCount());
                ofMonth.setTotalInvokeCount(statisticInvokeLogDTO.getTotalInvokeCount());
                this.statisticInvokeLogCrudService.update((BaseEntity)ofMonth);
                continue;
            }
            StatisticInvokeLog ofMonthNew = new StatisticInvokeLog();
            ofMonthNew.setStatisticType("month");
            ofMonthNew.setStatisticDate(monthStr);
            ofMonthNew.setAppId(ofDay.getAppId());
            ofMonthNew.setAppTenantId(ofDay.getAppTenantId());
            ofMonthNew.setAppTenantName(ofDay.getAppTenantName());
            ofMonthNew.setProductCode(ofDay.getProductCode());
            ofMonthNew.setProductName(ofDay.getProductName());
            ofMonthNew.setTenantId(ofDay.getTenantId());
            ofMonthNew.setProductTenantId(ofDay.getProductTenantId());
            ofMonthNew.setProductTenantName(ofDay.getProductTenantName());
            ofMonthNew.setSuccessInvokeCount(statisticInvokeLogDTO.getSuccessInvokeCount());
            ofMonthNew.setFailInvokeCount(statisticInvokeLogDTO.getFailInvokeCount());
            ofMonthNew.setTotalInvokeCount(statisticInvokeLogDTO.getTotalInvokeCount());
            this.statisticInvokeLogCrudService.create((BaseEntity)ofMonthNew);
        }
    }

    public PageSerializable<InvokeLogSummaryDevOmVO> searchDevOmByCondition(Page page, SearchInvokeLogDevOmRequest request) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List list = this.statisticInvokeLogMapper.searchDevOmByCondition(request);
        this.populateGoodsFields(list);
        return PageSerializable.of((List)list);
    }

    private void populateGoodsFields(List<InvokeLogSummaryDevOmVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List goodsCodeList = list.stream().map(InvokeLogSummaryDevOmVO::getProductCode).collect(Collectors.toList());
        List goodsVOList = this.gmcService.getGoodsByGoodsCodes(goodsCodeList);
        Map goodsMap = goodsVOList.stream().collect(Collectors.toMap(GoodsVO::getCode, Function.identity(), (v1, v2) -> v1));
        for (InvokeLogSummaryDevOmVO vo : list) {
            GoodsVO goodsVO = goodsMap.getOrDefault(vo.getProductCode(), new GoodsVO());
            vo.setPaymentType(goodsVO.getPaymentType());
            vo.setPaymentTypeName(goodsVO.getPaymentTypeName());
            vo.setCustomUnit(goodsVO.getCustomUnit());
            vo.setOnSale(goodsVO.getOnSale());
        }
    }

    public PageSerializable<StatisticInvokeLogVO> searchAppMonthInvokeLogsByCondition4DevOm(Page page, SearchStatisticInvokeLogCondition condition) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List list = this.statisticInvokeLogMapper.searchAppMonthInvokeLogsByCondition(condition);
        this.populateOtherInfo(condition, list);
        return PageSerializable.of((List)list);
    }

    private void populateOtherInfo(SearchStatisticInvokeLogCondition condition, List<StatisticInvokeLogVO> list) {
        List tenantIds = list.stream().map(StatisticInvokeLogVO::getAppTenantId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tenantIds)) {
            return;
        }
        List otherInfo = this.statisticInvokeLogMapper.searchAppTenantInvokeLogs(tenantIds, condition.getProductCode());
        Map infoMap = otherInfo.stream().collect(Collectors.toMap(StatisticInvokeLogVO::getAppTenantId, Function.identity(), (v1, v2) -> v1));
        for (StatisticInvokeLogVO vo : list) {
            StatisticInvokeLogVO info = infoMap.getOrDefault(vo.getAppTenantId(), new StatisticInvokeLogVO());
            vo.setTotalUsage(info.getTotalUsage());
            vo.setRemainUsage(info.getRemainUsage());
            vo.setTodayInvokeCount(info.getTodayInvokeCount());
            vo.setPaymentType(info.getPaymentType());
        }
    }
}

