/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeQueryService;
import com.digiwin.dap.middleware.cac.service.business.UseCountService;
import com.digiwin.dap.middleware.cac.service.paymenttype.PaymentTypeContext;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UseCountServiceImpl
implements UseCountService {
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private PaymentTypeContext paymentTypeContext;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private AuthorizeQueryService authorizeQueryService;

    public void updateCustomUnit(String goodsCode, String customUnit) {
        List purchases = this.purchaseCrudService.findByGoodsCode(goodsCode);
        List purchaseIds = purchases.stream().map(Purchase::getId).collect(Collectors.toList());
        if (!purchaseIds.isEmpty()) {
            this.purchaseCountCrudService.updateCustomUnit(purchaseIds, customUnit);
        }
    }

    public UsageCountResultVO getAuthorizationCountingResult(String tenantId, String goodsCode, String moduleId) {
        AuthorizationVO authorizationVO = this.authorizeQueryService.getAuthorization(tenantId, goodsCode);
        AuthorizationModuleVO module = authorizationVO.getEnabledModules().stream().filter(m -> m.getId().equals(moduleId)).findFirst().orElse(null);
        if (module == null) {
            return new UsageCountResultVO(false, -1, -1);
        }
        return this.paymentTypeContext.getAuthorizationCountingResult(authorizationVO, module);
    }

    public UsageCountResultVO decreaseAuthorizationCounting(String tenantId, String goodsCode, Integer decreaseCount) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        if (purchase == null) {
            return new UsageCountResultVO(false, 0, 0);
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        UsageCountResultVO usageCountResultVO = this.paymentTypeContext.decrementUsageCount(purchase, purchaseCount, decreaseCount);
        HashMap<String, String> argument = new HashMap<String, String>();
        argument.put("productName", purchase.getProductName());
        argument.put("purchaseId", purchase.getId());
        usageCountResultVO.setArgument(argument);
        return usageCountResultVO;
    }

    public UsageCountResultVO addAuthorizationCounting(String tenantId, String goodsCode, Integer decreaseCount) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        if (purchase == null) {
            return new UsageCountResultVO(false, 0, 0);
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        UsageCountResultVO usageCountResultVO = this.paymentTypeContext.addUsageCount(purchase, purchaseCount, decreaseCount);
        HashMap<String, String> argument = new HashMap<String, String>();
        argument.put("productName", purchase.getProductName());
        argument.put("purchaseId", purchase.getId());
        usageCountResultVO.setArgument(argument);
        return usageCountResultVO;
    }
}

