/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.business.impl;

import com.digiwin.dap.middleware.cac.domain.AppAuthUserByAppVO;
import com.digiwin.dap.middleware.cac.domain.AppAuthUserDTO;
import com.digiwin.dap.middleware.cac.domain.CountResultVO;
import com.digiwin.dap.middleware.cac.domain.OrderInfoVO;
import com.digiwin.dap.middleware.cac.domain.TenantVO;
import com.digiwin.dap.middleware.cac.domain.UserInCountingConditionVO;
import com.digiwin.dap.middleware.cac.domain.UserInCountingVO;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsVO;
import com.digiwin.dap.middleware.cac.domain.remote.TenantSimpleVO;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.UserInCounting;
import com.digiwin.dap.middleware.cac.mapper.PurchaseCountMapper;
import com.digiwin.dap.middleware.cac.mapper.UserInCountingMapper;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.UserInCountingCrudService;
import com.digiwin.dap.middleware.cac.service.business.UserCountService;
import com.digiwin.dap.middleware.cac.service.counttype.CountTypeContext;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserCountServiceImpl
implements UserCountService {
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private CountTypeContext countTypeContext;
    @Autowired
    private PurchaseCountMapper purchaseCountMapper;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private UserInCountingCrudService userInCountingCrudService;
    @Autowired
    private UserInCountingMapper userInCountingMapper;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private IamService iamService;

    public CountResultVO addUser(PurchaseCount purchaseCount, String userId) {
        int userCount = this.userInCountingCrudService.addUser(purchaseCount.getPurchaseId(), userId);
        return new CountResultVO(true, userCount, purchaseCount.getTotalCountBound());
    }

    public CountResultVO addUser(String tenantId, String goodsCode, String userId) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        if (purchase == null) {
            return new CountResultVO(false, 0, 0);
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        return this.countTypeContext.addUserInCounting(purchaseCount, userId);
    }

    public CountResultVO removeUser(PurchaseCount purchaseCount, String userId) {
        int userCount = this.userInCountingCrudService.removeUser(purchaseCount.getPurchaseId(), userId);
        return new CountResultVO(true, userCount, purchaseCount.getTotalCountBound());
    }

    public CountResultVO removeUserByTenantId(String tenantId, String userId) {
        try {
            List purchases = this.purchaseCrudService.findByTenantIdAndUserId(tenantId, userId);
            purchases.forEach(purchase -> {
                PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
                this.countTypeContext.removeUserInCounting(purchaseCount, userId);
            });
        }
        catch (Exception e) {
            return new CountResultVO(Boolean.FALSE.booleanValue(), -1, -1);
        }
        return new CountResultVO(Boolean.TRUE.booleanValue(), -1, -1);
    }

    public CountResultVO removeUser(String tenantId, String goodsCode, String userId) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        if (purchase == null) {
            return new CountResultVO(false, 0, 0);
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        return this.countTypeContext.removeUserInCounting(purchaseCount, userId);
    }

    public CountResultVO batchRemoveUser(String userId) {
        List purchaseInfo = this.purchaseCountMapper.findPurchaseByUser(userId);
        CountResultVO result = new CountResultVO();
        if (!purchaseInfo.isEmpty()) {
            List purchaseCounts = this.purchaseCountCrudService.findByPurchaseIds(purchaseInfo.stream().map(TenantVO::getPurchaseId).collect(Collectors.toList()));
            purchaseCounts.forEach(purchaseCount -> this.countTypeContext.removeUserInCounting(purchaseCount, userId));
            result.getArgument().put("tenantIds", purchaseInfo.stream().map(TenantVO::getTenantId).distinct().collect(Collectors.joining(",")));
            result.getArgument().put("apps", purchaseInfo.stream().map(TenantVO::getGoodsCode).distinct().collect(Collectors.joining(",")));
        }
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }

    public CountResultVO batchUpdateUser(String tenantId, String goodsCode, List<String> userIds) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        if (purchase == null) {
            return new CountResultVO(false, 0, 0);
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        return this.countTypeContext.updateUserInCounting(purchaseCount, userIds);
    }

    public CountResultVO batchAddUsers(String tenantId, String goodsCode, List<String> userIds) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        if (purchase == null) {
            return new CountResultVO(false, 0, 0);
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        ArrayList results = new ArrayList();
        List existedUsers = this.getUserInCounting(purchase.getId());
        ArrayList addUsers = new ArrayList();
        userIds.forEach(userId -> {
            if (!existedUsers.contains(userId)) {
                CountResultVO countResultVO = this.countTypeContext.addUserInCounting(purchaseCount, userId);
                countResultVO.getArgument().put("strategyId", purchase.getStrategyId());
                addUsers.add(userId);
                results.add(countResultVO);
            }
        });
        if (results.isEmpty()) {
            return new CountResultVO(true, 0, 0);
        }
        CountResultVO finalCountResult = (CountResultVO)results.get(0);
        finalCountResult.setCurrentCount(addUsers.size());
        finalCountResult.getArgument().put("users", String.join((CharSequence)";", addUsers));
        return finalCountResult;
    }

    public List<String> getUserInCounting(String purchaseId) {
        List users = this.userInCountingCrudService.findByPurchaseId(purchaseId);
        return users.stream().map(UserInCounting::getUserId).sorted().collect(Collectors.toList());
    }

    public List<String> getUserInCounting(String tenantId, String goodsCode) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        if (purchase == null) {
            return Collections.emptyList();
        }
        return this.getUserInCounting(purchase.getId());
    }

    public boolean checkUserInCounting(String purchaseId, String userId) {
        return this.userInCountingCrudService.countByPurchaseIdAndUserId(purchaseId, userId) > 0;
    }

    public List<AppAuthUserByAppVO> getAuthUsersByApp(AppAuthUserDTO body) {
        if (!body.getIncludeExpireTenants()) {
            body.setExpireTimeAfter(LocalDateTime.now());
        }
        body.setTenantIds(this.iamService.getALlAthenaTenants().stream().filter(a -> a.getTestTenant() == false && a.getEnterpriseType() > 0).map(TenantSimpleVO::getTenantId).collect(Collectors.toList()));
        List appAuthUsers = this.userInCountingMapper.getAppAuthUsersByApp(body);
        Map goods = this.gmcService.getGoodsByGoodsIds(appAuthUsers.stream().map(AppAuthUserByAppVO::getAppId).collect(Collectors.toList()));
        for (AppAuthUserByAppVO app : appAuthUsers) {
            GoodsVO goodsVO = Optional.ofNullable(goods.get(app.getAppId())).orElse(new GoodsVO());
            app.setProductLineId(goodsVO.getProductCode());
            app.setProductLineName(goodsVO.getProductName());
        }
        return appAuthUsers;
    }

    public List<String> getAuthedUserIds(OrderInfoVO body) {
        if (CollectionUtils.isEmpty((Collection)body.getUsers())) {
            return new ArrayList<String>();
        }
        return this.userInCountingMapper.getAuthedUserIds(body);
    }

    public CountResultVO batchRemoveUserFromPurchase(String tenantId, String goodsCode, List<String> users) {
        CountResultVO result = new CountResultVO();
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        if (purchase == null) {
            result.setSuccess(Boolean.valueOf(false));
            return result;
        }
        this.userInCountingCrudService.batchRemoveUser(purchase.getId(), users);
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public CountResultVO batchAddUser(String tenantId, String goodsCode, List<String> userIds) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(tenantId, goodsCode);
        if (purchase == null) {
            return new CountResultVO(false, 0, 0);
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        for (String userId : userIds) {
            this.countTypeContext.addUserInCounting(purchaseCount, userId);
        }
        PurchaseCount newCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        return new CountResultVO(true, newCount.getUserCountBound(), newCount.getTotalCountBound());
    }

    public void deleteUserInCountings(List<UserInCounting> userInCountings, String purchaseId) {
        for (UserInCounting userInCounting : userInCountings) {
            this.userInCountingCrudService.deleteById(userInCounting.getSid());
        }
        PurchaseCount count = this.purchaseCountCrudService.findByPurchaseId(purchaseId);
        count.setUserCountBound(Math.max(0, count.getUserCountBound() - userInCountings.size()));
        this.purchaseCountCrudService.update((BaseEntity)count);
    }

    public List<UserInCountingVO> getUserInCountingVO(UserInCountingConditionVO conditionVO) {
        return this.userInCountingMapper.getUserInCountingVO(conditionVO);
    }
}

