/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.counttype.impl;

import com.digiwin.dap.middleware.cac.domain.CountResultVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.CountPattern;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.service.business.UserCountService;
import com.digiwin.dap.middleware.cac.service.counttype.CountTypeService;
import com.digiwin.dap.middleware.cac.util.UserIdUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CountTypeTraditionalServiceImpl
extends CountTypeService {
    @Autowired
    private UserCountService userCountService;
    private static final Logger logger = LoggerFactory.getLogger(CountTypeTraditionalServiceImpl.class);

    public boolean support(String countPattern) {
        return CountPattern.Traditional.name().equals(countPattern);
    }

    public CountResultVO addUser(PurchaseCount purchaseCount, String userId) {
        if (!UserIdUtil.isDigiwin((String)userId) && purchaseCount.getUserCountBound() == purchaseCount.getTotalCountBound()) {
            return new CountResultVO(false, purchaseCount.getUserCountBound(), purchaseCount.getTotalCountBound());
        }
        return this.userCountService.addUser(purchaseCount, userId);
    }

    public CountResultVO removeUser(PurchaseCount purchaseCount, String userId) {
        return this.userCountService.removeUser(purchaseCount, userId);
    }

    public CountResultVO updateUser(PurchaseCount purchaseCount, List<String> updateUserIds) {
        CountResultVO countResultVO;
        List existsUserIds = this.userCountService.getUserInCounting(purchaseCount.getPurchaseId());
        ArrayList<String> addUserIds = new ArrayList<String>(updateUserIds);
        addUserIds.removeAll(existsUserIds);
        existsUserIds.removeAll(updateUserIds);
        HashSet<String> externalUserIds = new HashSet<String>();
        for (String updateUser : updateUserIds) {
            if (UserIdUtil.isDigiwin((String)updateUser)) continue;
            externalUserIds.add(updateUser);
        }
        int finalUserCount = externalUserIds.size();
        if (finalUserCount > purchaseCount.getTotalCountBound()) {
            logger.info("\u8d85\u8fc7\u6700\u5927\u7528\u6237\u6570{},\u73b0\u5728\u589e\u52a0\u7528\u6237\u6570{}\uff0c id {}", new Object[]{purchaseCount.getTotalCountBound(), finalUserCount, purchaseCount.getPurchaseId()});
            countResultVO = new CountResultVO(false, purchaseCount.getUserCountBound(), purchaseCount.getTotalCountBound());
        } else {
            countResultVO = new CountResultVO(true, finalUserCount, purchaseCount.getTotalCountBound());
        }
        if (countResultVO.getSuccess().booleanValue()) {
            existsUserIds.forEach(user -> this.userCountService.removeUser(purchaseCount, user));
            addUserIds.forEach(user -> this.userCountService.addUser(purchaseCount, user));
        }
        return countResultVO;
    }
}

