/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.counttype.impl;

import com.digiwin.dap.middleware.cac.domain.CountResultVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.CountPattern;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.service.business.UserCountService;
import com.digiwin.dap.middleware.cac.service.counttype.CountTypeService;
import com.digiwin.dap.middleware.cac.util.UserIdUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CountTypeUnlimitedServiceImpl
extends CountTypeService {
    @Autowired
    private UserCountService userCountService;

    public boolean support(String countPattern) {
        return CountPattern.Unlimited.name().equals(countPattern);
    }

    public CountResultVO addUser(PurchaseCount purchaseCount, String userId) {
        CountResultVO countResultVO = this.userCountService.addUser(purchaseCount, userId);
        countResultVO.setTotalCount(-1);
        return countResultVO;
    }

    public CountResultVO removeUser(PurchaseCount purchaseCount, String userId) {
        CountResultVO countResultVO = this.userCountService.removeUser(purchaseCount, userId);
        countResultVO.setTotalCount(-1);
        return countResultVO;
    }

    public CountResultVO updateUser(PurchaseCount purchaseCount, List<String> updateUserIds) {
        List existsUserIds = this.userCountService.getUserInCounting(purchaseCount.getPurchaseId());
        ArrayList<String> addUserIds = new ArrayList<String>(updateUserIds);
        addUserIds.removeAll(existsUserIds);
        existsUserIds.removeAll(updateUserIds);
        HashSet<String> externalUserIds = new HashSet<String>();
        for (String updateUser : updateUserIds) {
            if (UserIdUtil.isDigiwin((String)updateUser)) continue;
            externalUserIds.add(updateUser);
        }
        int totalCount = externalUserIds.size();
        existsUserIds.forEach(user -> this.userCountService.removeUser(purchaseCount, user));
        addUserIds.forEach(user -> this.userCountService.addUser(purchaseCount, user));
        return new CountResultVO(true, totalCount, -1);
    }
}

