/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.excel.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.SearchDecreaseLogCondition;
import com.digiwin.dap.middleware.cac.domain.SearchParamVO;
import com.digiwin.dap.middleware.cac.domain.TenantResourceDecreaseLogExcel;
import com.digiwin.dap.middleware.cac.domain.excel.AuthorizationInfoExcel;
import com.digiwin.dap.middleware.cac.domain.remote.TenantInfo;
import com.digiwin.dap.middleware.cac.mapper.PurchaseMapper;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeArchiveService;
import com.digiwin.dap.middleware.cac.service.business.DecreaseLogService;
import com.digiwin.dap.middleware.cac.service.excel.ExcelService;
import com.digiwin.dap.middleware.cac.service.excel.impl.HideEmptyColumnHandler;
import com.digiwin.dap.middleware.cac.service.excel.impl.TitleCellHandler;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.github.pagehelper.PageSerializable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ExcelServiceImpl
implements ExcelService {
    private Logger logger = LoggerFactory.getLogger(ExcelServiceImpl.class);
    @Autowired
    private AuthorizeArchiveService authorizeArchiveService;
    @Autowired
    private IamService iamService;
    @Autowired
    private PurchaseMapper purchaseMapper;
    @Autowired
    private DecreaseLogService decreaseLogService;

    public void exportAuthorizationInfo(SearchParamVO searchParamVO, int pageNum, int pageSize, String orderBy, HttpServletResponse response) {
        List tenantInfos;
        PageSerializable result = this.authorizeArchiveService.getAuthorizationByPage(searchParamVO, pageNum, pageSize, orderBy, Boolean.TRUE.booleanValue());
        ArrayList authExcels = new ArrayList();
        HashSet<Integer> excludeColumnFiledNames = new HashSet<Integer>();
        if (ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)searchParamVO.getWithTenantContact())) {
            List tenantIds = result.getList().stream().map(AuthorizationVO::getTenantId).collect(Collectors.toList());
            tenantInfos = !CollectionUtils.isEmpty(tenantIds) ? this.iamService.getTenantInfos(tenantIds, null, Boolean.valueOf(false)) : new ArrayList();
        } else {
            tenantInfos = new ArrayList();
            excludeColumnFiledNames.addAll(Arrays.asList(8, 9, 10));
        }
        result.getList().forEach(a -> {
            TenantInfo matchTenant = tenantInfos.stream().filter(t -> t.getId().equals(a.getTenantId())).findFirst().orElse(null);
            AuthorizationInfoExcel authorizationInfoExcel = new AuthorizationInfoExcel(a, matchTenant);
            authExcels.add(authorizationInfoExcel);
            if (ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)searchParamVO.getWithModule())) {
                a.getEnabledModules().forEach(m -> {
                    AuthorizationInfoExcel moduleExcel = new AuthorizationInfoExcel(m);
                    authExcels.add(moduleExcel);
                });
            }
        });
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("UTF-8");
            String fileName = URLEncoder.encode("\u5e94\u7528\u6388\u6743\u660e\u7ec6_" + LocalDate.now(), "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            if (!ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)searchParamVO.getWithModule())) {
                excludeColumnFiledNames.add(2);
            }
            ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), AuthorizationInfoExcel.class).autoCloseStream(Boolean.TRUE).registerWriteHandler((WriteHandler)new TitleCellHandler())).registerWriteHandler((WriteHandler)new HideEmptyColumnHandler(excludeColumnFiledNames))).sheet("Sheet1").doWrite(authExcels);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public void exportResourceDecreaseLog(SearchDecreaseLogCondition condition, HttpServletResponse response) {
        Page page = new Page();
        page.setPageSize(Integer.valueOf(9999));
        List<Object> resourceDecreaseLogExcels = new ArrayList();
        PageSerializable pageSerializable = this.decreaseLogService.searchByCondition(page, condition);
        if (!CollectionUtils.isEmpty((Collection)pageSerializable.getList())) {
            resourceDecreaseLogExcels = pageSerializable.getList().stream().map(TenantResourceDecreaseLogExcel::new).collect(Collectors.toList());
        }
        CloudPurchaseDTO purchase = this.purchaseMapper.findByTenantIdAndGoodsCode(condition.getAppTenantId(), condition.getProductCode());
        try {
            InputStream inputStream = Locale.TRADITIONAL_CHINESE.equals(LocaleContextHolder.getLocale()) ? this.getClass().getResourceAsStream("/static/templates/resource_decrease_log_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/resource_decrease_log_CN.xlsx");
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("UTF-8");
            String fileName = URLEncoder.encode("\u6388\u6743\u5f02\u52a8\u660e\u7ec6_" + LocalDate.now(), "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            ExcelWriter writer = EasyExcel.write((OutputStream)response.getOutputStream()).withTemplate(inputStream).build();
            WriteSheet sheet = EasyExcel.writerSheet().build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
            writer.fill(resourceDecreaseLogExcels, fillConfig, sheet);
            HashMap<String, String> master = new HashMap<String, String>();
            master.put("tenantContent", StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{purchase.getCustomerName(), purchase.getCustomerId()}));
            master.put("date", StrUtil.format((CharSequence)"{}~{}", (Object[])new Object[]{purchase.getEffectiveDateTime(), purchase.getExpiredDateTime()}));
            master.put("appContent", StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{purchase.getProductName(), purchase.getProductCode()}));
            writer.fill(master, sheet);
            writer.finish();
        }
        catch (Exception ex) {
            throw new BusinessException((Throwable)ex);
        }
    }
}

