/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.paymenttype;

import com.digiwin.dap.middleware.cac.constant.CacConstants;
import com.digiwin.dap.middleware.cac.domain.CalcExpire;
import com.digiwin.dap.middleware.cac.domain.enumeration.AuthCategory;
import com.digiwin.dap.middleware.cac.domain.enumeration.GoodsCategoryEnum;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class CalcUtil {
    public static LocalDateTime calcNewPurchaseExpiredTime(CalcExpire calcExpire) {
        LocalDateTime expireDate;
        expireDate = calcExpire.getCategory() == AuthCategory.Dealer || calcExpire.getCategory() == AuthCategory.BossManualAuthorization || calcExpire.getCategory() == AuthCategory.AccessoryPlatform || calcExpire.getCategory() == AuthCategory.Accessory || calcExpire.getCategory() == AuthCategory.PlatformAuto ? calcExpire.getPurchaseExpectDate() : (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(calcExpire.getCategoryId()) && Boolean.FALSE.equals(calcExpire.getEnableTenancy()) ? CacConstants.PERMANENT_TIME : ((expireDate = calcExpire.getEffectiveDateTime().plusMonths(calcExpire.getMonth()).with(LocalTime.MAX)).isAfter(CacConstants.PERMANENT_TIME) ? CacConstants.PERMANENT_TIME : expireDate));
        calcExpire.setPurchaseFinalDate(expireDate.withNano(0));
        return calcExpire.getPurchaseFinalDate();
    }

    public static LocalDateTime calcNewModuleExpiredTime(CalcExpire calcExpire) {
        LocalDateTime expireDate = calcExpire.getPurchaseFinalDate();
        if (calcExpire.getCategory() == AuthCategory.BossManualAuthorization && calcExpire.getModuleExpectDate() != null) {
            expireDate = calcExpire.getModuleExpectDate();
        }
        calcExpire.setModuleFinalDate(expireDate.withNano(0));
        return calcExpire.getModuleFinalDate();
    }

    public static LocalDateTime calcUpdatePurchaseExpiredTime(CalcExpire calcExpire) {
        LocalDateTime expireDate = calcExpire.getPurchaseActualDate();
        if (calcExpire.getCategory() == AuthCategory.Dealer || calcExpire.getCategory() == AuthCategory.PlatformAuto || calcExpire.getCategory() == AuthCategory.AccessoryPlatform) {
            if (calcExpire.getPurchaseExpectDate().isAfter(calcExpire.getPurchaseActualDate())) {
                expireDate = calcExpire.getPurchaseExpectDate();
            }
        } else if (calcExpire.getCategory() == AuthCategory.BossManualAuthorization) {
            expireDate = calcExpire.getPurchaseExpectDate();
            if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(calcExpire.getCategoryId()) && expireDate.isBefore(calcExpire.getPurchaseActualDate())) {
                expireDate = calcExpire.getPurchaseActualDate();
            }
        } else if (calcExpire.getCategory() == AuthCategory.OverlayTenancyPeriod || calcExpire.getCategory() == AuthCategory.Accessory) {
            if (LocalDateTime.now().isAfter(expireDate)) {
                expireDate = LocalDateTime.now();
            }
            if (Boolean.TRUE.equals(calcExpire.getOverlayTenancyPeriod())) {
                expireDate = expireDate.plusMonths(calcExpire.getMonth()).with(LocalTime.MAX);
            }
            if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(calcExpire.getCategoryId()) && Boolean.FALSE.equals(calcExpire.getEnableTenancy())) {
                expireDate = CacConstants.PERMANENT_TIME;
            }
            expireDate = expireDate.isAfter(CacConstants.PERMANENT_TIME) ? CacConstants.PERMANENT_TIME : expireDate;
        } else {
            expireDate = calcExpire.getPurchaseActualDate();
        }
        calcExpire.setPurchaseFinalDate(expireDate.withNano(0));
        return calcExpire.getPurchaseFinalDate();
    }

    public static LocalDateTime calcUpdateResourcePurchaseExpiredTime(CalcExpire calcExpire) {
        LocalDateTime expireDate = calcExpire.getPurchaseExpectDate();
        if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(calcExpire.getCategoryId()) && Boolean.FALSE.equals(calcExpire.getEnableTenancy())) {
            expireDate = CacConstants.PERMANENT_TIME;
        } else if (null == expireDate) {
            expireDate = calcExpire.getEffectiveDateTime().plusMonths(calcExpire.getMonth()).with(LocalTime.MAX);
            expireDate = expireDate.isAfter(CacConstants.PERMANENT_TIME) ? CacConstants.PERMANENT_TIME : expireDate;
        }
        return expireDate.withNano(0);
    }

    public static LocalDateTime calcUpdateModuleExpiredTime(CalcExpire calcExpire) {
        LocalDateTime expireDate;
        if (calcExpire.getCategory() == AuthCategory.BossManualAuthorization || calcExpire.getCategory() == AuthCategory.PlatformAuto || calcExpire.getCategory() == AuthCategory.AccessoryPlatform || calcExpire.getCategory() == AuthCategory.Accessory) {
            expireDate = calcExpire.getModuleExpectDate() != null ? calcExpire.getModuleExpectDate() : calcExpire.getPurchaseFinalDate();
        } else if (calcExpire.getCategory() == AuthCategory.OverlayTenancyPeriod) {
            if (calcExpire.getModuleActualDate() == null) {
                expireDate = calcExpire.getNow();
            } else {
                LocalDateTime localDateTime = expireDate = calcExpire.getNow().isAfter(calcExpire.getModuleActualDate()) ? calcExpire.getNow() : calcExpire.getModuleActualDate();
            }
            if (Boolean.TRUE.equals(calcExpire.getOverlayTenancyPeriod())) {
                expireDate = expireDate.plusMonths(calcExpire.getMonth()).with(LocalTime.MAX);
            }
            if (expireDate.isAfter(CacConstants.PERMANENT_TIME)) {
                expireDate = CacConstants.PERMANENT_TIME;
            }
        } else {
            expireDate = calcExpire.getPurchaseActualDate();
        }
        calcExpire.setModuleFinalDate(expireDate.withNano(0));
        return calcExpire.getModuleFinalDate();
    }
}

