/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.paymenttype;

import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.CancelAuth;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EditParamVO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.ObsoleteTenantAuthInfo;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.service.paymenttype.PaymentTypeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentTypeContext {
    @Autowired
    private List<PaymentTypeService> paymentTypeServices;

    public void decidePaymentType(CloudPurchaseDTO purchase, PurchaseVO info) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(purchase.getPaymentType())) continue;
            paymentTypeService.decidePaymentType(purchase, info);
            break;
        }
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, PurchaseVO info) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(purchase.getPaymentType())) continue;
            paymentTypeService.decideUpdatePaymentType(purchase, info);
            break;
        }
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, EditParamVO editParamVO) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(purchase.getPaymentType())) continue;
            paymentTypeService.decideUpdatePaymentType(purchase, editParamVO);
            break;
        }
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, List<AuthorizationModuleVO> modules) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(purchase.getPaymentType())) continue;
            paymentTypeService.decideUpdatePaymentType(purchase, modules);
            break;
        }
    }

    public Boolean checkAuthorizationValid(CloudPurchaseDTO purchase) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(purchase.getPaymentType())) continue;
            return paymentTypeService.checkAuthorizationValid(purchase);
        }
        return false;
    }

    public Boolean checkModuleInvalid(int paymentType, EnabledModuleDTO module) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(paymentType)) continue;
            return paymentTypeService.checkModuleInvalid(paymentType, module);
        }
        return false;
    }

    public UsageCountResultVO getAuthorizationCountingResult(AuthorizationVO authorizationVO, AuthorizationModuleVO module) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(authorizationVO.getPaymentType())) continue;
            return paymentTypeService.getAuthorizationCountingResult(authorizationVO, module);
        }
        return new UsageCountResultVO(false, -1, -1);
    }

    public UsageCountResultVO decrementUsageCount(Purchase purchase, PurchaseCount purchaseCount, Integer decreaseCount) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(purchaseCount.getPaymentType())) continue;
            return paymentTypeService.decrementUsageCount(purchase.getExpiredDateTime(), purchaseCount, decreaseCount);
        }
        return new UsageCountResultVO(false, -1, -1);
    }

    public UsageCountResultVO addUsageCount(Purchase purchase, PurchaseCount purchaseCount, Integer decreaseCount) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(purchaseCount.getPaymentType())) continue;
            return paymentTypeService.addUsageCount(purchase.getExpiredDateTime(), purchaseCount, decreaseCount);
        }
        return new UsageCountResultVO(false, -1, -1);
    }

    public void deleteAuthorization(CancelAuth cancel) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(cancel.getPaymentType().intValue())) continue;
            paymentTypeService.deleteAuthorization(cancel);
        }
    }

    public Boolean checkObsoleteAuthEnable(CloudPurchaseDTO authInfo, ObsoleteTenantAuthInfo updateAuthInfo) {
        for (PaymentTypeService paymentTypeService : this.paymentTypeServices) {
            if (!paymentTypeService.support(authInfo.getPaymentType())) continue;
            return paymentTypeService.checkObsoleteAuthEnable(authInfo, updateAuthInfo);
        }
        return false;
    }
}

