/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.paymenttype.impl;

import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractPaymentTypeService {
    public void processAddModuleOrAction(CloudPurchaseDTO purchase, List<AuthorizationModuleVO> modulesToAdd) {
        if (modulesToAdd.isEmpty()) {
            return;
        }
        List dbModules = purchase.getModules();
        HashMap newModule2OldModule = new HashMap();
        modulesToAdd.forEach(module -> {
            EnabledModuleDTO target = dbModules.stream().filter(m -> m.getId().equals(module.getId())).findFirst().orElse(null);
            if (target != null) {
                newModule2OldModule.put(module, target);
                module.setActions(module.mergeActionString(target));
            }
        });
        dbModules.removeAll(dbModules);
        modulesToAdd.removeAll(newModule2OldModule.keySet());
        modulesToAdd.forEach(module -> dbModules.add(this.getNewModule(purchase, module)));
        for (Map.Entry entry : newModule2OldModule.entrySet()) {
            AuthorizationModuleVO newModule = (AuthorizationModuleVO)entry.getKey();
            EnabledModuleDTO modulesAboutToSave = (EnabledModuleDTO)entry.getValue();
            modulesAboutToSave.setActions(newModule.generateActionString());
            dbModules.add(modulesAboutToSave);
        }
    }

    public EnabledModuleDTO getNewModule(CloudPurchaseDTO purchase, AuthorizationModuleVO module) {
        return new EnabledModuleDTO(module.getId(), module.getName(), purchase.getTotalUsage(), purchase.getRemainingUsage(), LocalDateTime.now(), purchase.getExpiredDateTime(), module);
    }
}

