/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.paymenttype.impl;

import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.CalcExpire;
import com.digiwin.dap.middleware.cac.domain.CancelAuth;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EditParamVO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.ObsoleteTenantAuthInfo;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.CountPattern;
import com.digiwin.dap.middleware.cac.domain.enumeration.PaymentType;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.mapper.PurchaseCountMapper;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeRegistrarService;
import com.digiwin.dap.middleware.cac.service.paymenttype.CalcUtil;
import com.digiwin.dap.middleware.cac.service.paymenttype.PaymentTypeService;
import com.digiwin.dap.middleware.cac.service.paymenttype.impl.AbstractPaymentTypeService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentTypeCountByMonthServiceImpl
extends AbstractPaymentTypeService
implements PaymentTypeService {
    @Autowired
    private PurchaseCountMapper purchaseCountMapper;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private AuthorizeRegistrarService authorizeRegistrarService;
    @Autowired
    private EnvProperties envProperties;

    public boolean support(int paymentType) {
        return PaymentType.CountByMonth.ordinal() == paymentType;
    }

    public void decidePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        if (Boolean.TRUE.equals(domainPurchase.getMonthlyPlan())) {
            entityPurchase.setTotalUsage(domainPurchase.getTotalUsage());
            entityPurchase.setRemainingUsage(domainPurchase.getTotalUsage());
            entityPurchase.setMonthlyUsageBound(domainPurchase.getTotalUsage());
        } else {
            entityPurchase.setTotalUsage(domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
            entityPurchase.setRemainingUsage(domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
        }
        entityPurchase.setCountType(CountPattern.Unlimited.name());
        entityPurchase.setTotalCount(-1);
        CalcExpire calcExpire = CalcExpire.get((PurchaseVO)domainPurchase);
        entityPurchase.setExpiredDateTime(CalcUtil.calcNewPurchaseExpiredTime((CalcExpire)calcExpire));
        this.firstTimePurchaseProcessOfModules(entityPurchase, domainPurchase, calcExpire);
    }

    private void firstTimePurchaseProcessOfModules(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase, CalcExpire calcExpire) {
        entityPurchase.getModules().forEach(module -> {
            module.setTotalUsage(domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
            module.setRemainingUsage(module.getTotalUsage());
            module.setEffectiveTime(calcExpire.getEffectiveDateTime());
            calcExpire.module(module.getExpiredTime());
            module.setExpiredTime(CalcUtil.calcNewModuleExpiredTime((CalcExpire)calcExpire));
        });
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        if (Boolean.TRUE.equals(domainPurchase.getMonthlyPlan())) {
            this.decideUpdatePaymentTypeForMonthlyPlan(entityPurchase, domainPurchase);
        } else {
            this.decideUpdatePaymentTypeForGeneralPlan(entityPurchase, domainPurchase);
        }
    }

    private void decideUpdatePaymentTypeForMonthlyPlan(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        if (Boolean.TRUE.equals(domainPurchase.getSellingStrategy().getSupplyPackage())) {
            this.decideUpdatePaymentTypeForMonthlyPlanSupplyPackage(entityPurchase, domainPurchase);
            return;
        }
        if ("ManualAuthorization".equals(domainPurchase.getSourceId())) {
            entityPurchase.setTotalUsage(entityPurchase.getTotalUsage() + domainPurchase.getTotalUsage());
            entityPurchase.setRemainingUsage(entityPurchase.getRemainingUsage() + domainPurchase.getTotalUsage());
        } else {
            entityPurchase.setMonthlyUsageBound(domainPurchase.getTotalUsage());
            if (LocalDateTime.now().isAfter(entityPurchase.getExpiredDateTime())) {
                entityPurchase.setTotalUsage(domainPurchase.getTotalUsage());
                entityPurchase.setRemainingUsage(domainPurchase.getTotalUsage());
            }
        }
        entityPurchase.setMonthlyPlan(domainPurchase.getMonthlyPlan().booleanValue());
        entityPurchase.setTransferUnused(domainPurchase.getTransferUnused().booleanValue());
        entityPurchase.setStrategyId(domainPurchase.getSellingStrategy().getId());
        CalcExpire calcExpire = CalcExpire.get((PurchaseVO)domainPurchase, (LocalDateTime)entityPurchase.getExpiredDateTime());
        entityPurchase.setExpiredDateTime(CalcUtil.calcUpdatePurchaseExpiredTime((CalcExpire)calcExpire));
        this.purchaseUpdateProcessOfModules(entityPurchase, domainPurchase, calcExpire);
    }

    private void purchaseUpdateProcessOfModules(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase, CalcExpire calcExpire) {
        domainPurchase.getSellingStrategy().getEnabledModules().forEach(domainModule -> {
            EnabledModuleDTO entityModule = entityPurchase.getModules().stream().filter(m -> m.getId().equals(domainModule.getId())).findFirst().orElse(null);
            calcExpire.module(entityModule, domainModule);
            LocalDateTime moduleExpiredTime = CalcUtil.calcUpdateModuleExpiredTime((CalcExpire)calcExpire);
            if (entityModule == null) {
                entityPurchase.getModules().add(new EnabledModuleDTO(domainModule.getId(), domainModule.getName(), domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage(), domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage(), calcExpire.getNow(), moduleExpiredTime, domainModule));
            } else {
                entityModule.setName(domainModule.getName());
                entityModule.setTotalUsage(entityModule.getTotalUsage() + domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
                entityModule.setRemainingUsage(entityModule.getRemainingUsage() + domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
                entityModule.setExpiredTime(moduleExpiredTime);
                entityModule.setActions(domainModule.updateActionString(entityModule));
            }
            if (moduleExpiredTime.isAfter(entityPurchase.getExpiredDateTime())) {
                entityPurchase.setExpiredDateTime(moduleExpiredTime);
            }
        });
    }

    private void decideUpdatePaymentTypeForMonthlyPlanSupplyPackage(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setTotalUsage(entityPurchase.getTotalUsage() + domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
        entityPurchase.setRemainingUsage(entityPurchase.getRemainingUsage() + domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
    }

    private void decideUpdatePaymentTypeForGeneralPlan(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setStrategyId(domainPurchase.getSellingStrategy().getId());
        entityPurchase.setTotalUsage(entityPurchase.getTotalUsage() + domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
        entityPurchase.setRemainingUsage(entityPurchase.getRemainingUsage() + domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
        if (!Objects.equals(0, this.envProperties.getCloud())) {
            entityPurchase.setRemainingUsage(entityPurchase.getRemainingUsage() + domainPurchase.getTotalUsage() - entityPurchase.getTotalUsage());
            entityPurchase.setTotalUsage(domainPurchase.getTotalUsage());
        }
        CalcExpire calcExpire = CalcExpire.get((PurchaseVO)domainPurchase, (LocalDateTime)entityPurchase.getExpiredDateTime());
        entityPurchase.setExpiredDateTime(CalcUtil.calcUpdatePurchaseExpiredTime((CalcExpire)calcExpire));
        this.purchaseUpdateProcessOfModules(entityPurchase, domainPurchase, calcExpire);
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, EditParamVO editParamVO) {
        purchase.setTotalUsage(editParamVO.getTotalUsage().intValue());
        if (editParamVO.getRemainingUsage() != null) {
            purchase.setRemainingUsage(editParamVO.getRemainingUsage().intValue());
        }
        if (editParamVO.getMonthlyUsage() != null) {
            purchase.setMonthlyUsageBound(editParamVO.getMonthlyUsage().intValue());
        }
        purchase.setEffectiveDateTime(editParamVO.getEffectiveTime());
        purchase.setExpiredDateTime(editParamVO.getExpiredTime().with(LocalTime.MAX).withNano(0));
        if (editParamVO.getModules() != null) {
            editParamVO.getModules().forEach(module -> {
                EnabledModuleDTO target = purchase.getModules().stream().filter(m -> m.getId().equals(module.getId())).findFirst().orElse(null);
                if (target != null) {
                    target.setExpiredTime(module.getExpiredTime().with(LocalTime.MAX).withNano(0));
                    target.setTotalUsage(purchase.getTotalUsage());
                    target.setRemainingUsage(purchase.getRemainingUsage());
                    target.setEffectiveTime(editParamVO.getEffectiveTime());
                    target.setActions(module.updateActionString(target));
                    if (module.getExpiredTime().with(LocalTime.MAX).withNano(0).isAfter(editParamVO.getExpiredTime().with(LocalTime.MAX).withNano(0))) {
                        purchase.setExpiredDateTime(module.getExpiredTime().with(LocalTime.MAX).withNano(0));
                    }
                } else {
                    purchase.getModules().add(new EnabledModuleDTO(module.getId(), module.getName(), purchase.getTotalUsage(), purchase.getRemainingUsage(), editParamVO.getEffectiveTime(), module.getExpiredTime(), module));
                }
            });
        }
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, List<AuthorizationModuleVO> modules) {
        this.processAddModuleOrAction(purchase, modules);
    }

    public Boolean checkAuthorizationValid(CloudPurchaseDTO purchase) {
        return LocalDateTime.now().isAfter(purchase.getEffectiveDateTime()) && LocalDateTime.now().isBefore(purchase.getExpiredDateTime());
    }

    public Boolean checkModuleInvalid(int paymentType, EnabledModuleDTO module) {
        return LocalDateTime.now().isBefore(module.getExpiredTime()) && module.getRemainingUsage() > 0;
    }

    public UsageCountResultVO getAuthorizationCountingResult(AuthorizationVO authorizationVO, AuthorizationModuleVO module) {
        return new UsageCountResultVO(LocalDateTime.now().isBefore(module.getExpiredTime()) && authorizationVO.getRemainingUsage() > 0, authorizationVO.getRemainingUsage(), authorizationVO.getTotalUsage());
    }

    public UsageCountResultVO decrementUsageCount(LocalDateTime expiredDateTime, PurchaseCount purchaseCount, Integer decreaseCount) {
        if (Objects.isNull(decreaseCount)) {
            decreaseCount = 1;
        }
        if (purchaseCount.getRemainUsageBound() > 0 && LocalDateTime.now().isBefore(expiredDateTime)) {
            purchaseCount.setRemainUsageBound(purchaseCount.getRemainUsageBound() - decreaseCount);
            this.purchaseCountCrudService.updateByPurchaseId(purchaseCount);
            return new UsageCountResultVO(true, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
        }
        return new UsageCountResultVO(false, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
    }

    public UsageCountResultVO addUsageCount(LocalDateTime expiredDateTime, PurchaseCount purchaseCount, Integer decreaseCount) {
        if (Objects.isNull(decreaseCount)) {
            decreaseCount = 1;
        }
        if (purchaseCount.getRemainUsageBound() + decreaseCount <= purchaseCount.getTotalUsageBound() && LocalDateTime.now().isBefore(expiredDateTime)) {
            purchaseCount.setRemainUsageBound(purchaseCount.getRemainUsageBound() + decreaseCount);
            this.purchaseCountCrudService.updateByPurchaseId(purchaseCount);
            return new UsageCountResultVO(true, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
        }
        return new UsageCountResultVO(false, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
    }

    public void deleteAuthorization(CancelAuth cancel) {
        CancelAuth old = this.purchaseCountMapper.findPurchase(cancel.getTenantId(), cancel.getGoodsSid());
        if (old == null) {
            return;
        }
        if (!Objects.equals(old.getPaymentType(), cancel.getPaymentType())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10002, new Object[]{cancel.getPaymentType(), old.getPaymentType()});
        }
        int leftUsage = old.getRemainUsage() - cancel.getTotalUsage();
        if (leftUsage == 0) {
            this.authorizeRegistrarService.deleteByTenantIdAndGoodsSid(cancel.getTenantId(), cancel.getGoodsSid());
        } else if (leftUsage > 0) {
            PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(old.getPurchaseId());
            if (purchaseCount != null) {
                purchaseCount.setTotalUsageBound(purchaseCount.getTotalUsageBound() - cancel.getTotalUsage());
                purchaseCount.setRemainUsageBound(purchaseCount.getRemainUsageBound() - cancel.getTotalUsage());
                this.purchaseCountCrudService.updateByPurchaseId(purchaseCount);
            }
        } else {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10003, new Object[]{old.getRemainUsage(), cancel.getTotalUsage()});
        }
    }

    public Boolean checkObsoleteAuthEnable(CloudPurchaseDTO authInfo, ObsoleteTenantAuthInfo updateAuthInfo) {
        if (null != updateAuthInfo.getOldExpiredDateTime() && null != updateAuthInfo.getOldTotalUsageBound()) {
            boolean expireDate = updateAuthInfo.getPlatform() != false ? updateAuthInfo.getOldExpiredDateTime().isBefore(authInfo.getExpiredDateTime()) : !updateAuthInfo.getExpiredDateTime().equals(authInfo.getExpiredDateTime());
            boolean totalUsage = !updateAuthInfo.getTotalCountBound().equals(authInfo.getTotalUsage());
            return expireDate || totalUsage;
        }
        boolean expireDate = updateAuthInfo.getExpiredDateTime().isBefore(authInfo.getExpiredDateTime());
        boolean totalUsage = updateAuthInfo.getTotalUsageBound() < authInfo.getTotalUsage();
        return expireDate || totalUsage;
    }
}

