/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.paymenttype.impl;

import com.digiwin.dap.middleware.cac.constant.CacConstants;
import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.CalcExpire;
import com.digiwin.dap.middleware.cac.domain.CancelAuth;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EditParamVO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.ObsoleteTenantAuthInfo;
import com.digiwin.dap.middleware.cac.domain.PurchaseCountLogVO;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.CountPattern;
import com.digiwin.dap.middleware.cac.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.cac.domain.enumeration.PaymentType;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.mapper.PurchaseCountMapper;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeRegistrarService;
import com.digiwin.dap.middleware.cac.service.paymenttype.CalcUtil;
import com.digiwin.dap.middleware.cac.service.paymenttype.PaymentTypeService;
import com.digiwin.dap.middleware.cac.service.paymenttype.impl.AbstractPaymentTypeService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentTypeCountServiceImpl
extends AbstractPaymentTypeService
implements PaymentTypeService {
    @Autowired
    private PurchaseCountMapper purchaseCountMapper;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private AuthorizeRegistrarService authorizeRegistrarService;
    @Autowired
    private EnvProperties envProperties;

    public boolean support(int paymentType) {
        return PaymentType.Count.ordinal() == paymentType;
    }

    public void decidePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setCountType(CountPattern.Unlimited.name());
        entityPurchase.setTotalCount(-1);
        entityPurchase.setTotalUsage(domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
        entityPurchase.setRemainingUsage(domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
        entityPurchase.setExpiredDateTime(CacConstants.PERMANENT_TIME);
        if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(domainPurchase.getCategoryId())) {
            CalcExpire calcExpire = CalcExpire.get((PurchaseVO)domainPurchase, (LocalDateTime)domainPurchase.getExpiredTime());
            entityPurchase.setExpiredDateTime(CalcUtil.calcNewPurchaseExpiredTime((CalcExpire)calcExpire));
            PurchaseCountLogVO currentAuthInfo = new PurchaseCountLogVO(entityPurchase, domainPurchase, entityPurchase.getExpiredDateTime());
            entityPurchase.setCurrentAuthInfo(currentAuthInfo);
        }
        entityPurchase.getModules().forEach(module -> {
            module.setTotalUsage(domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
            module.setRemainingUsage(module.getTotalUsage());
            module.setEffectiveTime(entityPurchase.getEffectiveDateTime());
            module.setExpiredTime(CacConstants.PERMANENT_TIME);
        });
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setStrategyId(domainPurchase.getSellingStrategy().getId());
        entityPurchase.setTotalUsage(entityPurchase.getTotalUsage() + domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
        entityPurchase.setRemainingUsage(entityPurchase.getRemainingUsage() + domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
        if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(domainPurchase.getCategoryId())) {
            CalcExpire calcExpire = CalcExpire.get((PurchaseVO)domainPurchase, (LocalDateTime)entityPurchase.getExpiredDateTime());
            entityPurchase.setExpiredDateTime(CalcUtil.calcUpdatePurchaseExpiredTime((CalcExpire)calcExpire));
            PurchaseCountLogVO currentAuthInfo = new PurchaseCountLogVO(entityPurchase, domainPurchase, CalcUtil.calcUpdateResourcePurchaseExpiredTime((CalcExpire)calcExpire));
            entityPurchase.setCurrentAuthInfo(currentAuthInfo);
        }
        if (!Objects.equals(0, this.envProperties.getCloud())) {
            entityPurchase.setTotalUsage(domainPurchase.getTotalUsage());
            entityPurchase.setRemainingUsage(entityPurchase.getRemainingUsage() + domainPurchase.getTotalUsage() - entityPurchase.getTotalUsage());
        }
        domainPurchase.getSellingStrategy().getEnabledModules().forEach(module -> {
            EnabledModuleDTO target = entityPurchase.getModules().stream().filter(m -> m.getId().equals(module.getId())).findFirst().orElse(null);
            if (target == null) {
                entityPurchase.getModules().add(new EnabledModuleDTO(module.getId(), module.getName(), domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage(), domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage(), LocalDateTime.now(), CacConstants.PERMANENT_TIME, module));
            } else {
                target.setName(module.getName());
                target.setTotalUsage(target.getTotalUsage() + domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
                target.setRemainingUsage(target.getRemainingUsage() + domainPurchase.getOrderNumber() * domainPurchase.getTotalUsage());
                target.setActions(module.updateActionString(target));
            }
        });
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, EditParamVO editParamVO) {
        purchase.setTotalUsage(editParamVO.getTotalUsage().intValue());
        if (editParamVO.getRemainingUsage() != null) {
            purchase.setRemainingUsage(editParamVO.getRemainingUsage().intValue());
        }
        purchase.setEffectiveDateTime(editParamVO.getEffectiveTime());
        purchase.setExpiredDateTime(CacConstants.PERMANENT_TIME);
        editParamVO.getModules().forEach(module -> {
            EnabledModuleDTO target = purchase.getModules().stream().filter(m -> m.getId().equals(module.getId())).findFirst().orElse(null);
            if (target == null) {
                purchase.getModules().add(new EnabledModuleDTO(module.getId(), module.getName(), purchase.getTotalUsage(), purchase.getRemainingUsage(), editParamVO.getEffectiveTime(), CacConstants.PERMANENT_TIME, module));
            } else {
                target.setTotalUsage(purchase.getTotalUsage());
                target.setRemainingUsage(purchase.getRemainingUsage());
                target.setEffectiveTime(editParamVO.getEffectiveTime());
                target.setActions(module.updateActionString(target));
            }
        });
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, List<AuthorizationModuleVO> modules) {
        this.processAddModuleOrAction(purchase, modules);
    }

    public EnabledModuleDTO getNewModule(CloudPurchaseDTO purchase, AuthorizationModuleVO module) {
        return new EnabledModuleDTO(module.getId(), module.getName(), purchase.getTotalUsage(), purchase.getRemainingUsage(), LocalDateTime.now(), CacConstants.PERMANENT_TIME, module);
    }

    public Boolean checkAuthorizationValid(CloudPurchaseDTO purchase) {
        return true;
    }

    public Boolean checkModuleInvalid(int paymentType, EnabledModuleDTO module) {
        return module.getRemainingUsage() > 0;
    }

    public UsageCountResultVO getAuthorizationCountingResult(AuthorizationVO authorizationVO, AuthorizationModuleVO module) {
        return new UsageCountResultVO(authorizationVO.getRemainingUsage() > 0, authorizationVO.getRemainingUsage(), authorizationVO.getTotalUsage());
    }

    public UsageCountResultVO decrementUsageCount(LocalDateTime expiredDateTime, PurchaseCount purchaseCount, Integer decreaseCount) {
        if (Objects.isNull(decreaseCount)) {
            decreaseCount = 1;
        }
        if (purchaseCount.getRemainUsageBound() > 0) {
            int remainUsageBound = this.purchaseCountCrudService.updateRemainUsageBound(decreaseCount.intValue(), purchaseCount.getPurchaseId());
            return new UsageCountResultVO(true, remainUsageBound, purchaseCount.getTotalUsageBound());
        }
        return new UsageCountResultVO(false, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
    }

    public UsageCountResultVO addUsageCount(LocalDateTime expiredDateTime, PurchaseCount purchaseCount, Integer decreaseCount) {
        if (Objects.isNull(decreaseCount)) {
            decreaseCount = 1;
        }
        if (purchaseCount.getRemainUsageBound() + decreaseCount <= purchaseCount.getTotalUsageBound() && LocalDateTime.now().isBefore(expiredDateTime)) {
            purchaseCount.setRemainUsageBound(purchaseCount.getRemainUsageBound() + decreaseCount);
            this.purchaseCountCrudService.updateByPurchaseId(purchaseCount);
            return new UsageCountResultVO(true, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
        }
        return new UsageCountResultVO(false, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
    }

    public void deleteAuthorization(CancelAuth cancel) {
        CancelAuth old = this.purchaseCountMapper.findPurchase(cancel.getTenantId(), cancel.getGoodsSid());
        if (old == null) {
            return;
        }
        if (!Objects.equals(old.getPaymentType(), cancel.getPaymentType())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10002, new Object[]{cancel.getPaymentType(), old.getPaymentType()});
        }
        int leftUsage = old.getRemainUsage() - cancel.getTotalUsage();
        if (leftUsage == 0) {
            this.authorizeRegistrarService.deleteByTenantIdAndGoodsSid(cancel.getTenantId(), cancel.getGoodsSid());
        } else if (leftUsage > 0) {
            PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(old.getPurchaseId());
            if (purchaseCount != null) {
                purchaseCount.setTotalUsageBound(purchaseCount.getTotalUsageBound() - cancel.getTotalUsage());
                purchaseCount.setRemainUsageBound(purchaseCount.getRemainUsageBound() - cancel.getTotalUsage());
                this.purchaseCountCrudService.updateByPurchaseId(purchaseCount);
            }
        } else {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10003, new Object[]{old.getRemainUsage(), cancel.getTotalUsage()});
        }
    }

    public Boolean checkObsoleteAuthEnable(CloudPurchaseDTO authInfo, ObsoleteTenantAuthInfo updateAuthInfo) {
        if (null != updateAuthInfo.getOldExpiredDateTime() && null != updateAuthInfo.getOldTotalUsageBound()) {
            boolean expireDate = updateAuthInfo.getPlatform() != false ? updateAuthInfo.getOldExpiredDateTime().isBefore(authInfo.getExpiredDateTime()) : !updateAuthInfo.getExpiredDateTime().equals(authInfo.getExpiredDateTime());
            boolean totalUsage = !updateAuthInfo.getTotalCountBound().equals(authInfo.getTotalUsage());
            return expireDate || totalUsage;
        }
        boolean expireDate = updateAuthInfo.getExpiredDateTime().isBefore(authInfo.getExpiredDateTime());
        boolean totalUsage = updateAuthInfo.getTotalUsageBound() < authInfo.getTotalUsage();
        return expireDate || totalUsage;
    }
}

